/*
 *  OpenmlApiConnector - Java integration of the OpenML Web API
 *  Copyright (C) 2014 
 *  @author Jan N. van Rijn (j.n.van.rijn@liacs.leidenuniv.nl)
 *  
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *  
 */
package org.openml.apiconnector.settings;

public class Constants {
	
	/**
	 * When doing an Api Request with an API session hash which is valid for
	 * less than the DEFAULT_TIME_MARGIN, a new session hash will be loaded. 
	 */
	public static final int DEFAULT_TIME_MARGIN = 300000; // 5 minutes
	
	/**
	 * Default Dataset format
	 */
	public static final String DATASET_FORMAT = "arff";
	
	/**
	 * Default XMLNS String to be included in generated XML files.
	 */
	public static final String OPENML_XMLNS = "http://openml.org/openml";
	
	public static final int VERBOSE_LEVEL_XML = 1;
	public static final int VERBOSE_LEVEL_ARFF = 2;
}
