/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.algorithms;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import org.openml.apiconnector.algorithms.DateParser;

public class Conversion {
    public static File stringToTempFile(String string, String filename, String format) throws IOException {
        File file = File.createTempFile(filename, '.' + format);
        BufferedWriter br = new BufferedWriter(new FileWriter(file));
        br.write(string);
        br.close();
        file.deleteOnExit();
        return file;
    }

    public static int[] commaSeparatedStringToIntArray(String commaSeparated) throws NumberFormatException {
        String[] splitted = commaSeparated.replaceAll("\\s", "").split(",");
        int[] result = new int[splitted.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Integer.parseInt(splitted[i]);
        }
        return result;
    }

    public static String fileToString(File f) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        StringBuilder sb = new StringBuilder();
        String line = br.readLine();
        while (line != null) {
            sb.append(line + "\n");
            line = br.readLine();
        }
        br.close();
        return sb.toString();
    }

    public static void log(String status, String action, String message) {
        Conversion.log(status, action, message, System.err);
    }

    public static void log(String status, String action, String message, PrintStream writer) {
        writer.println("[" + DateParser.humanReadable.format(System.currentTimeMillis()) + "] [" + status + "] [" + action + "] " + message);
    }
}

