/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.io;

import java.io.Serializable;
import java.util.Date;
import java.util.zip.DataFormatException;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.openml.apiconnector.algorithms.DateParser;
import org.openml.apiconnector.algorithms.Hashing;
import org.openml.apiconnector.io.HttpConnector;
import org.openml.apiconnector.xml.Authenticate;

class ApiSessionHash
implements Serializable {
    private static final long serialVersionUID = 7831245113631L;
    private final String server;
    private String username;
    private String password;
    private String sessionHash;
    private long validUntil;

    public ApiSessionHash(String server) {
        this.server = server;
        this.sessionHash = null;
        this.username = null;
    }

    public boolean isValid() {
        Date utilDate = new Date();
        return this.validUntil > utilDate.getTime() + 300000L;
    }

    public boolean set(String username, String password) {
        this.username = username;
        this.password = password;
        try {
            this.update();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void update() throws Exception {
        Authenticate auth = this.openmlAuthenticate(this.username, this.password);
        this.validUntil = DateParser.mysqlDateToTimeStamp(auth.getValidUntil(), auth.getTimezone());
        this.sessionHash = auth.getSessionHash();
    }

    public String getUsername() {
        return this.username;
    }

    public String getSessionHash() throws Exception {
        if (!this.isValid()) {
            this.update();
        }
        return this.sessionHash;
    }

    public boolean checkCredentials(String username, String password) {
        try {
            this.openmlAuthenticate(username, password);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean checkCredentials() {
        try {
            this.openmlAuthenticate(this.username, this.password);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Authenticate openmlAuthenticate() throws Exception {
        return this.openmlAuthenticate(this.username, this.password);
    }

    private Authenticate openmlAuthenticate(String username, String password) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("username", (ContentBody)new StringBody(username));
        params.addPart("password", (ContentBody)new StringBody(Hashing.md5(password)));
        Object apiResult = HttpConnector.doApiRequest(this.server, "openml.authenticate", "", params, null);
        if (apiResult instanceof Authenticate) {
            return (Authenticate)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Authenticate");
    }
}

