/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.io;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.openml.apiconnector.io.ApiException;
import org.openml.apiconnector.io.ApiSessionHash;
import org.openml.apiconnector.settings.Settings;
import org.openml.apiconnector.xml.ApiError;
import org.openml.apiconnector.xstream.XstreamXmlMapping;

public class HttpConnector
implements Serializable {
    public static final String API_PART = "rest_api/";
    private static final long serialVersionUID = -8589069573065947493L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doApiRequest(String url, String function, String queryString, MultipartEntity entity, ApiSessionHash ash) throws Exception {
        Object apiResult;
        long contentLength;
        String requestUri;
        String result;
        XStream xstream;
        block14: {
            xstream = XstreamXmlMapping.getInstance();
            if (ash != null) {
                if (entity == null) {
                    entity = new MultipartEntity();
                }
                entity.addPart("session_hash", (ContentBody)new StringBody(ash.getSessionHash()));
            }
            result = "";
            DefaultHttpClient httpclient = new DefaultHttpClient();
            requestUri = url + API_PART + "?f=" + function;
            if (queryString != null) {
                requestUri = requestUri + queryString;
            }
            contentLength = 0L;
            try {
                HttpResponse response;
                HttpEntity resEntity;
                HttpPost httppost = new HttpPost(requestUri);
                if (entity != null) {
                    httppost.setEntity((HttpEntity)entity);
                }
                if ((resEntity = (response = httpclient.execute((HttpUriRequest)httppost)).getEntity()) != null) {
                    result = HttpConnector.httpEntitiToString(resEntity);
                    contentLength = resEntity.getContentLength();
                    break block14;
                }
                throw new Exception("An exception has occured while reading data input stream. ");
            }
            finally {
                try {
                    httpclient.getConnectionManager().shutdown();
                }
                catch (Exception ignore) {}
            }
        }
        if (Settings.API_VERBOSE_LEVEL >= 1) {
            System.out.println("===== REQUEST URI: " + requestUri + " (Content Length: " + contentLength + ") =====\n" + result + "\n=====\n");
        }
        if ((apiResult = xstream.fromXML(result)) instanceof ApiError) {
            ApiError apiError = (ApiError)apiResult;
            throw new ApiException(Integer.parseInt(apiError.getCode()), apiError.getMessage());
        }
        return apiResult;
    }

    public static Object doApiRequest(String url, String function, String queryString, ApiSessionHash ash) throws Exception {
        return HttpConnector.doApiRequest(url, function, queryString, null, ash);
    }

    private static String httpEntitiToString(HttpEntity resEntity) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((Reader)new InputStreamReader(resEntity.getContent()), (Writer)writer);
        return writer.toString();
    }
}

