/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.io;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.zip.DataFormatException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.json.JSONObject;
import org.openml.apiconnector.algorithms.Conversion;
import org.openml.apiconnector.io.ApiSessionHash;
import org.openml.apiconnector.io.HttpConnector;
import org.openml.apiconnector.settings.Settings;
import org.openml.apiconnector.xml.Authenticate;
import org.openml.apiconnector.xml.DataFeature;
import org.openml.apiconnector.xml.DataFeatureUpload;
import org.openml.apiconnector.xml.DataQuality;
import org.openml.apiconnector.xml.DataQualityList;
import org.openml.apiconnector.xml.DataQualityUpload;
import org.openml.apiconnector.xml.DataSetDescription;
import org.openml.apiconnector.xml.Implementation;
import org.openml.apiconnector.xml.ImplementationDelete;
import org.openml.apiconnector.xml.ImplementationExists;
import org.openml.apiconnector.xml.ImplementationOwned;
import org.openml.apiconnector.xml.Job;
import org.openml.apiconnector.xml.RunDelete;
import org.openml.apiconnector.xml.RunEvaluate;
import org.openml.apiconnector.xml.RunReset;
import org.openml.apiconnector.xml.Task;
import org.openml.apiconnector.xml.TaskEvaluations;
import org.openml.apiconnector.xml.UploadDataSet;
import org.openml.apiconnector.xml.UploadImplementation;
import org.openml.apiconnector.xml.UploadRun;
import org.openml.apiconnector.xstream.XstreamXmlMapping;

public class OpenmlConnector
implements Serializable {
    private static final long serialVersionUID = 7362620508675762264L;
    private final ApiSessionHash ash;
    private final String API_URL;

    public OpenmlConnector(String url) {
        this.API_URL = url;
        this.ash = new ApiSessionHash(this.API_URL);
    }

    public OpenmlConnector() {
        this.API_URL = "http://www.openml.org/";
        this.ash = new ApiSessionHash(this.API_URL);
    }

    public OpenmlConnector(String username, String password) {
        this.API_URL = "http://www.openml.org/";
        this.ash = new ApiSessionHash(this.API_URL);
        this.ash.set(username, password);
    }

    public OpenmlConnector(String url, String username, String password) {
        this.API_URL = url;
        this.ash = new ApiSessionHash(url);
        this.ash.set(username, password);
    }

    public boolean setCredentials(String username, String password) {
        return this.ash.set(username, password);
    }

    public boolean checkCredentials() {
        return this.ash.checkCredentials();
    }

    public boolean checkCredentials(String username, String password) {
        return this.ash.checkCredentials(username, password);
    }

    public String getSessionHash() throws Exception {
        return this.ash.getSessionHash();
    }

    public String getApiUrl() {
        return this.API_URL + "rest_api/";
    }

    public Authenticate openmlAuthenticate() throws Exception {
        return this.ash.openmlAuthenticate();
    }

    public DataSetDescription openmlDataGet(int did) throws Exception {
        return this.openmlDataDescription(did);
    }

    public DataSetDescription openmlDataDescription(int did) throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.data.description", "&data_id=" + did, this.ash);
        if (apiResult instanceof DataSetDescription) {
            return (DataSetDescription)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataSetDescription");
    }

    public DataFeature openmlDataFeatures(int did) throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.data.features", "&data_id=" + did, this.ash);
        if (apiResult instanceof DataFeature) {
            return (DataFeature)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataFeature");
    }

    public DataQuality openmlDataQuality(int did) throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.data.qualities", "&data_id=" + did, this.ash);
        if (apiResult instanceof DataQuality) {
            return (DataQuality)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataQuality");
    }

    public DataQuality openmlDataQuality(Integer did, Integer interval_start, Integer interval_end, Integer interval_size) throws Exception {
        Object apiResult;
        String queryString = "&data_id=" + did;
        if (interval_start != null) {
            queryString = queryString + "&interval_start=" + interval_start;
        }
        if (interval_end != null) {
            queryString = queryString + "&interval_end=" + interval_end;
        }
        if (interval_size != null) {
            queryString = queryString + "&interval_size=" + interval_size;
        }
        if ((apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.data.qualities", queryString, this.ash)) instanceof DataQuality) {
            return (DataQuality)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataQuality");
    }

    public DataFeatureUpload openmlDataFeatureUpload(File description) throws Exception {
        Object apiResult;
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        if (Settings.API_VERBOSE_LEVEL >= 2) {
            System.out.println(Conversion.fileToString(description) + "\n==========\n");
        }
        if ((apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.data.features.upload", "", params, this.ash)) instanceof DataFeatureUpload) {
            return (DataFeatureUpload)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataFeatureUpload");
    }

    public DataQualityUpload openmlDataQualityUpload(File description) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        Object apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.data.qualities.upload", "", params, this.ash);
        if (apiResult instanceof DataQualityUpload) {
            return (DataQualityUpload)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataQualityUpload");
    }

    public DataQualityList openmlDataQualityList() throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.data.qualities.list", "", this.ash);
        if (apiResult instanceof DataQualityList) {
            return (DataQualityList)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataQualityList");
    }

    public Implementation openmlImplementationGet(int implementation_id) throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.implementation.get", "&implementation_id=" + implementation_id, this.ash);
        if (apiResult instanceof Implementation) {
            return (Implementation)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Implementation");
    }

    public ImplementationOwned openmlImplementationOwned() throws Exception {
        MultipartEntity params = new MultipartEntity();
        Object apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.implementation.owned", "", params, this.ash);
        if (apiResult instanceof ImplementationOwned) {
            return (ImplementationOwned)apiResult;
        }
        throw new DataFormatException("Casting Api Object to ImplementationOwned");
    }

    public ImplementationDelete openmlImplementationDelete(int id) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("implementation_id", (ContentBody)new StringBody("" + id));
        Object apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.implementation.delete", "", params, this.ash);
        if (apiResult instanceof ImplementationDelete) {
            return (ImplementationDelete)apiResult;
        }
        throw new DataFormatException("Casting Api Object to ImplementationDelete");
    }

    public ImplementationExists openmlImplementationExists(String name, String external_version) throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.implementation.exists", "&name=" + name + "&external_version=" + external_version, this.ash);
        if (apiResult instanceof ImplementationExists) {
            return (ImplementationExists)apiResult;
        }
        throw new DataFormatException("Casting Api Object to ImplementationExists");
    }

    public Task openmlTaskSearch(int task_id) throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.task.search", "&task_id=" + task_id, this.ash);
        if (apiResult instanceof Task) {
            return (Task)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Task");
    }

    public Task openmlTaskGet(int task_id) throws Exception {
        return this.openmlTaskSearch(task_id);
    }

    public TaskEvaluations openmlTaskEvaluations(int task_id) throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.task.evaluations", "&task_id=" + task_id, this.ash);
        if (apiResult instanceof TaskEvaluations) {
            return (TaskEvaluations)apiResult;
        }
        throw new DataFormatException("Casting Api Object to TaskEvaluations");
    }

    public TaskEvaluations openmlTaskEvaluations(Integer task_id, Integer interval_start, Integer interval_end, Integer interval_size) throws Exception {
        Object apiResult;
        String queryString = "&task_id=" + task_id;
        if (interval_start != null) {
            queryString = queryString + "&interval_start=" + interval_start;
        }
        if (interval_end != null) {
            queryString = queryString + "&interval_end=" + interval_end;
        }
        if (interval_size != null) {
            queryString = queryString + "&interval_size=" + interval_size;
        }
        if ((apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.task.evaluations", queryString, this.ash)) instanceof TaskEvaluations) {
            return (TaskEvaluations)apiResult;
        }
        throw new DataFormatException("Casting Api Object to TaskEvaluations");
    }

    public UploadDataSet openmlDataUpload(File description, File dataset) throws Exception {
        Object apiResult;
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        if (dataset != null) {
            params.addPart("dataset", (ContentBody)new FileBody(dataset));
        }
        if ((apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.data.upload", "", params, this.ash)) instanceof UploadDataSet) {
            return (UploadDataSet)apiResult;
        }
        throw new DataFormatException("Casting Api Object to UploadDataSet");
    }

    public UploadDataSet openmlDataUpload(DataSetDescription description, File dataset) throws Exception {
        XStream xstream = XstreamXmlMapping.getInstance();
        return this.openmlDataUpload(Conversion.stringToTempFile(xstream.toXML((Object)description), "description", "xml"), dataset);
    }

    public UploadDataSet openmlDataUpload(File description) throws Exception {
        return this.openmlDataUpload(description, null);
    }

    public UploadImplementation openmlImplementationUpload(File description, File binary, File source) throws Exception {
        Object apiResult;
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        if (source != null) {
            params.addPart("source", (ContentBody)new FileBody(source));
        }
        if (binary != null) {
            params.addPart("binary", (ContentBody)new FileBody(binary));
        }
        if ((apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.implementation.upload", "", params, this.ash)) instanceof UploadImplementation) {
            return (UploadImplementation)apiResult;
        }
        throw new DataFormatException("Casting Api Object to UploadImplementation");
    }

    public UploadRun openmlRunUpload(File description, Map<String, File> output_files) throws Exception {
        MultipartEntity params = new MultipartEntity();
        if (Settings.API_VERBOSE_LEVEL >= 2) {
            System.out.println(Conversion.fileToString(output_files.get("predictions")) + "\n==========\n");
        }
        if (Settings.API_VERBOSE_LEVEL >= 1) {
            System.out.println(Conversion.fileToString(description) + "\n==========");
        }
        params.addPart("description", (ContentBody)new FileBody(description));
        for (String s : output_files.keySet()) {
            params.addPart(s, (ContentBody)new FileBody(output_files.get(s)));
        }
        Object apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.run.upload", "", params, this.ash);
        if (apiResult instanceof UploadRun) {
            return (UploadRun)apiResult;
        }
        throw new DataFormatException("Casting Api Object to UploadRun");
    }

    public RunEvaluate openmlRunEvaluate(File description) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        Object apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.run.evaluate", "", params, this.ash);
        if (apiResult instanceof RunEvaluate) {
            return (RunEvaluate)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunEvaluate");
    }

    public RunDelete openmlRunDelete(int id) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("run_id", (ContentBody)new StringBody("" + id));
        Object apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.run.delete", "", params, this.ash);
        if (apiResult instanceof RunDelete) {
            return (RunDelete)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunDelete");
    }

    public RunReset openmlRunReset(int run_id) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("run_id", (ContentBody)new StringBody("" + run_id));
        Object apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.run.reset", "", params, this.ash);
        if (apiResult instanceof RunReset) {
            return (RunReset)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunReset");
    }

    public Job openmlJobGet(String workbench, String task_type_id) throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.API_URL, "openml.job.get", "&workbench=" + workbench + "&task_type_id=" + task_type_id, this.ash);
        if (apiResult instanceof Job) {
            return (Job)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Job");
    }

    public JSONObject openmlFreeQuery(String sql) throws Exception {
        return new JSONObject(OpenmlConnector.getStringFromUrl(this.API_URL + "api_query/?q=" + URLEncoder.encode(sql, "ISO-8859-1") + "&hash=" + this.getSessionHash()));
    }

    public static String getStringFromUrl(String url) throws IOException {
        String result = IOUtils.toString((URL)new URL(url));
        if (Settings.API_VERBOSE_LEVEL >= 1) {
            System.out.println("===== REQUEST URI: " + url + " (Content Length: " + result.length() + ") =====\n" + result + "\n=====\n");
        }
        return result;
    }

    public static File getFileFromUrl(String url, String filepath) throws IOException {
        File file = new File(filepath);
        FileUtils.copyURLToFile((URL)new URL(url), (File)file);
        return file;
    }

    public URL getOpenmlFileUrl(int id, String filename) throws Exception {
        if (filename == null) {
            filename = "file";
        }
        String suffix = "?session_hash=" + this.ash.getSessionHash();
        return new URL(this.API_URL + "data/download/" + id + "/" + filename + suffix);
    }
}

