/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.openml.apiconnector.algorithms.Conversion;

public class Config {
    private boolean loaded = false;
    private HashMap<String, String> config;

    public Config() {
        try {
            this.load(new File("openml.conf"));
        }
        catch (IOException ioe) {
            Conversion.log("Warning", "Load Config", "Could not locate default config file.");
        }
    }

    public Config(String config) {
        this.process(Arrays.asList(config.split(";")));
    }

    private void load(File f) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        ArrayList<String> lines = new ArrayList<String>();
        while (br.ready()) {
            lines.add(br.readLine());
        }
        br.close();
        this.process(lines);
    }

    private void process(List<String> lines) {
        this.config = new HashMap();
        for (String line : lines) {
            String[] l = line.split("=");
            if (l.length != 2) continue;
            this.config.put(l[0].trim(), l[1].trim());
        }
        this.loaded = true;
    }

    public String getUsername() {
        return this.get("username");
    }

    public String getPassword() {
        return this.get("password");
    }

    public String getServer() {
        return this.get("server");
    }

    public String get(String key) {
        if (this.loaded && this.config.containsKey(key)) {
            return this.config.get(key);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.config.keySet()) {
            if (s.equals("password")) {
                sb.append(s + "=" + this.config.get(s).length() + "chars\n");
                continue;
            }
            sb.append(s + "=" + this.config.get(s) + "\n");
        }
        return sb.toString();
    }
}

