/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.xml;

import org.openml.apiconnector.algorithms.MathHelper;

public class EvaluationScore {
    private final String function;
    private final String implementation;
    private final String value;
    private final Double stdev;
    private final String array_data;
    private final Integer repeat;
    private final Integer fold;
    private final Integer sample;
    private Integer sample_size;
    private final Integer interval_start;
    private final Integer interval_end;

    public EvaluationScore(String implementation, String function, String value, Double stdev, String array_data) {
        this.implementation = implementation;
        this.function = function;
        this.value = value;
        this.stdev = stdev;
        this.array_data = array_data;
        this.repeat = null;
        this.fold = null;
        this.sample = null;
        this.sample_size = null;
        this.interval_start = null;
        this.interval_end = null;
    }

    public EvaluationScore(String implementation, String function, String value, String array_data, Integer repeat, Integer fold) {
        this.implementation = implementation;
        this.function = function;
        this.value = value;
        this.array_data = array_data;
        this.fold = fold;
        this.repeat = repeat;
        this.sample = null;
        this.sample_size = null;
        this.interval_start = null;
        this.interval_end = null;
        this.stdev = null;
    }

    public EvaluationScore(String implementation, String function, String value, String array_data, Integer repeat, Integer fold, Integer sample, Integer sample_size) {
        this.implementation = implementation;
        this.function = function;
        this.value = value;
        this.array_data = array_data;
        this.fold = fold;
        this.repeat = repeat;
        this.sample = sample;
        this.sample_size = sample_size;
        this.interval_start = null;
        this.interval_end = null;
        this.stdev = null;
    }

    public EvaluationScore(String implementation, String function, String value, String array_data, Integer interval_start, Integer interval_end, boolean dummy) {
        this.implementation = implementation;
        this.function = function;
        this.value = value;
        this.array_data = array_data;
        this.interval_start = interval_start;
        this.interval_end = interval_end;
        this.repeat = null;
        this.fold = null;
        this.sample = null;
        this.sample_size = null;
        this.stdev = null;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public String getFunction() {
        return this.function;
    }

    public String getValue() {
        return this.value;
    }

    public double getStdev() {
        return this.stdev;
    }

    public String getArray_data() {
        return this.array_data;
    }

    public Integer getFold() {
        return this.fold;
    }

    public Integer getRepeat() {
        return this.repeat;
    }

    public Integer getSample() {
        return this.sample;
    }

    public void setSample_size(int sample_size) {
        this.sample_size = sample_size;
    }

    public Integer getSample_size() {
        return this.sample_size;
    }

    public Integer getInterval_start() {
        return this.interval_start;
    }

    public Integer getInterval_end() {
        return this.interval_end;
    }

    public boolean isSame(EvaluationScore other) {
        return EvaluationScore.equalStrings(this.implementation, other.getImplementation()) && EvaluationScore.equalStrings(this.function, other.getFunction()) && EvaluationScore.equalIntegers(this.fold, other.getFold()) && EvaluationScore.equalIntegers(this.repeat, other.getRepeat()) && EvaluationScore.equalIntegers(this.sample, other.getSample()) && EvaluationScore.equalIntegers(this.interval_start, other.getInterval_start()) && EvaluationScore.equalIntegers(this.interval_end, other.getInterval_end());
    }

    public boolean sameValue(EvaluationScore other) {
        try {
            double myValue = Double.parseDouble(this.value);
            double otherValue = Double.parseDouble(other.getValue());
            return Math.abs(myValue - otherValue) < MathHelper.EPSILON;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.repeat != null) {
            sb.append(", repeat " + this.repeat);
        }
        if (this.fold != null) {
            sb.append(", fold " + this.fold);
        }
        if (this.sample != null) {
            sb.append(", sample " + this.sample);
        }
        if (this.interval_start != null) {
            sb.append(", interval_start " + this.interval_start);
        }
        if (sb.length() == 0) {
            sb.append(", GLOBAL");
        }
        return this.function + " (" + this.implementation + ") - [" + sb.toString().substring(2) + "]";
    }

    private static boolean equalStrings(String s1, String s2) {
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return s1 == null && s2 == null;
    }

    private static boolean equalIntegers(Integer s1, Integer s2) {
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return s1 == null && s2 == null;
    }
}

