/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.xml;

import org.apache.commons.lang3.ArrayUtils;
import org.openml.apiconnector.algorithms.MathHelper;
import org.openml.apiconnector.xml.EvaluationScore;

public class Run {
    private final String oml = "http://openml.org/openml";
    private int task_id;
    private int implementation_id;
    private String setup_string;
    private String error_message;
    private Parameter_setting[] parameter_settings;
    private Data input_data;
    private Data output_data;

    public Run(int task_id, String error_message, int implementation_id, String setup_string, Parameter_setting[] parameter_settings) {
        this.task_id = task_id;
        this.implementation_id = implementation_id;
        this.setup_string = setup_string;
        this.error_message = error_message;
        this.parameter_settings = parameter_settings;
        this.output_data = new Data();
        this.input_data = new Data();
    }

    public String getOml() {
        return "http://openml.org/openml";
    }

    public int getTask_id() {
        return this.task_id;
    }

    public int getImplementation_id() {
        return this.implementation_id;
    }

    public String getError_message() {
        return this.error_message;
    }

    public String getSetup_string() {
        return this.setup_string;
    }

    public Parameter_setting[] getParameter_settings() {
        return this.parameter_settings;
    }

    public void addInputData(String name, String url) {
        this.input_data.addDataset(name, url);
    }

    public void addOutputData(String name, String url) {
        this.output_data.addDataset(name, url);
    }

    public void addOutputEvaluation(String name, Integer repeat, Integer fold, Integer sample, String implementation, Double value) {
        this.output_data.addEvaluation(name, repeat, fold, sample, implementation, value);
    }

    public void addOutputEvaluation(String name, String implementation, Double value, String array_data) {
        this.output_data.addEvaluation(name, implementation, value, array_data);
    }

    public EvaluationScore[] getOutputEvaluation() {
        return this.output_data.evaluation;
    }

    public static class Data {
        private Dataset[] dataset = new Dataset[0];
        private EvaluationScore[] evaluation = new EvaluationScore[0];

        public Dataset[] getDataset() {
            return this.dataset;
        }

        public EvaluationScore[] getEvaluation() {
            return this.evaluation;
        }

        public void addDataset(String name, String url) {
            Dataset d = new Dataset(name, url);
            this.dataset = (Dataset[])ArrayUtils.addAll((Object[])this.dataset, (Object[])new Dataset[]{d});
        }

        public void addEvaluation(String name, Integer repeat, Integer fold, Integer sample, String implementation, Double value) {
            EvaluationScore e = new EvaluationScore(implementation, name, MathHelper.defaultDecimalFormat.format(value), null, repeat, fold, sample, null);
            this.evaluation = (EvaluationScore[])ArrayUtils.addAll((Object[])this.evaluation, (Object[])new EvaluationScore[]{e});
        }

        public void addEvaluation(String name, String implementation, Double value, String array_data) {
            EvaluationScore e = new EvaluationScore(implementation, name, value != null ? MathHelper.defaultDecimalFormat.format(value) : null, null, array_data);
            this.evaluation = (EvaluationScore[])ArrayUtils.addAll((Object[])this.evaluation, (Object[])new EvaluationScore[]{e});
        }

        public static class Dataset {
            private Integer did;
            private String name;
            private String url;

            public Dataset(String name, String url) {
                this.name = name;
                this.url = url;
            }

            public int getDid() {
                return this.did;
            }

            public String getName() {
                return this.name;
            }

            public String getUrl() {
                return this.url;
            }
        }
    }

    public static class Parameter_setting {
        private String name;
        private String value;
        private int component;

        public Parameter_setting(int component, String name, String value) {
            this.name = name;
            this.component = component;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public int getComponent() {
            return this.component;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.component + "_" + this.name + ": " + this.value;
        }
    }
}

