/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.xml;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.openml.apiconnector.algorithms.ArffHelper;
import org.openml.apiconnector.io.OpenmlConnector;
import org.openml.apiconnector.xml.DataSetDescription;

public class Task
implements Serializable {
    private static final long serialVersionUID = 987612341009L;
    private final String oml = "http://openml.org/openml";
    private Integer task_id;
    private String task_type;
    private Input[] inputs;
    private Output[] outputs;

    public Task(int id) {
        this.task_id = id;
    }

    public String toString() {
        return "Task " + this.getTask_id() + ": " + this.getTask_type();
    }

    public boolean equals(Object other) {
        return other instanceof Task && ((Task)other).getTask_id() == this.getTask_id();
    }

    public String getOml() {
        return "http://openml.org/openml";
    }

    public Integer getTask_id() {
        return this.task_id;
    }

    public String getTask_type() {
        return this.task_type;
    }

    public Input[] getInputs() {
        return this.inputs;
    }

    public Output[] getOutputs() {
        return this.outputs;
    }

    public class Output
    implements Serializable {
        private static final long serialVersionUID = 987612341059L;
        private String name;
        private Predictions predictions;

        public String getName() {
            return this.name;
        }

        public Predictions getPredictions() {
            return this.predictions;
        }

        public class Predictions
        implements Serializable {
            private static final long serialVersionUID = 987612341069L;
            private String format;
            private Feature[] features;

            public String getFormat() {
                return this.format;
            }

            public Feature[] getFeatures() {
                return this.features;
            }

            public class Feature
            implements Serializable {
                private static final long serialVersionUID = 987612341079L;
                private String name;
                private String type;

                public String getName() {
                    return this.name;
                }

                public String getType() {
                    return this.type;
                }
            }
        }
    }

    public class Input
    implements Serializable {
        private static final long serialVersionUID = 987612341019L;
        private String name;
        private Data_set data_set;
        private Estimation_procedure estimation_procedure;
        private Evaluation_measures evaluation_measures;

        public String getName() {
            return this.name;
        }

        public Data_set getData_set() {
            return this.data_set;
        }

        public Estimation_procedure getEstimation_procedure() {
            return this.estimation_procedure;
        }

        public Evaluation_measures getEvaluation_measures() {
            return this.evaluation_measures;
        }

        public class Evaluation_measures
        implements Serializable {
            private static final long serialVersionUID = 987612341049L;
            private String[] evaluation_measure;

            public String[] getEvaluation_measure() {
                return this.evaluation_measure;
            }
        }

        public class Estimation_procedure
        implements Serializable {
            private static final long serialVersionUID = 987612341039L;
            private String type;
            private String data_splits_url;
            private Parameter[] parameters;
            private File data_splits_cache;

            public String getType() {
                return this.type;
            }

            public String getData_splits_url() {
                return this.data_splits_url;
            }

            public Parameter[] getParameters() {
                return this.parameters;
            }

            public File getDataSplits() throws IOException {
                if (this.data_splits_cache == null) {
                    String serverMd5 = OpenmlConnector.getStringFromUrl(this.getData_splits_url().replace("/get/", "/md5/"));
                    String identifier = this.getData_splits_url().substring(this.getData_splits_url().lastIndexOf(47) + 1);
                    this.data_splits_cache = ArffHelper.downloadAndCache("splits", identifier, this.getData_splits_url(), serverMd5);
                }
                return this.data_splits_cache;
            }

            public class Parameter
            implements Serializable {
                private static final long serialVersionUID = 987612341099L;
                private String name;
                private String value;

                public String getName() {
                    return this.name;
                }

                public String getValue() {
                    return this.value;
                }
            }
        }

        public class Data_set
        implements Serializable {
            private static final long serialVersionUID = 987612341029L;
            private Integer data_set_id;
            private String target_feature;
            private DataSetDescription dsdCache;

            public Integer getData_set_id() {
                return this.data_set_id;
            }

            public String getTarget_feature() {
                return this.target_feature;
            }

            public DataSetDescription getDataSetDescription(OpenmlConnector apiconnector) throws Exception {
                if (this.dsdCache == null) {
                    this.dsdCache = apiconnector.openmlDataDescription(this.data_set_id);
                }
                return this.dsdCache;
            }
        }
    }
}

