/*
 * Decompiled with CFR 0.152.
 */
package org.openml.weka.algorithm;

import java.io.BufferedReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.openml.apiconnector.algorithms.Input;
import org.openml.apiconnector.algorithms.TaskInformation;
import org.openml.apiconnector.io.OpenmlConnector;
import org.openml.apiconnector.xml.DataSetDescription;
import org.openml.apiconnector.xml.Task;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class DataSplits {
    private final Instances[][][][] subsamples;
    private final ArrayList<Integer>[][][] rowids;
    public final int REPEATS;
    public final int FOLDS;
    public final int SAMPLES;
    public final int DATASET_ID;

    public static DataSplits get(OpenmlConnector openml, int taskId) throws Exception {
        Task task = openml.taskGet(taskId);
        String targetAttribute = TaskInformation.getSourceData((Task)task).getTarget_feature();
        int dataId = TaskInformation.getSourceData((Task)task).getData_set_id();
        DataSetDescription dsd = openml.dataGet(dataId);
        URL splitsUrl = new URL(TaskInformation.getEstimationProcedure((Task)task).getData_splits_url());
        URL datasetUrl = openml.getOpenmlFileUrl(dsd.getFile_id(), dsd.getName() + ".arff");
        Instances dataset = new Instances((Reader)new BufferedReader(Input.getURL((URL)datasetUrl)));
        dataset.setClass(dataset.attribute(targetAttribute));
        Instances splits = new Instances((Reader)new BufferedReader(Input.getURL((URL)splitsUrl)));
        return new DataSplits(task, dataset, splits);
    }

    public DataSplits(Task task, Instances dataset, Instances datasplits) throws Exception {
        int numRepeats = TaskInformation.getNumberOfRepeats((Task)task);
        int numFolds = TaskInformation.getNumberOfFolds((Task)task);
        int numSamples = 1;
        try {
            numSamples = TaskInformation.getNumberOfSamples((Task)task);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.DATASET_ID = TaskInformation.getSourceData((Task)task).getData_set_id();
        this.REPEATS = numRepeats;
        this.FOLDS = numFolds;
        this.SAMPLES = numSamples;
        this.subsamples = new Instances[this.REPEATS][this.FOLDS][this.SAMPLES][2];
        this.rowids = new ArrayList[this.REPEATS][this.FOLDS][this.SAMPLES];
        for (int repeats = 0; repeats < this.REPEATS; ++repeats) {
            for (int folds = 0; folds < this.FOLDS; ++folds) {
                for (int samples = 0; samples < this.SAMPLES; ++samples) {
                    for (int i = 0; i < 2; ++i) {
                        this.subsamples[repeats][folds][samples][i] = new Instances(dataset, 0);
                        this.rowids[repeats][folds][samples] = new ArrayList();
                    }
                }
            }
        }
        Attribute attRowid = datasplits.attribute("rowid");
        Attribute attRepeat = datasplits.attribute("repeat");
        Attribute attFold = datasplits.attribute("fold");
        Attribute attSample = datasplits.attribute("sample");
        Attribute attType = datasplits.attribute("type");
        for (int i = 0; i < datasplits.numInstances(); ++i) {
            Instance instanceMeta = datasplits.get(i);
            int rowid = (int)instanceMeta.value(attRowid);
            int repeat = attRepeat == null ? 0 : (int)instanceMeta.value(attRepeat);
            int fold = attFold == null ? 0 : (int)instanceMeta.value(attFold);
            int sample = attSample == null ? 0 : (int)instanceMeta.value(attSample);
            boolean train = attType.value((int)instanceMeta.value(attType)).equals("TRAIN");
            Instance instanceBase = dataset.get(rowid);
            this.subsamples[repeat][fold][sample][train ? 0 : 1].add(instanceBase);
            if (train) continue;
            this.rowids[repeat][fold][sample].add(rowid);
        }
    }

    public Instances getTrainingSet(int repeat, int fold) {
        return this.subsamples[repeat][fold][0][0];
    }

    public Instances getTrainingSet(int repeat, int fold, int sample) {
        return this.subsamples[repeat][fold][sample][0];
    }

    public Instances getTestSet(int repeat, int fold) {
        return this.subsamples[repeat][fold][0][1];
    }

    public Instances getTestSet(int repeat, int fold, int sample) {
        return this.subsamples[repeat][fold][sample][1];
    }

    public List<Integer> getTestSetRowIds(int repeat, int fold, int sample) {
        return this.rowids[repeat][fold][sample];
    }
}

