/*
 * Decompiled with CFR 0.152.
 */
package org.openml.weka.algorithm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openml.apiconnector.algorithms.Conversion;
import org.openml.apiconnector.algorithms.ParameterType;
import org.openml.apiconnector.io.OpenmlConnector;
import org.openml.apiconnector.xml.Flow;
import org.openml.apiconnector.xml.FlowExists;
import org.openml.apiconnector.xml.Run;
import org.openml.apiconnector.xml.SetupExists;
import org.openml.apiconnector.xml.UploadFlow;
import org.openml.apiconnector.xstream.XstreamXmlMapping;
import weka.classifiers.Classifier;
import weka.classifiers.functions.supportVector.Kernel;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.Version;
import weka.core.setupgenerator.AbstractParameter;
import weka.experiment.SplitEvaluator;

public class WekaAlgorithm {
    public static String getVersion(String algorithm) {
        String version = "undefined";
        try {
            RevisionHandler classifier = (RevisionHandler)Class.forName(algorithm).newInstance();
            if (StringUtils.isAlphanumeric((CharSequence)classifier.getRevision())) {
                version = classifier.getRevision();
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return version;
    }

    public static Integer getSetupId(String classifierName, String option_str, OpenmlConnector apiconnector) throws Exception {
        Flow find = WekaAlgorithm.serializeClassifier(classifierName, null);
        int flow_id = -1;
        try {
            FlowExists result = apiconnector.flowExists(find.getName(), find.getExternal_version());
            if (!result.exists()) {
                return null;
            }
            flow_id = result.getId();
        }
        catch (Exception e) {
            return null;
        }
        Flow implementation = apiconnector.flowGet(flow_id);
        String[] params = Utils.splitOptions((String)option_str);
        ArrayList<Run.Parameter_setting> list = WekaAlgorithm.getParameterSetting(params, implementation);
        Run run = new Run(null, null, implementation.getId().intValue(), null, list.toArray(new Run.Parameter_setting[list.size()]), null);
        File setup = Conversion.stringToTempFile((String)XstreamXmlMapping.getInstance().toXML((Object)run), (String)"setup", (String)"xml");
        SetupExists se = apiconnector.setupExists(setup);
        if (se.exists()) {
            return se.getId();
        }
        return null;
    }

    public static int getImplementationId(Flow implementation, Classifier classifier, OpenmlConnector apiconnector) throws Exception {
        try {
            FlowExists result = apiconnector.flowExists(implementation.getName(), implementation.getExternal_version());
            if (result.exists()) {
                return result.getId();
            }
        }
        catch (Exception result) {
            // empty catch block
        }
        String xml = XstreamXmlMapping.getInstance().toXML((Object)implementation);
        File implementationFile = Conversion.stringToTempFile((String)xml, (String)implementation.getName(), (String)"xml");
        UploadFlow ui = apiconnector.flowUpload(implementationFile, null, null);
        return ui.getId();
    }

    public static Flow serializeClassifier(String classifier_name, String[] tags) throws Exception {
        Object classifier = Class.forName(classifier_name).newInstance();
        String[] defaultOptions = ((OptionHandler)((OptionHandler)classifier).getClass().newInstance()).getOptions();
        String classPath = classifier.getClass().getName();
        String classifierName = classPath.substring(classPath.lastIndexOf(46) + 1);
        String name = "weka." + classifierName;
        String version = WekaAlgorithm.getVersion(classifier_name);
        String description = "Weka implementation of " + classifierName;
        String language = "English";
        String dependencies = "Weka_" + Version.VERSION;
        if (classifier instanceof TechnicalInformationHandler) {
            description = ((TechnicalInformationHandler)classifier).getTechnicalInformation().toString();
        }
        Flow i = new Flow(name, classifier.getClass().getName(), dependencies + "_" + version, description, language, dependencies);
        if (tags != null) {
            for (String tag : tags) {
                i.addTag(tag);
            }
        }
        Enumeration parameters = ((OptionHandler)classifier).listOptions();
        while (parameters.hasMoreElements()) {
            ParameterType type;
            Option parameter = (Option)parameters.nextElement();
            if (parameter.name().trim().equals("")) continue;
            String defaultValue = "";
            String currentValue = "";
            defaultValue = parameter.numArguments() == 0 ? (Utils.getFlag((String)parameter.name(), (String[])defaultOptions) ? "true" : "") : Utils.getOption((String)parameter.name(), (String[])defaultOptions);
            String[] currentValueSplitted = currentValue.split(" ");
            try {
                Flow subimplementation;
                Object parameterObject = Class.forName(currentValueSplitted[0]).newInstance();
                if (parameterObject instanceof Kernel) {
                    subimplementation = WekaAlgorithm.serializeClassifier(currentValueSplitted[0], tags);
                    type = ParameterType.KERNEL;
                    i.addComponent(parameter.name(), subimplementation);
                    i.addParameter(parameter.name(), type.getName(), currentValueSplitted[0], parameter.description());
                    continue;
                }
                if (parameterObject instanceof Classifier) {
                    subimplementation = WekaAlgorithm.serializeClassifier(currentValueSplitted[0], tags);
                    type = ParameterType.BASELEARNER;
                    i.addComponent(parameter.name(), subimplementation);
                    i.addParameter(parameter.name(), type.getName(), currentValue, parameter.description());
                    continue;
                }
                try {
                    if (parameterObject instanceof AbstractParameter) {
                        type = ParameterType.ARRAY;
                        i.addParameter(parameter.name(), type.getName(), null, parameter.description());
                        continue;
                    }
                    ClassNotFoundException current = new ClassNotFoundException("Parameter class found, but no known procedure to handle it found. Will be handled as plain: " + currentValueSplitted[0]);
                    Conversion.log((String)"Warning", (String)"FlowCreation", (String)current.getMessage());
                    throw current;
                }
                catch (NoClassDefFoundError e) {
                    ClassNotFoundException current = new ClassNotFoundException("Parameter class found, but no known procedure to handle it found. Will be handled as plain: " + currentValueSplitted[0]);
                    Conversion.log((String)"Warning", (String)"FlowCreation", (String)current.getMessage());
                    throw current;
                }
            }
            catch (ClassNotFoundException e) {
                if (i.parameter_exists(parameter.name())) continue;
                type = parameter.numArguments() == 0 ? ParameterType.FLAG : ParameterType.OPTION;
                i.addParameter(parameter.name(), type.getName(), defaultValue, parameter.description());
            }
        }
        return i;
    }

    public static ArrayList<Run.Parameter_setting> getParameterSetting(String[] parameters, Flow implementation) {
        ArrayList<Run.Parameter_setting> settings = new ArrayList<Run.Parameter_setting>();
        if (implementation.getParameter() != null) {
            for (Flow.Parameter p : implementation.getParameter()) {
                try {
                    ParameterType type = ParameterType.fromString((String)p.getData_type());
                    switch (type) {
                        case KERNEL: {
                            String kernelvalue = Utils.getOption((String)p.getName(), (String[])parameters);
                            try {
                                String kernelname = kernelvalue.substring(0, kernelvalue.indexOf(32));
                                String[] kernelsettings = Utils.splitOptions((String)kernelvalue.substring(kernelvalue.indexOf(32) + 1));
                                ArrayList<Run.Parameter_setting> kernelresult = WekaAlgorithm.getParameterSetting(kernelsettings, implementation.getSubImplementation(p.getName()));
                                settings.addAll(kernelresult);
                                settings.add(new Run.Parameter_setting(implementation.getId(), p.getName(), kernelname));
                            }
                            catch (ClassNotFoundException kernelname) {}
                            break;
                        }
                        case BASELEARNER: {
                            String baselearnervalue = Utils.getOption((String)p.getName(), (String[])parameters);
                            try {
                                String[] baselearnersettings = Utils.partitionOptions((String[])parameters);
                                settings.addAll(WekaAlgorithm.getParameterSetting(baselearnersettings, implementation.getSubImplementation(p.getName())));
                                settings.add(new Run.Parameter_setting(implementation.getId(), p.getName(), baselearnervalue));
                            }
                            catch (ClassNotFoundException baselearnersettings) {}
                            break;
                        }
                        case OPTION: {
                            String optionvalue = Utils.getOption((String)p.getName(), (String[])parameters);
                            if (optionvalue == "") break;
                            settings.add(new Run.Parameter_setting(implementation.getId(), p.getName(), optionvalue));
                            break;
                        }
                        case FLAG: {
                            boolean flagvalue = Utils.getFlag((String)p.getName(), (String[])parameters);
                            if (!flagvalue) break;
                            settings.add(new Run.Parameter_setting(implementation.getId(), p.getName(), "true"));
                            break;
                        }
                        case ARRAY: {
                            ArrayList<String> values = new ArrayList<String>();
                            String currentvalue = Utils.getOption((String)p.getName(), (String[])parameters);
                            while (!currentvalue.equals("")) {
                                values.add(currentvalue);
                                currentvalue = Utils.getOption((String)p.getName(), (String[])parameters);
                            }
                            if (values.size() <= 0) break;
                            settings.add(new Run.Parameter_setting(implementation.getId(), p.getName(), ((Object)values).toString()));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return settings;
    }

    public static File classifierSerializedToFile(Classifier cls, Integer task_id) throws IOException {
        File file = File.createTempFile("WekaSerialized_" + cls.getClass().getName(), ".model");
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
        oos.writeObject(cls);
        oos.flush();
        oos.close();
        file.deleteOnExit();
        return file;
    }

    public static Map<String, Object> splitEvaluatorToMap(SplitEvaluator se, Object[] results) {
        HashMap<String, Object> splitEvaluatorResults = new HashMap<String, Object>();
        String[] seResultNames = se.getResultNames();
        for (int i = 0; i < seResultNames.length; ++i) {
            splitEvaluatorResults.put(seResultNames[i], results[i]);
        }
        return splitEvaluatorResults;
    }
}

