/*
 * Decompiled with CFR 0.152.
 */
package org.openml.weka.experiment;

import java.io.File;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.openml.apiconnector.io.OpenmlConnector;
import org.openml.apiconnector.settings.Constants;
import org.openml.apiconnector.xml.Tasks;
import org.openml.weka.algorithm.WekaConfig;
import org.openml.weka.experiment.RunOpenmlJob;

public class RandomBot {
    private static final String TAG = "RandomBot";

    public static void main(String[] args) {
        int taskType;
        RandomBot bot = new RandomBot();
        try {
            taskType = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            RandomBot.showErrorMessage("RandomBot:" + e.toString());
            return;
        }
        String taskTag = args[1];
        String classifierCategory = args[2];
        int taskId = bot.getRandomTaskId(taskType, taskTag);
        if (taskId == -1) {
            return;
        }
        bot.startTask(taskId, classifierCategory);
    }

    public int getRandomTaskId(int type, String tag) {
        int taskId;
        WekaConfig config = null;
        config = this.getConfigurationFile();
        if (config == null) {
            return -1;
        }
        OpenmlConnector connector = new OpenmlConnector(config.getServer(), config.getApiKey());
        try {
            Tasks tasks = connector.taskList(type, tag);
            Tasks.Task[] arrayTasks = tasks.getTask();
            int taskArraySize = tasks.getTask().length;
            int randomId = new Random().nextInt(taskArraySize);
            taskId = arrayTasks[randomId].getTask_id();
        }
        catch (Exception e) {
            RandomBot.showErrorMessage("RandomBot:" + e.toString());
            return -1;
        }
        return taskId;
    }

    public void startTask(int id, String classifier) {
        WekaConfig config = null;
        config = this.getConfigurationFile();
        if (config == null) {
            RandomBot.showErrorMessage("RandomBot:No Config file reference in startTask");
            return;
        }
        HashMap<String, String[]> algorithms = this.initializeAlgorithms();
        if (algorithms.get(classifier) == null) {
            RandomBot.showErrorMessage("RandomBot:Please give a correct category for the classifiers");
            return;
        }
        int nrClassifiers = algorithms.get(classifier).length;
        int randomPosition = new Random().nextInt(nrClassifiers);
        Object[] arguments = new String[]{"-task_id", "" + id, "-config", "server=" + config.getServer() + "; avoid_duplicate_runs=" + config.getAvoidDuplicateRuns() + "; skip_jvm_benchmark=" + config.getSkipJvmBenchmark() + "; api_key=" + config.getApiKey(), "-C"};
        try {
            RunOpenmlJob.main((String[])ArrayUtils.add((Object[])arguments, (Object)algorithms.get(classifier)[randomPosition]));
        }
        catch (Exception e) {
            RandomBot.showErrorMessage("RandomBot:" + e.toString());
        }
    }

    private HashMap<String, String[]> initializeAlgorithms() {
        HashMap<String, String[]> algorithms = new HashMap<String, String[]>();
        algorithms.put("bayes", new String[]{"weka.classifiers.bayes.BayesNet", "weka.classifiers.bayes.NaiveBayes", "weka.classifiers.bayes.NaiveBayesMultinomial", "weka.classifiers.bayes.NaiveBayesMultinomialText", "weka.classifiers.bayes.NaiveBayesMultinomialUpdateable", "weka.classifiers.bayes.NaiveBayesUpdateable"});
        algorithms.put("functions", new String[]{"weka.classifiers.functions.GaussianProcesses", "weka.classifiers.functions.LinearRegression", "weka.classifiers.functions.Logistic", "weka.classifiers.functions.MultilayerPerceptron", "weka.classifiers.functions.SGD", "weka.classifiers.functions.SGDText", "weka.classifiers.functions.SimpleLinearRegression", "weka.classifiers.functions.SimpleLogistic", "weka.classifiers.functions.SMO", "weka.classifiers.functions.SMOreg", "weka.classifiers.functions.VotedPerceptron"});
        algorithms.put("lazy", new String[]{"weka.classifiers.lazy.IBk", "weka.classifiers.lazy.KStar", "weka.classifiers.lazy.LWL"});
        algorithms.put("meta", new String[]{"weka.classifiers.meta.AdaBoostM1", "weka.classifiers.meta.AdditiveRegression", "weka.classifiers.meta.AttributeSelectedClassifier", "weka.classifiers.meta.Bagging", "weka.classifiers.meta.ClassificationViaRegression", "weka.classifiers.meta.CostSensitiveClassifier", "weka.classifiers.meta.CVParameterSelection", "weka.classifiers.meta.FilteredClassifier", "weka.classifiers.meta.IterativeClassifierOptimizer", "weka.classifiers.meta.LogitBoost", "weka.classifiers.meta.MultiClassClassifier", "weka.classifiers.meta.MultiClassClassifierUpdateable", "weka.classifiers.meta.MultiScheme", "weka.classifiers.meta.RandomCommittee", "weka.classifiers.meta.RandomizableFilteredClassifier", "weka.classifiers.meta.RandomSubSpace", "weka.classifiers.meta.Stacking", "weka.classifiers.meta.RegressionByDiscretization", "weka.classifiers.meta.WeightedInstancesHandlerWrapper", "weka.classifiers.meta.Vote"});
        algorithms.put("misc", new String[]{"weka.classifiers.misc.InputMappedClassifier", "weka.classifiers.misc.SerializedClassifier"});
        algorithms.put("rules", new String[]{"weka.classifiers.rules.DecisionTable", "weka.classifiers.rules.DecisionTableHashKey", "weka.classifiers.rules.JRip", "weka.classifiers.rules.M5Rules", "weka.classifiers.rules.OneR", "weka.classifiers.rules.PART", "weka.classifiers.rules.Rule", "weka.classifiers.rules.RuleStats", "weka.classifiers.rules.ZeroR"});
        algorithms.put("trees", new String[]{"weka.classifiers.trees.DecisionStump", "weka.classifiers.trees.HoeffdingTree", "weka.classifiers.trees.J48", "weka.classifiers.trees.LMT", "weka.classifiers.trees.M5P", "weka.classifiers.trees.RandomForest", "weka.classifiers.trees.RandomTree", "weka.classifiers.trees.REPTree"});
        return algorithms;
    }

    private static void showErrorMessage(String errorMessage) {
        System.out.println(errorMessage);
    }

    private WekaConfig getConfigurationFile() {
        WekaConfig config = null;
        File configFile = new File(Constants.OPENML_DIRECTORY + "/openml.conf");
        if (configFile.exists() && configFile.isFile()) {
            config = new WekaConfig();
        }
        return config;
    }
}

