/*
 * Decompiled with CFR 0.152.
 */
package org.openml.weka.experiment;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import javax.swing.DefaultListModel;
import org.openml.apiconnector.io.OpenmlConnector;
import org.openml.apiconnector.xml.Task;
import org.openml.weka.algorithm.WekaConfig;
import org.openml.weka.experiment.OpenmlClassificationSplitEvaluator;
import org.openml.weka.experiment.TaskBasedExperiment;
import org.openml.weka.experiment.TaskResultListener;
import org.openml.weka.experiment.TaskResultProducer;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.CommandlineRunnable;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.WekaPackageManager;
import weka.experiment.ClassifierSplitEvaluator;
import weka.experiment.CrossValidationResultProducer;
import weka.experiment.Experiment;
import weka.experiment.PropertyNode;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;

public class RunOpenmlJob
implements CommandlineRunnable {
    public static void main(String[] args) throws Exception {
        RunOpenmlJob rj = new RunOpenmlJob();
        rj.run(rj, args);
    }

    public static int executeTask(OpenmlConnector openml, WekaConfig config, Integer task_id, Classifier classifier) throws Exception {
        TaskBasedExperiment exp = new TaskBasedExperiment(new Experiment(), openml, config);
        TaskResultProducer rp = new TaskResultProducer(openml, config);
        TaskResultListener rl = new TaskResultListener(openml, config);
        OpenmlClassificationSplitEvaluator se = new OpenmlClassificationSplitEvaluator();
        Classifier sec = null;
        exp.setResultProducer((ResultProducer)rp);
        exp.setResultListener((ResultListener)rl);
        exp.setUsePropertyIterator(true);
        sec = ((ClassifierSplitEvaluator)se).getClassifier();
        PropertyNode[] propertyPath = new PropertyNode[2];
        try {
            propertyPath[0] = new PropertyNode((Object)se, new PropertyDescriptor("splitEvaluator", CrossValidationResultProducer.class), CrossValidationResultProducer.class);
            propertyPath[1] = new PropertyNode((Object)sec, new PropertyDescriptor("classifier", se.getClass()), se.getClass());
        }
        catch (IntrospectionException err) {
            err.printStackTrace();
        }
        exp.setPropertyPath(propertyPath);
        Classifier[] cArray = new Classifier[]{classifier};
        exp.setPropertyArray(cArray);
        DefaultListModel<Task> tasks = new DefaultListModel<Task>();
        tasks.add(0, openml.taskGet(task_id.intValue()));
        exp.setTasks(tasks);
        System.err.println("Initializing...");
        exp.initialize();
        System.err.println("Iterating...");
        exp.runExperiment();
        System.err.println("Postprocessing...");
        exp.postProcess();
        System.err.println("Done");
        int runId = ((TaskResultListener)exp.getResultListener()).getRunIds().get(0);
        return runId;
    }

    public void run(Object arg0, String[] args) throws Exception {
        Classifier classifier;
        String strTaskid;
        String strConfig;
        try {
            strConfig = Utils.getOption((String)"config", (String[])args);
        }
        catch (Exception e) {
            strConfig = null;
        }
        WekaConfig config = strConfig != null & !strConfig.equals("") ? new WekaConfig(strConfig) : new WekaConfig();
        String username = config.getApiKey();
        String server = config.getServer();
        OpenmlConnector apiconnector = server != null ? new OpenmlConnector(server, username) : new OpenmlConnector(username);
        try {
            strTaskid = Utils.getOption((String)"task_id", (String[])args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        String classifierCliString = Utils.getOption((char)'C', (String[])args);
        if (classifierCliString.length() == 0) {
            throw new Exception("A classifier must be specified with the -C option.");
        }
        String[] classifierOptions = Utils.splitOptions((String)classifierCliString);
        try {
            classifier = AbstractClassifier.forName((String)classifierOptions[0], null);
            classifierOptions[0] = "";
        }
        catch (Exception e) {
            WekaPackageManager.loadPackages((boolean)false);
            classifier = AbstractClassifier.forName((String)classifierOptions[0], null);
            classifierOptions[0] = "";
        }
        if (classifier instanceof OptionHandler) {
            ((OptionHandler)classifier).setOptions(classifierOptions);
        }
        RunOpenmlJob.executeTask(apiconnector, config, Integer.parseInt(strTaskid), classifier);
    }

    public void postExecution() throws Exception {
    }

    public void preExecution() throws Exception {
    }
}

