/*
 * Decompiled with CFR 0.152.
 */
package org.openml.weka.experiment;

import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import org.openml.apiconnector.algorithms.Conversion;
import org.openml.apiconnector.algorithms.TaskInformation;
import org.openml.apiconnector.io.OpenmlConnector;
import org.openml.apiconnector.xml.RunList;
import org.openml.apiconnector.xml.Task;
import org.openml.weka.algorithm.WekaAlgorithm;
import org.openml.weka.algorithm.WekaConfig;
import org.openml.weka.experiment.TaskResultProducer;
import weka.experiment.Experiment;

public class TaskBasedExperiment
extends Experiment {
    private static final long serialVersionUID = 1L;
    protected DefaultListModel<Task> m_Tasks = new DefaultListModel();
    protected Task m_CurrentTask;
    protected final OpenmlConnector apiconnector;
    protected final WekaConfig openmlconfig;

    public TaskBasedExperiment(Experiment exp, OpenmlConnector apiconnector, WekaConfig config) {
        this.m_ResultListener = exp.getResultListener();
        this.m_ResultProducer = exp.getResultProducer();
        this.m_RunLower = exp.getRunLower();
        this.m_RunUpper = exp.getRunUpper();
        this.m_Datasets = exp.getDatasets();
        this.m_UsePropertyIterator = true;
        this.m_PropertyArray = exp.getPropertyArray();
        this.m_Notes = exp.getNotes();
        this.m_AdvanceDataSetFirst = exp.getAdvanceDataSetFirst();
        this.apiconnector = apiconnector;
        this.openmlconfig = config;
    }

    public DefaultListModel<Task> getTasks() {
        return this.m_Tasks;
    }

    public void setTasks(DefaultListModel<Task> tasks) {
        this.m_Tasks = tasks;
    }

    public DefaultListModel<File> getDatasets() {
        DefaultListModel<File> datasets = new DefaultListModel<File>();
        for (int i = 0; i < this.m_Tasks.size(); ++i) {
            datasets.add(i, new File("Task_" + this.m_Tasks.get(i).getTask_id() + ".arff"));
        }
        return datasets;
    }

    public void initialize() throws Exception {
        this.m_RunNumber = this.getRunLower();
        this.m_DatasetNumber = 0;
        this.m_PropertyNumber = 0;
        this.m_CurrentProperty = -1;
        this.m_CurrentInstances = null;
        this.m_CurrentTask = null;
        this.m_Finished = false;
        if (this.m_UsePropertyIterator && this.m_PropertyArray == null) {
            throw new Exception("Null array for property iterator");
        }
        if (this.getRunLower() > this.getRunUpper()) {
            throw new Exception("Lower run number is greater than upper run number");
        }
        if (this.getTasks().size() == 0) {
            throw new Exception("No tasks have been specified");
        }
        if (this.m_ResultProducer == null) {
            throw new Exception("No ResultProducer set");
        }
        if (this.m_ResultListener == null) {
            throw new Exception("No ResultListener set");
        }
        this.m_ResultProducer.setResultListener(this.m_ResultListener);
        this.m_ResultProducer.setAdditionalMeasures(this.m_AdditionalMeasures);
        this.m_ResultProducer.preProcess();
        String[] columnConstraints = this.m_ResultListener.determineColumnConstraints(this.m_ResultProducer);
        if (columnConstraints != null) {
            this.m_ResultProducer.setAdditionalMeasures(columnConstraints);
        }
    }

    public void nextIteration() throws Exception {
        String classifierOptions;
        String classifierName;
        Integer setupId;
        if (this.m_CurrentTask == null) {
            this.m_CurrentTask = this.getTasks().elementAt(this.m_DatasetNumber);
            ((TaskResultProducer)this.m_ResultProducer).setTask(this.m_CurrentTask);
            this.setRunUpper(TaskInformation.getNumberOfRepeats((Task)this.m_CurrentTask));
            System.err.println(((TaskResultProducer)this.m_ResultProducer).getSplitEvaluator().getClass().toString());
            if (this.m_UsePropertyIterator) {
                this.setProperty(0, this.m_ResultProducer);
                this.m_CurrentProperty = this.m_PropertyNumber;
            }
        }
        if (this.openmlconfig.getAvoidDuplicateRuns() && (setupId = WekaAlgorithm.getSetupId(classifierName = (String)((TaskResultProducer)this.m_ResultProducer).getSplitEvaluatorKey(0), classifierOptions = (String)((TaskResultProducer)this.m_ResultProducer).getSplitEvaluatorKey(1), this.apiconnector)) != null) {
            ArrayList<Integer> taskIds = new ArrayList<Integer>();
            taskIds.add(this.m_CurrentTask.getTask_id());
            ArrayList<Integer> setupIds = new ArrayList<Integer>();
            setupIds.add(setupId);
            try {
                HashMap<String, ArrayList<Integer>> filters = new HashMap<String, ArrayList<Integer>>();
                filters.put("task", taskIds);
                filters.put("setup", setupIds);
                RunList rl = this.apiconnector.runList(filters, null, null);
                if (rl.getRuns().length > 0) {
                    ArrayList<Integer> runIds = new ArrayList<Integer>();
                    for (RunList.Run r : rl.getRuns()) {
                        runIds.add(r.getRun_id());
                    }
                    Conversion.log((String)"INFO", (String)"Skip", (String)("Skipping run " + classifierName + " (setup #" + setupId + ") repeat " + this.m_RunNumber + ", already available. Run ids: " + runIds));
                    this.advanceCounters();
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_ResultProducer.doRun(this.m_RunNumber);
        if (this.m_RunNumber == this.getRunUpper() && this.openmlconfig.getModelFullDataset()) {
            ((TaskResultProducer)this.m_ResultProducer).doFullRun();
        }
        this.advanceCounters();
    }

    public void advanceCounters() {
        ++this.m_RunNumber;
        if (this.m_RunNumber > this.getRunUpper()) {
            this.m_RunNumber = this.getRunLower();
            ++this.m_DatasetNumber;
            this.m_CurrentInstances = null;
            this.m_CurrentTask = null;
            if (this.m_DatasetNumber >= this.getTasks().size()) {
                this.m_DatasetNumber = 0;
                if (this.m_UsePropertyIterator) {
                    ++this.m_PropertyNumber;
                    if (this.m_PropertyNumber >= Array.getLength(this.m_PropertyArray)) {
                        this.m_Finished = true;
                    }
                } else {
                    this.m_Finished = true;
                }
            }
        }
    }
}

