/*
 * Decompiled with CFR 0.152.
 */
package org.openml.weka.experiment;

import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openml.apiconnector.algorithms.Conversion;
import org.openml.apiconnector.algorithms.TaskInformation;
import org.openml.apiconnector.io.OpenmlConnector;
import org.openml.apiconnector.models.MetricScore;
import org.openml.apiconnector.xml.Task;
import org.openml.weka.algorithm.DataSplits;
import org.openml.weka.algorithm.InstancesHelper;
import org.openml.weka.algorithm.OptimizationTrace;
import org.openml.weka.algorithm.WekaAlgorithm;
import org.openml.weka.algorithm.WekaConfig;
import org.openml.weka.experiment.OpenmlClassificationSplitEvaluator;
import org.openml.weka.experiment.OpenmlSplitEvaluator;
import org.openml.weka.experiment.TaskResultListener;
import weka.core.AttributeStats;
import weka.core.Instances;
import weka.core.UnsupportedAttributeTypeException;
import weka.experiment.CrossValidationResultProducer;
import weka.experiment.OutputZipper;

public class TaskResultProducer
extends CrossValidationResultProducer {
    private static UserMeasures[] USER_MEASURES = new UserMeasures[]{new UserMeasures("predictive_accuracy", "Percent_correct", 0.01), new UserMeasures("kappa", "Kappa_statistic"), new UserMeasures("root_mean_squared_error", "Root_mean_squared_error"), new UserMeasures("root_relative_squared_error", "Root_relative_squared_error", 0.01), new UserMeasures("usercpu_time_millis_training", "UserCPU_Time_millis_training"), new UserMeasures("usercpu_time_millis_testing", "UserCPU_Time_millis_testing"), new UserMeasures("usercpu_time_millis", "UserCPU_Time_millis")};
    private static final long serialVersionUID = 1L;
    public static final String TASK_FIELD_NAME = "OpenML_Task_id";
    public static final String SAMPLE_FIELD_NAME = "Sample";
    protected Task m_Task;
    protected boolean regressionTask;
    protected boolean missingLabels;
    protected DataSplits m_DataSplits;
    protected int m_NumSamples = 1;
    protected String currentTaskRepresentation = "";
    protected OpenmlConnector apiconnector;
    protected WekaConfig openmlconfig;

    public TaskResultProducer(OpenmlConnector apiconnector, WekaConfig openmlconfig) {
        this.m_SplitEvaluator = new OpenmlClassificationSplitEvaluator();
        this.apiconnector = apiconnector;
        this.openmlconfig = openmlconfig;
    }

    public void setTask(Task t) throws Exception {
        this.m_Task = t;
        boolean bl = this.regressionTask = t.getTask_type_id() == 2;
        if (this.regressionTask) {
            throw new Exception("OpenML Plugin Exception: Regression tasks currently not supported. Aborting.");
        }
        this.m_Instances = InstancesHelper.getDatasetFromTask(this.apiconnector, this.m_Task);
        Task.Input.Data_set ds = TaskInformation.getSourceData((Task)this.m_Task);
        int targetAttributeIndex = InstancesHelper.getAttributeIndex(this.m_Instances, ds.getTarget_feature());
        AttributeStats targetStats = this.m_Instances.attributeStats(targetAttributeIndex);
        Task.Input.Estimation_procedure ep = TaskInformation.getEstimationProcedure((Task)this.m_Task);
        Instances splits = new Instances((Reader)new FileReader(ep.getDataSplits(this.m_Task.getTask_id().intValue())));
        this.missingLabels = targetStats.missingCount > 0;
        this.m_DataSplits = new DataSplits(this.m_Task, this.m_Instances, splits);
        this.m_NumFolds = this.m_DataSplits.FOLDS;
        this.m_NumSamples = this.m_DataSplits.SAMPLES;
        this.currentTaskRepresentation = "Task " + this.m_Task.getTask_id() + " (" + TaskInformation.getSourceData((Task)this.m_Task).getDataSetDescription(this.apiconnector).getName() + ")";
    }

    public Object getSplitEvaluatorKey(int index) {
        return this.m_SplitEvaluator.getKey()[index];
    }

    public void setInstances(Instances m_Instances) {
        throw new RuntimeException("TaskResultProducer Exception: function setInstances may not be invoked. Use setTask instead. ");
    }

    public void doFullRun() throws Exception {
        Conversion.log((String)"OK", (String)"Total Model", (String)"Started building a model over the full dataset. ");
        OpenmlSplitEvaluator tse = (OpenmlSplitEvaluator)this.m_SplitEvaluator;
        Map<String, Object> splitEvaluatorResults = WekaAlgorithm.splitEvaluatorToMap(tse, tse.getResult(this.m_Instances, this.m_Instances));
        if (this.m_ResultListener instanceof TaskResultListener) {
            ((TaskResultListener)this.m_ResultListener).acceptFullModel(this.m_Task, this.m_Instances, tse.getClassifier(), (String)tse.getKey()[1], splitEvaluatorResults, tse);
        }
        Conversion.log((String)"OK", (String)"Total Model", (String)"Done building full dataset model. ");
    }

    public void doRun(int run) throws Exception {
        OpenmlSplitEvaluator tse = (OpenmlSplitEvaluator)this.m_SplitEvaluator;
        String currentRunRepresentation = this.currentTaskRepresentation + " with " + (String)tse.getKey()[0] + " - Repeat " + (run - 1);
        Conversion.log((String)"OK", (String)"Attribtes", (String)("Attributes available: " + InstancesHelper.getAttributes(this.m_Instances)));
        Conversion.log((String)"OK", (String)"Class", (String)("Class attribute: " + this.m_Instances.classAttribute()));
        if (this.getRawOutput() && this.m_ZipDest == null) {
            this.m_ZipDest = new OutputZipper(this.m_OutputFile);
        }
        if (this.m_Instances == null) {
            throw new Exception("No Instances set");
        }
        if (this.m_Task == null) {
            throw new Exception("No task set");
        }
        int repeat = run - 1;
        for (int fold = 0; fold < this.m_NumFolds; ++fold) {
            for (int sample = 0; sample < this.m_NumSamples; ++sample) {
                String currentFoldRepresentation = "fold " + fold + ", sample " + sample;
                Conversion.log((String)"INFO", (String)"Perform Run", (String)("Started on performing " + currentRunRepresentation + ", " + currentFoldRepresentation));
                HashMap<String, MetricScore> userMeasures = new HashMap<String, MetricScore>();
                Instances train = this.m_DataSplits.getTrainingSet(repeat, fold, sample);
                Instances test = this.m_DataSplits.getTestSet(repeat, fold, sample);
                try {
                    Object[] seResults = tse.getResult(train, test);
                    Object[] results = new Object[seResults.length + 1];
                    results[0] = TaskResultProducer.getTimestamp();
                    System.arraycopy(seResults, 0, results, 1, seResults.length);
                    Map<String, Object> splitEvaluatorResults = WekaAlgorithm.splitEvaluatorToMap(tse, seResults);
                    List<OptimizationTrace.Quadlet<String, Double, List<Map.Entry<String, Object>>, Boolean>> trace = null;
                    try {
                        trace = OptimizationTrace.extractTrace(tse.getClassifier());
                        Conversion.log((String)"OK", (String)"Trace", (String)"Found MultiSearch or FilteredClassifier(MultiSearch). Extracting trace. ");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (splitEvaluatorResults.containsKey("UserCPU_Time_millis_training") && splitEvaluatorResults.containsKey("UserCPU_Time_millis_testing")) {
                        double traintime = (Double)splitEvaluatorResults.get("UserCPU_Time_millis_training");
                        double testtime = (Double)splitEvaluatorResults.get("UserCPU_Time_millis_testing");
                        splitEvaluatorResults.put("UserCPU_Time_millis", traintime + testtime);
                    }
                    if (!this.missingLabels) {
                        for (UserMeasures um : USER_MEASURES) {
                            if (!splitEvaluatorResults.containsKey(um.wekaFunctionName)) continue;
                            userMeasures.put(um.openmlFunctionName, new MetricScore(Double.valueOf((Double)splitEvaluatorResults.get(um.wekaFunctionName) * um.factor), (long)test.size()));
                        }
                    }
                    boolean modelFullDataset = this.openmlconfig.getModelFullDataset();
                    if (!(this.m_ResultListener instanceof TaskResultListener)) continue;
                    ((TaskResultListener)this.m_ResultListener).acceptResultsForSending(this.m_Task, this.m_Instances, repeat, fold, sample, tse.getClassifier(), (String)tse.getKey()[1], this.m_DataSplits.getTestSetRowIds(repeat, fold, sample), tse.recentPredictions(), userMeasures, trace, modelFullDataset);
                    continue;
                }
                catch (UnsupportedAttributeTypeException ex) {
                    Conversion.log((String)"ERROR", (String)"Perform Run", (String)("Unable to finish " + currentRunRepresentation + ", " + currentFoldRepresentation + " with " + tse.getClassifier().getClass().getName() + ": " + ex.getMessage()));
                    if (!(this.m_ResultListener instanceof TaskResultListener)) continue;
                    ((TaskResultListener)this.m_ResultListener).acceptErrorResult(this.m_Task, this.m_Instances, tse.getClassifier(), ex.getMessage(), (String)tse.getKey()[1]);
                }
            }
        }
    }

    private static class UserMeasures {
        private final String openmlFunctionName;
        private final String wekaFunctionName;
        private final double factor;

        private UserMeasures(String openmlFunctionName, String wekaFunctionName, double factor) {
            this.openmlFunctionName = openmlFunctionName;
            this.wekaFunctionName = wekaFunctionName;
            this.factor = factor;
        }

        private UserMeasures(String openmlFunctionName, String wekaFunctionName) {
            this(openmlFunctionName, wekaFunctionName, 1.0);
        }
    }
}

