/*
 * Decompiled with CFR 0.152.
 */
package org.openml.weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.openml.apiconnector.io.OpenmlConnector;
import org.openml.weka.algorithm.WekaConfig;
import org.openml.weka.experiment.OpenmlClassificationSplitEvaluator;
import org.openml.weka.experiment.TaskBasedExperiment;
import org.openml.weka.experiment.TaskResultListener;
import org.openml.weka.experiment.TaskResultProducer;
import org.openml.weka.gui.AuthenticationDialog;
import org.openml.weka.gui.TaskListPanel;
import weka.classifiers.Classifier;
import weka.experiment.Experiment;
import weka.experiment.PropertyNode;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;
import weka.gui.experiment.AlgorithmListPanel;
import weka.gui.experiment.SetupModePanel;
import weka.gui.experiment.SimpleSetupPanel;

public class OpenmlSimpleSetupPanel
extends SimpleSetupPanel {
    private static final long serialVersionUID = -4411056918296619225L;
    protected TaskBasedExperiment m_Exp;
    protected TaskListPanel m_TaskListPanel;
    protected AlgorithmListPanel m_AlgorithmListPanel = new AlgorithmListPanel();
    protected JButton m_BrowseDestinationButton = new JButton("Change");
    protected JButton m_NotesButton = new JButton("Notes");
    protected JFrame m_NotesFrame = new JFrame("Notes");
    protected JTextArea m_NotesText = new JTextArea(null, 10, 0);
    protected final PropertyChangeSupport m_Support;
    protected OpenmlConnector apiconnector;
    protected WekaConfig openmlconfig;
    protected JLabel m_ResultsDestinationPathLabel = new JLabel("OpenML.org");
    protected JTextField m_ResultsDestinationPathTField = new JTextField();

    public OpenmlSimpleSetupPanel(Experiment exp) {
        this();
        this.setExperiment(exp);
    }

    public OpenmlSimpleSetupPanel() {
        this.m_Support = new PropertyChangeSupport((Object)this);
        this.m_ResultsDestinationPathTField.setEnabled(false);
        try {
            this.openmlconfig = new WekaConfig();
            String apiKey = this.openmlconfig.getApiKey();
            if (this.openmlconfig.getServer() != null) {
                this.apiconnector = new OpenmlConnector(this.openmlconfig.getServer(), apiKey);
                this.m_ResultsDestinationPathTField.setText(OpenmlSimpleSetupPanel.apiKeyToStarred(apiKey));
            } else {
                this.apiconnector = new OpenmlConnector(apiKey);
            }
        }
        catch (RuntimeException e) {
            this.apiconnector = new OpenmlConnector();
        }
        this.m_TaskListPanel = new TaskListPanel(this.apiconnector);
        this.m_NotesFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OpenmlSimpleSetupPanel.this.m_NotesButton.setEnabled(true);
            }
        });
        this.m_NotesFrame.getContentPane().add(new JScrollPane(this.m_NotesText));
        this.m_NotesFrame.setSize(600, 400);
        this.m_NotesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenmlSimpleSetupPanel.this.m_NotesButton.setEnabled(false);
                OpenmlSimpleSetupPanel.this.m_NotesFrame.setVisible(true);
            }
        });
        this.m_NotesButton.setEnabled(false);
        this.m_NotesText.setEditable(true);
        this.m_NotesText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                OpenmlSimpleSetupPanel.this.m_Exp.setNotes(OpenmlSimpleSetupPanel.this.m_NotesText.getText());
            }
        });
        this.m_NotesText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OpenmlSimpleSetupPanel.this.m_Exp.setNotes(OpenmlSimpleSetupPanel.this.m_NotesText.getText());
            }
        });
        this.m_BrowseDestinationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenmlSimpleSetupPanel.this.chooseOpenmlAuthenticate();
            }
        });
        JPanel destInner = new JPanel();
        destInner.setLayout(new BorderLayout(5, 5));
        destInner.add((Component)this.m_ResultsDestinationPathLabel, "West");
        destInner.add((Component)this.m_ResultsDestinationPathTField, "Center");
        destInner.add((Component)this.m_BrowseDestinationButton, "East");
        JPanel dest = new JPanel();
        dest.setLayout(new BorderLayout());
        dest.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Results Destination"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        dest.add((Component)destInner, "North");
        JPanel notes = new JPanel();
        notes.setLayout(new BorderLayout());
        notes.add((Component)this.m_NotesButton, "Center");
        JPanel tasks = new JPanel();
        tasks.setLayout(new BorderLayout());
        tasks.add((Component)((Object)this.m_TaskListPanel), "Center");
        JPanel algorithms = new JPanel();
        algorithms.setLayout(new BorderLayout());
        algorithms.add((Component)this.m_AlgorithmListPanel, "Center");
        JPanel schemes = new JPanel();
        schemes.setLayout(new GridLayout(1, 0));
        schemes.add(tasks);
        schemes.add(algorithms);
        this.setLayout(new BorderLayout());
        this.add(dest, "North");
        this.add(schemes, "Center");
        this.add(notes, "South");
        this.setExperiment(new Experiment());
    }

    public boolean setExperiment(Experiment exp_old) {
        TaskBasedExperiment exp = new TaskBasedExperiment(exp_old, this.apiconnector, this.openmlconfig);
        TaskResultListener trl = new TaskResultListener(this.apiconnector, this.openmlconfig);
        try {
            File f = File.createTempFile("WekaOpenMLResults", "arff");
            f.deleteOnExit();
            trl.setOutputFile(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        exp.setResultListener((ResultListener)trl);
        TaskResultProducer trp = new TaskResultProducer(this.apiconnector, this.openmlconfig);
        OpenmlClassificationSplitEvaluator se = null;
        Classifier sec = null;
        se = new OpenmlClassificationSplitEvaluator();
        sec = se.getClassifier();
        PropertyNode[] propertyPath = new PropertyNode[2];
        try {
            propertyPath[0] = new PropertyNode((Object)se, new PropertyDescriptor("splitEvaluator", TaskResultProducer.class), TaskResultProducer.class);
            propertyPath[1] = new PropertyNode((Object)sec, new PropertyDescriptor("classifier", se.getClass()), se.getClass());
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        exp.setResultProducer((ResultProducer)trp);
        exp.setPropertyPath(propertyPath);
        this.m_TaskListPanel.setExperiment(exp);
        this.m_AlgorithmListPanel.setExperiment((Experiment)exp);
        this.m_Exp = exp;
        this.m_Support.firePropertyChange("", null, null);
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.m_Support == null) {
            return;
        }
        this.m_Support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.removePropertyChangeListener(l);
    }

    public Experiment getExperiment() {
        return this.m_Exp;
    }

    public String getName() {
        return "OpenML Experimenter";
    }

    public void setModePanel(SetupModePanel modePanel) {
    }

    private void chooseOpenmlAuthenticate() {
        AuthenticationDialog ad = new AuthenticationDialog(null);
        ad.setVisible(true);
        if (ad.getReturnValue() == -1) {
            return;
        }
        this.apiconnector.setApiKey(ad.getApiKey());
        this.m_ResultsDestinationPathTField.setText(OpenmlSimpleSetupPanel.apiKeyToStarred(ad.getApiKey()));
    }

    private static String apiKeyToStarred(String apiKey) {
        return "********************" + apiKey.substring(apiKey.length() - 4);
    }
}

