/*
 * Decompiled with CFR 0.152.
 */
package org.openml.weka.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import org.openml.apiconnector.algorithms.Conversion;
import org.openml.apiconnector.io.OpenmlConnector;
import org.openml.apiconnector.xml.Task;
import org.openml.weka.experiment.TaskBasedExperiment;
import weka.experiment.Experiment;
import weka.gui.JListHelper;
import weka.gui.experiment.DatasetListPanel;

public class TaskListPanel
extends DatasetListPanel {
    private static final long serialVersionUID = 1L;
    protected Experiment m_Exp;
    private OpenmlConnector apiconnector;

    public TaskListPanel(OpenmlConnector ac) {
        this.apiconnector = ac;
        this.setBorder(BorderFactory.createTitledBorder("Tasks"));
    }

    private void setButtons(ListSelectionEvent e) {
        if (e == null || e.getSource() == this.m_List) {
            this.m_DeleteBut.setEnabled(this.m_List.getSelectedIndex() > -1);
            this.m_EditBut.setEnabled(false);
            this.m_UpBut.setEnabled(JListHelper.canMoveUp((JList)this.m_List));
            this.m_DownBut.setEnabled(JListHelper.canMoveDown((JList)this.m_List));
        }
    }

    public void setExperiment(Experiment exp) {
        this.m_Exp = exp;
        this.m_List.setModel(this.getTasksControlled(this.m_Exp));
        this.m_AddBut.setEnabled(true);
        this.setButtons(null);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_AddBut) {
            this.actionPerformedTaskBasedAdd(e);
        } else if (e.getSource() == this.m_DeleteBut) {
            int[] selected = this.m_List.getSelectedIndices();
            if (selected != null) {
                for (int i = selected.length - 1; i >= 0; --i) {
                    int current = selected[i];
                    this.getTasksControlled(this.m_Exp).removeElementAt(current);
                    if (this.getTasksControlled(this.m_Exp).size() > current) {
                        this.m_List.setSelectedIndex(current);
                        continue;
                    }
                    this.m_List.setSelectedIndex(current - 1);
                }
            }
            this.setButtons(null);
        } else if (e.getSource() == this.m_EditBut) {
            this.actionPerformedTaskBasedEdit(e);
        } else if (e.getSource() == this.m_UpBut) {
            JListHelper.moveUp((JList)this.m_List);
        } else if (e.getSource() == this.m_DownBut) {
            JListHelper.moveDown((JList)this.m_List);
        }
    }

    public void actionPerformedTaskBasedAdd(ActionEvent e) {
        String s = JOptionPane.showInputDialog((Component)((Object)this), "A comma-separated list of the task id's from OpenML.org:", "OpenML Task id's", -1);
        try {
            int[] input_task_ids = Conversion.commaSeparatedStringToIntArray((String)s);
            for (int i = 0; i < input_task_ids.length; ++i) {
                if (this.getTasksControlled(this.m_Exp).contains(new Task(input_task_ids[i]))) continue;
                try {
                    Task t = this.apiconnector.taskGet(input_task_ids[i]);
                    if (this.m_Exp instanceof TaskBasedExperiment) {
                        this.getTasksControlled(this.m_Exp).addElement(t);
                        continue;
                    }
                    System.err.println("Could not add task to Queue... ");
                    continue;
                }
                catch (Exception downloadException) {
                    downloadException.printStackTrace();
                    JOptionPane.showMessageDialog((Component)((Object)this), "There occured an error while downloading (the data of) Task " + input_task_ids[i] + ". Please double check whether this is a legal task id. Otherwise some input data might be missing. ", "Task download error", 0);
                }
            }
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please insert a comma seperated list of task_id's. These are all numbers. ", "Wrong input", 0);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void actionPerformedTaskBasedEdit(ActionEvent e) {
        System.out.println("TODO, function not yet implemented.");
    }

    private DefaultListModel<Task> getTasksControlled(Experiment exp) {
        return ((TaskBasedExperiment)exp).getTasks();
    }
}

