/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.unsupervised.attribute.RemoveUseless;

public class RemoveUnusedClassValues
extends SimpleBatchFilter
implements OptionHandler {
    private static final long serialVersionUID = 5724291284990109383L;
    private int oldClassIndex;
    private int threshold = 1;

    public String globalInfo() {
        return "A simple batch filter that replaces a nominal class with a nominal class that only contains the used values.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) {
        inputFormat = this.getInputFormat();
        Instances result = new Instances(inputFormat, 0);
        int[] usedClassValues = inputFormat.attributeStats((int)inputFormat.classIndex()).nominalCounts;
        this.oldClassIndex = inputFormat.classIndex();
        ArrayList<String> newClassValues = new ArrayList<String>();
        for (int i = 0; i < usedClassValues.length; ++i) {
            if (usedClassValues[i] <= this.threshold) continue;
            newClassValues.add(inputFormat.classAttribute().value(i));
        }
        result.setClassIndex(-1);
        result.deleteAttributeAt(this.oldClassIndex);
        Attribute newClassAttribute = new Attribute("class", newClassValues);
        result.insertAttributeAt(newClassAttribute, this.oldClassIndex);
        result.setClassIndex(this.oldClassIndex);
        return result;
    }

    protected Instances process(Instances inst) {
        Instances result = new Instances(this.determineOutputFormat(inst), inst.numInstances());
        for (int i = 0; i < inst.numInstances(); ++i) {
            double[] values = new double[result.numAttributes()];
            for (int n = 0; n < inst.numAttributes(); ++n) {
                if (n == this.oldClassIndex) {
                    String oldValue = inst.classAttribute().value((int)inst.instance(i).classValue());
                    values[n] = result.classAttribute().indexOfValue(oldValue);
                    continue;
                }
                values[n] = inst.instance(i).value(n);
            }
            if (values[this.oldClassIndex] < 0.0) {
                System.out.println("Discarded (0-based) instance: " + i);
                continue;
            }
            DenseInstance newInstance = new DenseInstance(1.0, values);
            result.add((Instance)newInstance);
        }
        return result;
    }

    public void setOptions(String[] options) throws Exception {
        this.threshold = Integer.parseInt(Utils.getOption((char)'T', (String[])options));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tSpecifies threshold of occurences. Every value occuring less than T will be removed from class.\n\t(default none)", "T", 1, "-T <int1>"));
        return newVector.elements();
    }

    public String[] getOptions() {
        String[] options = new String[2];
        int current = 0;
        options[current++] = "-T";
        options[current++] = this.threshold + "";
        return options;
    }

    public static void main(String[] argv) {
        RemoveUnusedClassValues.runFilter((Filter)new RemoveUseless(), (String[])argv);
    }
}

