/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.openml.apiconnector.algorithms.Conversion;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.SimpleBatchFilter;

public class ReplaceMissingNumericValuesAndIndicate
extends SimpleBatchFilter
implements OptionHandler {
    private static final long serialVersionUID = -6903848882440211704L;
    private static final String ATTNAME_INDICATOR = "replacedMissingNumericValues";
    private double[] medians;
    private int[] imputations;

    public String globalInfo() {
        return "Replaces missing values and adds an indicator column toindicate instances that had missing values.";
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        inputFormat.insertAttributeAt(ReplaceMissingNumericValuesAndIndicate.getIndicatorAttribute(), inputFormat.numAttributes() - 1);
        return inputFormat;
    }

    protected void searchMedian(Instances instances) {
        int j;
        this.medians = new double[instances.numAttributes()];
        this.imputations = new int[instances.numAttributes()];
        for (j = 0; j < instances.numAttributes(); ++j) {
            int numPresentValues = 0;
            if (!instances.attribute(j).isNumeric()) continue;
            double[] values = new double[instances.numInstances()];
            for (int i = 0; i < instances.numInstances(); ++i) {
                Instance current = instances.get(i);
                if (Utils.isMissingValue((double)current.value(j))) continue;
                values[numPresentValues] = current.value(j);
                ++numPresentValues;
            }
            if (numPresentValues <= 0) continue;
            double[] goodValues = Arrays.copyOf(values, numPresentValues);
            Median median = new Median();
            this.medians[j] = median.evaluate(goodValues);
        }
        for (j = 0; j < instances.numAttributes(); ++j) {
            if (!instances.attribute(j).isNumeric()) continue;
            Conversion.log((String)"OK", (String)"Impute Numeric", (String)("Attribute " + instances.attribute(j) + " - Median: " + this.medians[j]));
        }
    }

    protected void imputeMedian(Instances instances) {
        Attribute indicator = instances.attribute(ATTNAME_INDICATOR);
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance current = instances.get(i);
            current.setValue(indicator, 0.0);
            for (int j = 0; j < instances.numAttributes(); ++j) {
                if (!instances.attribute(j).isNumeric() || !Utils.isMissingValue((double)current.value(j))) continue;
                current.setValue(j, this.medians[j]);
                current.setValue(indicator, 1.0);
                int n = j;
                this.imputations[n] = this.imputations[n] + 1;
            }
        }
    }

    protected Instances process(Instances instances) throws Exception {
        instances.insertAttributeAt(ReplaceMissingNumericValuesAndIndicate.getIndicatorAttribute(), instances.numAttributes() - 1);
        if (!this.m_FirstBatchDone) {
            this.searchMedian(instances);
        }
        this.imputeMedian(instances);
        return instances;
    }

    private static Attribute getIndicatorAttribute() {
        ArrayList<String> values = new ArrayList<String>();
        values.add("false");
        values.add("true");
        Attribute indicator = new Attribute(ATTNAME_INDICATOR, values);
        return indicator;
    }
}

