/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.awt.Point;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;

public class TMSTileSource
extends AbstractTMSTileSource {
    protected int maxZoom;
    protected int minZoom;
    protected OsmMercator osmMercator;

    public TMSTileSource(TileSourceInfo info) {
        super(info);
        this.minZoom = info.getMinZoom();
        this.maxZoom = info.getMaxZoom();
        this.osmMercator = new OsmMercator(this.getTileSize());
    }

    @Override
    public int getMinZoom() {
        return this.minZoom == 0 ? super.getMinZoom() : this.minZoom;
    }

    @Override
    public int getMaxZoom() {
        return this.maxZoom == 0 ? super.getMaxZoom() : this.maxZoom;
    }

    @Override
    public double getDistance(double lat1, double lon1, double lat2, double lon2) {
        return this.osmMercator.getDistance(lat1, lon1, lat2, lon2);
    }

    @Override
    public Point latLonToXY(double lat, double lon, int zoom) {
        return new Point((int)this.osmMercator.lonToX(lon, zoom), (int)this.osmMercator.latToY(lat, zoom));
    }

    @Override
    public ICoordinate xyToLatLon(int x, int y, int zoom) {
        return new Coordinate(this.osmMercator.yToLat(y, zoom), this.osmMercator.xToLon(x, zoom));
    }

    @Override
    public TileXY latLonToTileXY(double lat, double lon, int zoom) {
        return new TileXY(this.osmMercator.lonToX(lon, zoom) / (double)this.getTileSize(), this.osmMercator.latToY(lat, zoom) / (double)this.getTileSize());
    }

    @Override
    public ICoordinate tileXYToLatLon(int x, int y, int zoom) {
        return new Coordinate(this.osmMercator.yToLat(y * this.getTileSize(), zoom), this.osmMercator.xToLon(x * this.getTileSize(), zoom));
    }
}

