/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.CachedTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileClearController;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class OsmFileCacheTileLoader
extends OsmTileLoader
implements CachedTileLoader {
    private static final Logger log = FeatureAdapter.getLogger(OsmFileCacheTileLoader.class.getName());
    protected static final String TAGS_FILE_EXT = "tags";
    private static final Charset TAGS_CHARSET = Charset.forName("UTF-8");
    public static final long FILE_AGE_ONE_DAY = 86400000L;
    public static final long FILE_AGE_ONE_WEEK = 604800000L;
    protected String cacheDirBase;
    protected final Map<TileSource, File> sourceCacheDirMap;
    protected long maxCacheFileAge = Long.MAX_VALUE;
    protected long recheckAfter = 604800000L;

    public static File getDefaultCacheDir() throws SecurityException {
        String tempDir = null;
        String userName = System.getProperty("user.name");
        try {
            tempDir = System.getProperty("java.io.tmpdir");
        }
        catch (SecurityException e) {
            log.log(Level.WARNING, "Failed to access system property ''java.io.tmpdir'' for security reasons. Exception was: " + e.toString());
            throw e;
        }
        try {
            if (tempDir == null) {
                throw new IOException("No temp directory set");
            }
            String subDirName = "JMapViewerTiles";
            if (userName != null && userName.length() > 0) {
                subDirName = subDirName + "_" + userName;
            }
            File cacheDir = new File(tempDir, subDirName);
            return cacheDir;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public OsmFileCacheTileLoader(TileLoaderListener map, File cacheDir) throws IOException {
        super(map);
        if (cacheDir == null || !cacheDir.exists() && !cacheDir.mkdirs()) {
            throw new IOException("Cannot access cache directory");
        }
        log.finest("Tile cache directory: " + cacheDir);
        this.cacheDirBase = cacheDir.getAbsolutePath();
        this.sourceCacheDirMap = new HashMap<TileSource, File>();
    }

    public OsmFileCacheTileLoader(TileLoaderListener map) throws SecurityException, IOException {
        this(map, OsmFileCacheTileLoader.getDefaultCacheDir());
    }

    @Override
    public TileJob createTileLoaderJob(Tile tile) {
        return new FileLoadJob(tile);
    }

    protected File getSourceCacheDir(TileSource source) {
        File dir = this.sourceCacheDirMap.get(source);
        if (dir == null && !(dir = new File(this.cacheDirBase, source.getName().replaceAll("[\\\\/:*?\"<>|]", "_"))).exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public long getMaxFileAge() {
        return this.maxCacheFileAge;
    }

    public void setCacheMaxFileAge(long maxFileAge) {
        this.maxCacheFileAge = maxFileAge;
    }

    public String getCacheDirBase() {
        return this.cacheDirBase;
    }

    public void setTileCacheDir(String tileCacheDir) {
        File dir = new File(tileCacheDir);
        dir.mkdirs();
        this.cacheDirBase = dir.getAbsolutePath();
    }

    @Override
    public void clearCache(TileSource source) {
        this.clearCache(source, null);
    }

    @Override
    public void clearCache(TileSource source, TileClearController controller) {
        File dir = this.getSourceCacheDir(source);
        if (dir != null) {
            if (controller != null) {
                controller.initClearDir(dir);
            }
            if (dir.isDirectory()) {
                File[] files = dir.listFiles();
                if (controller != null) {
                    controller.initClearFiles(files);
                }
                for (File file : files) {
                    if (controller != null && controller.cancel()) {
                        return;
                    }
                    file.delete();
                    if (controller == null) continue;
                    controller.fileDeleted(file);
                }
            }
            dir.delete();
        }
        if (controller != null) {
            controller.clearFinished();
        }
    }

    protected class FileLoadJob
    implements TileJob {
        InputStream input = null;
        Tile tile;
        File tileCacheDir;
        File tileFile = null;
        Long fileMtime = null;
        Long now = null;

        public FileLoadJob(Tile tile) {
            this.tile = tile;
        }

        @Override
        public Tile getTile() {
            return this.tile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Tile tile = this.tile;
            synchronized (tile) {
                if (this.tile.isLoaded() && !this.tile.hasError() || this.tile.isLoading()) {
                    return;
                }
                this.tile.loaded = false;
                this.tile.error = false;
                this.tile.loading = true;
            }
            this.now = System.currentTimeMillis();
            this.tileCacheDir = OsmFileCacheTileLoader.this.getSourceCacheDir(this.tile.getSource());
            if (this.loadTileFromFile(OsmFileCacheTileLoader.this.recheckAfter)) {
                log.log(Level.FINE, "TMS - found in tile cache: {0}", this.tile);
                this.tile.setLoaded(true);
                OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, true);
                return;
            }
            TileJob job = new TileJob(){

                @Override
                public void run() {
                    if (FileLoadJob.this.loadOrUpdateTile()) {
                        FileLoadJob.this.tile.setLoaded(true);
                        OsmFileCacheTileLoader.this.listener.tileLoadingFinished(FileLoadJob.this.tile, true);
                    } else if (FileLoadJob.this.loadTileFromFile(OsmFileCacheTileLoader.this.maxCacheFileAge)) {
                        FileLoadJob.this.tile.setLoaded(true);
                        FileLoadJob.this.tile.error = false;
                        OsmFileCacheTileLoader.this.listener.tileLoadingFinished(FileLoadJob.this.tile, true);
                        log.log(Level.FINE, "TMS - found stale tile in cache: {0}", FileLoadJob.this.tile);
                    } else {
                        FileLoadJob.this.tile.setLoaded(true);
                        OsmFileCacheTileLoader.this.listener.tileLoadingFinished(FileLoadJob.this.tile, false);
                    }
                }

                @Override
                public Tile getTile() {
                    return FileLoadJob.this.tile;
                }
            };
            JobDispatcher.getInstance().addJob(job);
        }

        protected boolean loadOrUpdateTile() {
            block24: {
                try {
                    URLConnection urlConn = OsmFileCacheTileLoader.this.loadTileFromOsm(this.tile);
                    if (this.fileMtime != null && this.now - this.fileMtime <= OsmFileCacheTileLoader.this.maxCacheFileAge) {
                        switch (this.tile.getSource().getTileUpdate()) {
                            case IfModifiedSince: {
                                urlConn.setIfModifiedSince(this.fileMtime);
                                break;
                            }
                            case LastModified: {
                                if (this.isOsmTileNewer(this.fileMtime)) break;
                                log.log(Level.FINE, "TMS - LastModified test: local version is up to date: {0}", this.tile);
                                this.tileFile.setLastModified(this.now);
                                return true;
                            }
                        }
                    }
                    if (this.tile.getSource().getTileUpdate() == TileSource.TileUpdate.ETag || this.tile.getSource().getTileUpdate() == TileSource.TileUpdate.IfNoneMatch) {
                        String fileETag = this.tile.getValue("etag");
                        if (fileETag != null) {
                            switch (this.tile.getSource().getTileUpdate()) {
                                case IfNoneMatch: {
                                    urlConn.addRequestProperty("If-None-Match", fileETag);
                                    break;
                                }
                                case ETag: {
                                    if (!this.hasOsmTileETag(fileETag)) break;
                                    log.log(Level.FINE, "TMS - ETag test: local version is up to date: {0}", this.tile);
                                    this.tileFile.setLastModified(this.now);
                                    return true;
                                }
                            }
                        }
                        this.tile.putValue("etag", urlConn.getHeaderField("ETag"));
                    }
                    if (urlConn instanceof HttpURLConnection && ((HttpURLConnection)urlConn).getResponseCode() == 304) {
                        switch (this.tile.getSource().getTileUpdate()) {
                            case IfModifiedSince: {
                                log.log(Level.FINE, "TMS - IfModifiedSince test: local version is up to date: {0}", this.tile);
                                break;
                            }
                            case IfNoneMatch: {
                                log.log(Level.FINE, "TMS - IfNoneMatch test: local version is up to date: {0}", this.tile);
                                break;
                            }
                        }
                        if (this.loadTileFromFile(OsmFileCacheTileLoader.this.maxCacheFileAge)) {
                            this.tileFile.setLastModified(this.now);
                            return true;
                        }
                    }
                    OsmFileCacheTileLoader.this.loadTileMetadata(this.tile, urlConn);
                    this.saveTagsToFile();
                    if ("no-tile".equals(this.tile.getValue("tile-info"))) {
                        log.log(Level.FINE, "TMS - No tile: tile-info=no-tile: {0}", this.tile);
                        this.tile.setError("No tile at this zoom level");
                        return true;
                    }
                    for (int i = 0; i < 5; ++i) {
                        if (urlConn instanceof HttpURLConnection && ((HttpURLConnection)urlConn).getResponseCode() == 503) {
                            Thread.sleep(5000 + new Random().nextInt(5000));
                            continue;
                        }
                        byte[] buffer = this.loadTileInBuffer(urlConn);
                        if (buffer == null) continue;
                        this.tile.loadImage(new ByteArrayInputStream(buffer));
                        this.saveTileToFile(buffer);
                        log.log(Level.FINE, "TMS - downloaded tile from server: {0}", this.tile.getUrl());
                        return true;
                    }
                }
                catch (Exception e) {
                    this.tile.setError(e.getMessage());
                    if (this.input != null) break block24;
                    try {
                        log.log(Level.WARNING, "TMS - Failed downloading {0}: {1}", new Object[]{this.tile.getUrl(), e.getMessage()});
                        return false;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            log.log(Level.WARNING, "TMS - Failed downloading tile: {0}", this.tile);
            return false;
        }

        protected boolean loadTileFromFile(long maxAge) {
            try {
                this.tileFile = this.getTileFile();
                if (!this.tileFile.exists()) {
                    return false;
                }
                this.loadTagsFromFile();
                this.fileMtime = this.tileFile.lastModified();
                if (this.now - this.fileMtime > maxAge) {
                    return false;
                }
                if ("no-tile".equals(this.tile.getValue("tile-info"))) {
                    this.tile.setError("No tile at this zoom level");
                    if (this.tileFile.exists()) {
                        this.tileFile.delete();
                    }
                    this.tileFile = null;
                } else {
                    try (FileInputStream fin = new FileInputStream(this.tileFile);){
                        if (fin.available() == 0) {
                            throw new IOException("File empty");
                        }
                        this.tile.loadImage(fin);
                    }
                }
                return true;
            }
            catch (Exception e) {
                log.log(Level.WARNING, "TMS - Error while loading image from tile cache: {0}; {1}", new Object[]{e.getMessage(), this.tile});
                this.tileFile.delete();
                this.tileFile = null;
                this.fileMtime = null;
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected byte[] loadTileInBuffer(URLConnection urlConn) throws IOException {
            this.input = urlConn.getInputStream();
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream(this.input.available());
                byte[] buffer = new byte[2048];
                boolean finished = false;
                do {
                    int read;
                    if ((read = this.input.read(buffer)) >= 0) {
                        bout.write(buffer, 0, read);
                        continue;
                    }
                    finished = true;
                } while (!finished);
                if (bout.size() == 0) {
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] byArray = bout.toByteArray();
                return byArray;
            }
            finally {
                this.input.close();
                this.input = null;
            }
        }

        protected boolean isOsmTileNewer(long fileAge) throws IOException {
            URL url = new URL(this.tile.getUrl());
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            OsmFileCacheTileLoader.this.prepareHttpUrlConnection(urlConn);
            urlConn.setRequestMethod("HEAD");
            urlConn.setReadTimeout(30000);
            long lastModified = urlConn.getLastModified();
            if (lastModified == 0L) {
                return true;
            }
            return lastModified > fileAge;
        }

        protected boolean hasOsmTileETag(String eTag) throws IOException {
            URL url = new URL(this.tile.getUrl());
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            OsmFileCacheTileLoader.this.prepareHttpUrlConnection(urlConn);
            urlConn.setRequestMethod("HEAD");
            urlConn.setReadTimeout(30000);
            String osmETag = urlConn.getHeaderField("ETag");
            if (osmETag == null) {
                return true;
            }
            return osmETag.equals(eTag);
        }

        protected File getTileFile() {
            return new File(this.tileCacheDir + "/" + this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + "." + this.tile.getSource().getTileType());
        }

        protected File getTagsFile() {
            return new File(this.tileCacheDir + "/" + this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + "." + OsmFileCacheTileLoader.TAGS_FILE_EXT);
        }

        protected void saveTileToFile(byte[] rawData) {
            File file = this.getTileFile();
            file.getParentFile().mkdirs();
            try (FileOutputStream f = new FileOutputStream(file);){
                f.write(rawData);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to save tile content: {0}", e.getLocalizedMessage());
            }
        }

        protected void saveTagsToFile() {
            File tagsFile = this.getTagsFile();
            tagsFile.getParentFile().mkdirs();
            if (this.tile.getMetadata() == null) {
                tagsFile.delete();
                return;
            }
            try (PrintWriter f = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tagsFile), TAGS_CHARSET));){
                for (Map.Entry<String, String> entry : this.tile.getMetadata().entrySet()) {
                    f.println(entry.getKey() + "=" + entry.getValue());
                }
            }
            catch (Exception e) {
                System.err.println("Failed to save tile tags: " + e.getLocalizedMessage());
            }
        }

        protected void loadTagsFromFile() {
            File tagsFile = this.getTagsFile();
            try (BufferedReader f = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tagsFile), TAGS_CHARSET));){
                String line = f.readLine();
                while (line != null) {
                    int i = line.indexOf(61);
                    if (i == -1 || i == 0) {
                        System.err.println("Malformed tile tag in file '" + tagsFile.getName() + "':" + line);
                    } else {
                        this.tile.putValue(line.substring(0, i), line.substring(i + 1));
                    }
                    line = f.readLine();
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (Exception e) {
                System.err.println("Failed to load tile tags: " + e.getLocalizedMessage());
            }
        }
    }
}

