/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.File;
import java.io.IOException;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class TMSFileCacheTileLoader
extends OsmFileCacheTileLoader {
    public TMSFileCacheTileLoader(TileLoaderListener map, File cacheDir) throws IOException {
        super(map, cacheDir);
    }

    @Override
    public TileJob createTileLoaderJob(Tile tile) {
        return new TMSFileLoadJob(tile);
    }

    @Override
    protected File getSourceCacheDir(TileSource source) {
        String id;
        File dir = (File)this.sourceCacheDirMap.get(source);
        if (dir == null && !(dir = (id = source.getId()) != null ? new File(this.cacheDirBase, id) : new File(this.cacheDirBase, source.getName().replaceAll("[\\\\/:*?\"<>|]", "_"))).exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    protected class TMSFileLoadJob
    extends OsmFileCacheTileLoader.FileLoadJob {
        public TMSFileLoadJob(Tile tile) {
            super(tile);
        }

        @Override
        protected File getTileFile() {
            return this.getDataFile(this.tile.getSource().getTileType());
        }

        @Override
        protected File getTagsFile() {
            return this.getDataFile("tags");
        }

        protected File getDataFile(String ext) {
            int nDigits = (int)Math.ceil(Math.log10(1 << this.tile.getZoom()));
            String x = String.format("%0" + nDigits + "d", this.tile.getXtile());
            String y = String.format("%0" + nDigits + "d", this.tile.getYtile());
            File path = new File(this.tileCacheDir, "z" + this.tile.getZoom());
            for (int i = 0; i < nDigits; ++i) {
                String component = "x" + x.substring(i, i + 1) + "y" + y.substring(i, i + 1);
                if (i == nDigits - 1) {
                    component = component + "." + ext;
                }
                path = new File(path, component);
            }
            return path;
        }
    }
}

