/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;

public class TemplatedTMSTileSource
extends TMSTileSource {
    private Random rand = null;
    private String[] randomParts = null;
    private Map<String, String> headers = new HashMap<String, String>();
    public static final String COOKIE_HEADER = "Cookie";
    public static final String PATTERN_ZOOM = "\\{(?:(\\d+)-)?z(?:oom)?([+-]\\d+)?\\}";
    public static final String PATTERN_X = "\\{x\\}";
    public static final String PATTERN_Y = "\\{y\\}";
    public static final String PATTERN_Y_YAHOO = "\\{!y\\}";
    public static final String PATTERN_NEG_Y = "\\{-y\\}";
    public static final String PATTERN_SWITCH = "\\{switch:([^}]+)\\}";
    public static final String PATTERN_HEADER = "\\{header\\(([^,]+),([^}]+)\\)\\}";
    public static final String[] ALL_PATTERNS = new String[]{"\\{header\\(([^,]+),([^}]+)\\)\\}", "\\{(?:(\\d+)-)?z(?:oom)?([+-]\\d+)?\\}", "\\{x\\}", "\\{y\\}", "\\{!y\\}", "\\{-y\\}", "\\{switch:([^}]+)\\}"};

    public TemplatedTMSTileSource(String name, String url, String id, int maxZoom) {
        super(name, url, id, maxZoom);
        this.handleTemplate();
    }

    public TemplatedTMSTileSource(String name, String url, String id, int minZoom, int maxZoom) {
        super(name, url, id, minZoom, maxZoom);
        this.handleTemplate();
    }

    public TemplatedTMSTileSource(String name, String url, String id, int minZoom, int maxZoom, String cookies) {
        super(name, url, id, minZoom, maxZoom);
        if (cookies != null) {
            this.headers.put(COOKIE_HEADER, cookies);
        }
        this.handleTemplate();
    }

    private void handleTemplate() {
        Matcher m = Pattern.compile(".*\\{switch:([^}]+)\\}.*").matcher(this.baseUrl);
        if (m.matches()) {
            this.rand = new Random();
            this.randomParts = m.group(1).split(",");
        }
        Pattern pattern = Pattern.compile(PATTERN_HEADER);
        StringBuffer output = new StringBuffer();
        Matcher matcher = pattern.matcher(this.baseUrl);
        while (matcher.find()) {
            this.headers.put(matcher.group(1), matcher.group(2));
            matcher.appendReplacement(output, "");
        }
        matcher.appendTail(output);
        this.baseUrl = output.toString();
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) {
        int finalZoom = zoom;
        Matcher m = Pattern.compile(".*\\{(?:(\\d+)-)?z(?:oom)?([+-]\\d+)?\\}.*").matcher(this.baseUrl);
        if (m.matches()) {
            if (m.group(1) != null) {
                finalZoom = Integer.valueOf(m.group(1)) - zoom;
            }
            if (m.group(2) != null) {
                String ofs = m.group(2);
                if (ofs.startsWith("+")) {
                    ofs = ofs.substring(1);
                }
                finalZoom += Integer.valueOf(ofs).intValue();
            }
        }
        String r = this.baseUrl.replaceAll(PATTERN_ZOOM, Integer.toString(finalZoom)).replaceAll(PATTERN_X, Integer.toString(tilex)).replaceAll(PATTERN_Y, Integer.toString(tiley)).replaceAll(PATTERN_Y_YAHOO, Integer.toString((int)Math.pow(2.0, zoom - 1) - 1 - tiley)).replaceAll(PATTERN_NEG_Y, Integer.toString((int)Math.pow(2.0, zoom) - 1 - tiley));
        if (this.rand != null) {
            r = r.replaceAll(PATTERN_SWITCH, this.randomParts[this.rand.nextInt(this.randomParts.length)]);
        }
        return r;
    }
}

