/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.packageManagement;

import org.pentaho.packageManagement.Package;
import org.pentaho.packageManagement.PackageConstraint;
import org.pentaho.packageManagement.VersionRangePackageConstraint;

public class VersionPackageConstraint
extends PackageConstraint {
    public static String VERSION_KEY = "Version";
    protected VersionComparison m_constraint = null;

    protected static VersionComparison getVersionComparison(String compOpp) {
        for (VersionComparison v : VersionComparison.values()) {
            if (!v.toString().equalsIgnoreCase(compOpp)) continue;
            return v;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int[] parseVersion(String version) {
        int major = 0;
        int minor = 0;
        int revision = 0;
        int[] majMinRev = new int[3];
        try {
            String tmpStr = version;
            tmpStr = tmpStr.toLowerCase().replace("-snapshot", "");
            tmpStr = tmpStr.replace('-', '.');
            if (tmpStr.indexOf(".") > -1) {
                major = Integer.parseInt(tmpStr.substring(0, tmpStr.indexOf(".")));
                if ((tmpStr = tmpStr.substring(tmpStr.indexOf(".") + 1)).indexOf(".") > -1) {
                    minor = Integer.parseInt(tmpStr.substring(0, tmpStr.indexOf(".")));
                    revision = !(tmpStr = tmpStr.substring(tmpStr.indexOf(".") + 1)).equals("") ? Integer.parseInt(tmpStr) : 0;
                } else {
                    minor = !tmpStr.equals("") ? Integer.parseInt(tmpStr) : 0;
                }
            } else {
                major = !tmpStr.equals("") ? Integer.parseInt(tmpStr) : 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            major = -1;
            minor = -1;
            revision = -1;
        }
        finally {
            majMinRev[0] = major;
            majMinRev[1] = minor;
            majMinRev[2] = revision;
        }
        return majMinRev;
    }

    protected static boolean checkConstraint(String version1, VersionComparison constraint, String version2) {
        VersionComparison c = VersionPackageConstraint.compare(version1, version2);
        return constraint.compatibleWith(c);
    }

    protected static VersionComparison compare(String version1, String version2) {
        int[] majMinRev2;
        int[] majMinRev1 = VersionPackageConstraint.parseVersion(version1);
        VersionComparison result = majMinRev1[0] < (majMinRev2 = VersionPackageConstraint.parseVersion(version2))[0] ? VersionComparison.LESSTHAN : (majMinRev1[0] == majMinRev2[0] ? (majMinRev1[1] < majMinRev2[1] ? VersionComparison.LESSTHAN : (majMinRev1[1] == majMinRev2[1] ? (majMinRev1[2] < majMinRev2[2] ? VersionComparison.LESSTHAN : (majMinRev1[2] == majMinRev2[2] ? VersionComparison.EQUAL : VersionComparison.GREATERTHAN)) : VersionComparison.GREATERTHAN)) : VersionComparison.GREATERTHAN);
        return result;
    }

    public VersionPackageConstraint(Package p) {
        this.setPackage(p);
    }

    public void setVersionConstraint(VersionComparison c) {
        this.m_constraint = c;
    }

    public VersionComparison getVersionComparison() {
        return this.m_constraint;
    }

    public void setVersionConstraint(String constraint) {
        for (VersionComparison v : VersionComparison.values()) {
            if (!v.toString().equalsIgnoreCase(constraint)) continue;
            this.m_constraint = v;
            break;
        }
    }

    @Override
    public PackageConstraint checkConstraint(PackageConstraint target) throws Exception {
        if (this.m_constraint == null) {
            throw new Exception("[VersionPackageConstraint] No constraint has been set!");
        }
        if (target instanceof VersionRangePackageConstraint) {
            return target.checkConstraint(this);
        }
        String targetVersion = target.getPackage().getPackageMetaDataElement(VERSION_KEY).toString();
        String thisVersion = this.m_thePackage.getPackageMetaDataElement(VERSION_KEY).toString();
        VersionComparison comp = VersionPackageConstraint.compare(thisVersion, targetVersion);
        if (comp == VersionComparison.EQUAL) {
            if (this.m_constraint == ((VersionPackageConstraint)target).getVersionComparison()) {
                return this;
            }
            if (this.m_constraint == VersionComparison.GREATERTHAN && (((VersionPackageConstraint)target).getVersionComparison() == VersionComparison.GREATERTHAN || ((VersionPackageConstraint)target).getVersionComparison() == VersionComparison.GREATERTHANOREQUAL)) {
                return this;
            }
            if ((this.m_constraint == VersionComparison.GREATERTHANOREQUAL || this.m_constraint == VersionComparison.GREATERTHAN) && ((VersionPackageConstraint)target).getVersionComparison() == VersionComparison.GREATERTHAN) {
                return target;
            }
            return null;
        }
        if (((VersionPackageConstraint)target).getVersionComparison() == VersionComparison.GREATERTHAN || ((VersionPackageConstraint)target).getVersionComparison() == VersionComparison.GREATERTHANOREQUAL) {
            if (this.m_constraint == VersionComparison.EQUAL || this.m_constraint == VersionComparison.GREATERTHAN || this.m_constraint == VersionComparison.GREATERTHANOREQUAL) {
                if (comp == VersionComparison.GREATERTHAN) {
                    return this;
                }
                return target;
            }
            return null;
        }
        if (((VersionPackageConstraint)target).getVersionComparison() == VersionComparison.LESSTHAN || ((VersionPackageConstraint)target).getVersionComparison() == VersionComparison.LESSTHANOREQUAL) {
            if (this.m_constraint == VersionComparison.EQUAL || this.m_constraint == VersionComparison.LESSTHAN || this.m_constraint == VersionComparison.LESSTHANOREQUAL) {
                if (comp == VersionComparison.GREATERTHAN) {
                    return target;
                }
                return this;
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean checkConstraint(Package target) throws Exception {
        if (this.m_constraint == null) {
            throw new Exception("[VersionPackageConstraint] No constraint has been set!");
        }
        String targetVersion = target.getPackageMetaDataElement(VERSION_KEY).toString();
        String thisVersion = this.m_thePackage.getPackageMetaDataElement(VERSION_KEY).toString();
        return VersionPackageConstraint.checkConstraint(targetVersion, this.m_constraint, thisVersion);
    }

    public String toString() {
        String result = this.m_thePackage.getPackageMetaDataElement("PackageName").toString() + " (" + (Object)((Object)this.m_constraint) + this.m_thePackage.getPackageMetaDataElement("Version").toString() + ")";
        return result;
    }

    public static enum VersionComparison {
        EQUAL("="){

            @Override
            boolean compatibleWith(VersionComparison v) {
                return v == EQUAL;
            }
        }
        ,
        GREATERTHAN(">"){

            @Override
            boolean compatibleWith(VersionComparison v) {
                return v == GREATERTHAN;
            }
        }
        ,
        GREATERTHANOREQUAL(">="){

            @Override
            boolean compatibleWith(VersionComparison v) {
                return v != LESSTHAN && v != LESSTHANOREQUAL;
            }
        }
        ,
        LESSTHAN("<"){

            @Override
            boolean compatibleWith(VersionComparison v) {
                return v == LESSTHAN;
            }
        }
        ,
        LESSTHANOREQUAL("<="){

            @Override
            boolean compatibleWith(VersionComparison v) {
                return v != GREATERTHAN && v != GREATERTHANOREQUAL;
            }
        };

        private final String m_stringVal;

        private VersionComparison(String name) {
            this.m_stringVal = name;
        }

        abstract boolean compatibleWith(VersionComparison var1);

        public String toString() {
            return this.m_stringVal;
        }
    }
}

