/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.extension.listener;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.powermock.api.easymock.PowerMock;
import org.powermock.api.easymock.annotation.MockNice;
import org.powermock.api.easymock.annotation.MockStrict;
import org.powermock.core.classloader.annotations.Mock;
import org.powermock.core.spi.listener.AnnotationEnablerListener;
import org.powermock.core.spi.support.AbstractPowerMockTestListenerBase;
import org.powermock.reflect.Whitebox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationEnabler
extends AbstractPowerMockTestListenerBase
implements AnnotationEnablerListener {
    public void beforeTestMethod(Object testInstance, Method method, Object[] arguments) throws Exception {
        this.injectDefaultMocks(testInstance);
        this.injectNiceMocks(testInstance);
        this.injectStrictMocks(testInstance);
    }

    protected void injectStrictMocks(Object testInstance) throws Exception {
        FieldInjector fieldInjector = new FieldInjector(){

            @Override
            public Object createMockInstance(Class<?> type, Method[] methods) {
                return PowerMock.createStrictMock(type, methods);
            }
        };
        fieldInjector.inject(testInstance, MockStrict.class);
    }

    protected void injectNiceMocks(Object testInstance) throws Exception {
        FieldInjector fieldInjector = new FieldInjector(){

            @Override
            public Object createMockInstance(Class<?> type, Method[] methods) {
                return PowerMock.createNiceMock(type, methods);
            }
        };
        fieldInjector.inject(testInstance, MockNice.class);
    }

    protected void injectDefaultMocks(Object testInstance) throws Exception {
        FieldInjector fieldInjector = new FieldInjector(){

            @Override
            public Object createMockInstance(Class<?> type, Method[] methods) {
                return PowerMock.createMock(type, methods);
            }
        };
        fieldInjector.inject(testInstance, org.powermock.api.easymock.annotation.Mock.class);
        fieldInjector.inject(testInstance, Mock.class);
    }

    public Class<? extends Annotation>[] getMockAnnotations() {
        return new Class[]{org.powermock.api.easymock.annotation.Mock.class, Mock.class, MockNice.class, MockStrict.class};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class FieldInjector {
        protected FieldInjector() {
        }

        public void inject(Object testInstance, Class<? extends Annotation> annotation) throws Exception {
            Set fields = Whitebox.getFieldsAnnotatedWith((Object)testInstance, annotation, (Class[])new Class[0]);
            for (Field field : fields) {
                if (field.get(testInstance) != null) continue;
                Class<?> type = field.getType();
                Annotation annotationInstance = field.getAnnotation(annotation);
                String[] value = (String[])Whitebox.invokeMethod((Object)annotationInstance, (String)"value", (Object[])new Object[0]);
                Method[] methods = null;
                if (value.length != 1 || !"".equals(value[0])) {
                    methods = Whitebox.getMethods(type, (String[])value);
                }
                Object createMock = this.createMockInstance(type, methods);
                field.set(testInstance, createMock);
            }
        }

        public abstract Object createMockInstance(Class<?> var1, Method[] var2);
    }
}

