/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.impl.dv.xs;

import org.python.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.python.apache.xerces.impl.dv.ValidationContext;
import org.python.apache.xerces.impl.dv.xs.DoubleDV;
import org.python.apache.xerces.impl.dv.xs.TypeValidator;
import org.python.apache.xerces.xs.datatypes.XSFloat;

public class FloatDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 2552;
    }

    public Object getActualValue(String string2, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return new XFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string2, "float"});
        }
    }

    public int compare(Object object, Object object2) {
        return ((XFloat)object).compareTo((XFloat)object2);
    }

    public boolean isIdentical(Object object, Object object2) {
        if (object2 instanceof XFloat) {
            return ((XFloat)object).isIdentical((XFloat)object2);
        }
        return false;
    }

    private static final class XFloat
    implements XSFloat {
        private final float value;
        private String canonical;

        public XFloat(String string2) throws NumberFormatException {
            if (DoubleDV.isPossibleFP(string2)) {
                this.value = Float.parseFloat(string2);
            } else if (string2.equals("INF")) {
                this.value = Float.POSITIVE_INFINITY;
            } else if (string2.equals("-INF")) {
                this.value = Float.NEGATIVE_INFINITY;
            } else if (string2.equals("NaN")) {
                this.value = Float.NaN;
            } else {
                throw new NumberFormatException(string2);
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof XFloat)) {
                return false;
            }
            XFloat xFloat = (XFloat)object;
            if (this.value == xFloat.value) {
                return true;
            }
            return this.value != this.value && xFloat.value != xFloat.value;
        }

        public int hashCode() {
            return this.value == 0.0f ? 0 : Float.floatToIntBits(this.value);
        }

        public boolean isIdentical(XFloat xFloat) {
            if (xFloat == this) {
                return true;
            }
            if (this.value == xFloat.value) {
                return this.value != 0.0f || Float.floatToIntBits(this.value) == Float.floatToIntBits(xFloat.value);
            }
            return this.value != this.value && xFloat.value != xFloat.value;
        }

        private int compareTo(XFloat xFloat) {
            float f = xFloat.value;
            if (this.value < f) {
                return -1;
            }
            if (this.value > f) {
                return 1;
            }
            if (this.value == f) {
                return 0;
            }
            if (this.value != this.value) {
                if (f != f) {
                    return 0;
                }
                return 2;
            }
            return 2;
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                if (this.value == Float.POSITIVE_INFINITY) {
                    this.canonical = "INF";
                } else if (this.value == Float.NEGATIVE_INFINITY) {
                    this.canonical = "-INF";
                } else if (this.value != this.value) {
                    this.canonical = "NaN";
                } else if (this.value == 0.0f) {
                    this.canonical = "0.0E1";
                } else {
                    this.canonical = Float.toString(this.value);
                    if (this.canonical.indexOf(69) == -1) {
                        int n;
                        int n2 = this.canonical.length();
                        char[] cArray = new char[n2 + 3];
                        this.canonical.getChars(0, n2, cArray, 0);
                        int n3 = n = cArray[0] == '-' ? 2 : 1;
                        if (this.value >= 1.0f || this.value <= -1.0f) {
                            int n4;
                            int n5 = n4 = this.canonical.indexOf(46);
                            while (n5 > n) {
                                cArray[n5] = cArray[n5 - 1];
                                --n5;
                            }
                            cArray[n] = 46;
                            while (cArray[n2 - 1] == '0') {
                                --n2;
                            }
                            if (cArray[n2 - 1] == '.') {
                                // empty if block
                            }
                            int n6 = ++n2;
                            cArray[n6] = 69;
                            int n7 = n4 - n;
                            int n8 = ++n2;
                            ++n2;
                            cArray[n8] = (char)(n7 + 48);
                        } else {
                            int n9 = n + 1;
                            while (cArray[n9] == '0') {
                                ++n9;
                            }
                            cArray[n - 1] = cArray[n9];
                            cArray[n] = 46;
                            int n10 = n9 + 1;
                            int n11 = n + 1;
                            while (n10 < n2) {
                                cArray[n11] = cArray[n10];
                                ++n10;
                                ++n11;
                            }
                            if ((n2 -= n9 - n) == n + 1) {
                                cArray[n2++] = 48;
                            }
                            cArray[n2++] = 69;
                            cArray[n2++] = 45;
                            int n12 = n9 - n;
                            cArray[n2++] = (char)(n12 + 48);
                        }
                        this.canonical = new String(cArray, 0, n2);
                    }
                }
            }
            return this.canonical;
        }

        public float getValue() {
            return this.value;
        }
    }
}

