/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.ReflectedCallData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectedArgs {
    public Class<?>[] args;
    public Object data;
    public Class<?> declaringClass;
    public boolean isStatic;
    public int flags;
    public static final int StandardCall = 0;
    public static final int PyArgsCall = 1;
    public static final int PyArgsKeywordsCall = 2;
    public static final int REPLACE = 1998;

    public ReflectedArgs(Object data, Class<?>[] args, Class<?> declaringClass, boolean isStatic) {
        this.data = data;
        this.args = args;
        this.declaringClass = declaringClass;
        this.isStatic = isStatic;
        this.flags = args.length == 1 && args[0] == PyObject[].class ? 1 : (args.length == 2 && args[0] == PyObject[].class && args[1] == String[].class ? 2 : 0);
    }

    public boolean matches(PyObject self, PyObject[] pyArgs, String[] keywords, ReflectedCallData callData) {
        Object tmp;
        if (this.flags != 2 && keywords != null && keywords.length != 0) {
            return false;
        }
        if (this.isStatic) {
            if (self != null) {
                self = null;
            }
        } else if (self == null) {
            if (pyArgs.length == 0) {
                return false;
            }
            self = pyArgs[0];
            PyObject[] newArgs = new PyObject[pyArgs.length - 1];
            System.arraycopy(pyArgs, 1, newArgs, 0, newArgs.length);
            pyArgs = newArgs;
        }
        if (this.flags == 2) {
            callData.setLength(2);
            callData.args[0] = pyArgs;
            callData.args[1] = keywords;
            callData.self = self;
            if (self != null && (tmp = self.__tojava__(this.declaringClass)) != Py.NoConversion) {
                callData.self = tmp;
            }
            return true;
        }
        if (this.flags == 1) {
            callData.setLength(1);
            callData.args[0] = pyArgs;
            callData.self = self;
            if (self != null && (tmp = self.__tojava__(this.declaringClass)) != Py.NoConversion) {
                callData.self = tmp;
            }
            return true;
        }
        int n = this.args.length;
        if (pyArgs.length != n) {
            return false;
        }
        callData.errArg = -1;
        if (self != null) {
            Object tmp2 = self.__tojava__(this.declaringClass);
            if (tmp2 == Py.NoConversion) {
                return false;
            }
            callData.self = tmp2;
        } else {
            callData.self = null;
        }
        callData.setLength(n);
        Object[] javaArgs = callData.args;
        for (int i = 0; i < n; ++i) {
            javaArgs[i] = pyArgs[i].__tojava__(this.args[i]);
            if (javaArgs[i] != Py.NoConversion) continue;
            if (i > callData.errArg) {
                callData.errArg = i;
            }
            return false;
        }
        return true;
    }

    public static int precedence(Class<?> arg) {
        if (arg == Object.class) {
            return 3000;
        }
        if (arg.isPrimitive()) {
            if (arg == Long.TYPE) {
                return 10;
            }
            if (arg == Integer.TYPE) {
                return 11;
            }
            if (arg == Short.TYPE) {
                return 12;
            }
            if (arg == Character.TYPE) {
                return 13;
            }
            if (arg == Byte.TYPE) {
                return 14;
            }
            if (arg == Double.TYPE) {
                return 20;
            }
            if (arg == Float.TYPE) {
                return 21;
            }
            if (arg == Boolean.TYPE) {
                return 30;
            }
        }
        if (arg == String.class) {
            return 40;
        }
        if (arg.isArray()) {
            Class<?> componentType = arg.getComponentType();
            if (componentType == Object.class) {
                return 2500;
            }
            return 100 + ReflectedArgs.precedence(componentType);
        }
        return 2000;
    }

    public static int compare(Class<?> arg1, Class<?> arg2) {
        int p1 = ReflectedArgs.precedence(arg1);
        int p2 = ReflectedArgs.precedence(arg2);
        if (p1 >= 2000 && p2 >= 2000) {
            if (arg1.isAssignableFrom(arg2)) {
                if (arg2.isAssignableFrom(arg1)) {
                    return 0;
                }
                return 2;
            }
            if (arg2.isAssignableFrom(arg1)) {
                return -2;
            }
            int cmp = arg1.getName().compareTo(arg2.getName());
            return cmp > 0 ? 1 : -1;
        }
        return p1 > p2 ? 2 : (p1 == p2 ? 0 : -2);
    }

    public int compareTo(ReflectedArgs other) {
        Class<?>[] oargs = other.args;
        if (other.flags != this.flags) {
            return other.flags < this.flags ? -1 : 1;
        }
        int n = this.args.length;
        if (n < oargs.length) {
            return -1;
        }
        if (n > oargs.length) {
            return 1;
        }
        if (this.isStatic && !other.isStatic) {
            return 1;
        }
        if (!this.isStatic && other.isStatic) {
            return -1;
        }
        int cmp = 0;
        for (int i = 0; i < n; ++i) {
            int tmp = ReflectedArgs.compare(this.args[i], oargs[i]);
            if (tmp == 2 || tmp == -2) {
                cmp = tmp;
            }
            if (cmp != 0) continue;
            cmp = tmp;
        }
        if (cmp != 0) {
            return cmp > 0 ? 1 : -1;
        }
        boolean replace = other.declaringClass.isAssignableFrom(this.declaringClass);
        if (!this.isStatic) {
            replace = !replace;
        }
        return replace ? 1998 : 0;
    }

    public String toString() {
        String s = this.declaringClass + ", " + this.isStatic + ", " + this.flags + ", " + this.data + "\n";
        s = s + "\t(";
        for (Class<?> arg : this.args) {
            s = s + arg.getName() + ", ";
        }
        s = s + ")";
        return s;
    }
}

