/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

public enum CompressionType {
    BZIP2("bzip2", ".bz2"),
    GZIP("gz", ".gz"),
    PACK200("pack200", ".pack");

    private final String name;
    private final String defaultFileExtension;

    private CompressionType(String name, String defaultFileExtension) {
        this.name = name;
        this.defaultFileExtension = defaultFileExtension;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultFileExtension() {
        return this.defaultFileExtension;
    }

    public static boolean isValidCompressionType(String compression) {
        for (CompressionType type : CompressionType.values()) {
            if (!compression.equalsIgnoreCase(type.getName())) continue;
            return true;
        }
        return false;
    }

    public static CompressionType fromString(String compression) {
        for (CompressionType type : CompressionType.values()) {
            if (!compression.equalsIgnoreCase(type.getName())) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown compression type " + compression);
    }
}

