/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.compressors.CompressorException;
import org.rauschig.jarchivelib.ArchiveStream;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.CommonsArchiveStream;
import org.rauschig.jarchivelib.CommonsArchiver;
import org.rauschig.jarchivelib.CommonsCompressor;
import org.rauschig.jarchivelib.CommonsStreamFactory;
import org.rauschig.jarchivelib.IOUtils;

class ArchiverCompressorDecorator
implements Archiver {
    private CommonsArchiver archiver;
    private CommonsCompressor compressor;

    ArchiverCompressorDecorator(CommonsArchiver archiver, CommonsCompressor compressor) {
        this.archiver = archiver;
        this.compressor = compressor;
    }

    @Override
    public File create(String archive, File destination, File source) throws IOException {
        return this.create(archive, destination, IOUtils.filesContainedIn(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File create(String archive, File destination, File ... sources) throws IOException {
        IOUtils.requireDirectory(destination);
        File temp = File.createTempFile(destination.getName(), this.archiver.getFilenameExtension(), destination);
        File destinationArchive = null;
        try {
            temp = this.archiver.create(temp.getName(), temp.getParentFile(), sources);
            destinationArchive = new File(destination, this.getArchiveFileName(archive));
            this.compressor.compress(temp, destinationArchive);
        }
        finally {
            temp.delete();
        }
        return destinationArchive;
    }

    @Override
    public void extract(File archive, File destination) throws IOException {
        IOUtils.requireDirectory(destination);
        if (!archive.exists()) {
            throw new FileNotFoundException(String.format("Archive %s does not exist.", archive.getAbsolutePath()));
        }
        BufferedInputStream archiveStream = null;
        try {
            archiveStream = new BufferedInputStream(new FileInputStream(archive));
            this.archiver.extract(this.compressor.decompressingStream(archiveStream), destination);
        }
        catch (FileNotFoundException e) {
            try {
                throw new IllegalArgumentException(String.format("Access control or other error opening %s", archive.getAbsolutePath()), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(archiveStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(archiveStream);
    }

    @Override
    public void extract(InputStream archive, File destination) throws IOException {
        IOUtils.requireDirectory(destination);
        this.archiver.extract(this.compressor.decompressingStream(archive), destination);
    }

    @Override
    public ArchiveStream stream(File archive) throws IOException {
        try {
            return new CommonsArchiveStream(CommonsStreamFactory.createArchiveInputStream(this.archiver, (InputStream)CommonsStreamFactory.createCompressorInputStream(archive)));
        }
        catch (ArchiveException e) {
            throw new IOException(e);
        }
        catch (CompressorException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getFilenameExtension() {
        return this.archiver.getFilenameExtension() + this.compressor.getFilenameExtension();
    }

    private String getArchiveFileName(String archive) {
        String fileExtension = this.getFilenameExtension();
        if (archive.endsWith(fileExtension)) {
            return archive;
        }
        if (archive.endsWith(this.archiver.getFilenameExtension())) {
            return archive + this.compressor.getFilenameExtension();
        }
        return archive + fileExtension;
    }
}

