/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.cran.Matrix;

import java.lang.invoke.MethodHandle;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.MixedPtr;
import org.renjin.gcc.runtime.Ptr;

public class SuiteSparse_config__ {
    private SuiteSparse_config__() {
    }

    public static int SuiteSparse_version(Ptr version) {
        if (!version.isNull()) {
            version.setInt(4);
            version.setInt(4, 2);
            version.setInt(8, 1);
        }
        return 4002;
    }

    public static double SuiteSparse_time() {
        double[] toc = new double[2];
        SuiteSparse_config__.SuiteSparse_tic((Ptr)new DoublePtr(toc, 0));
        double d = toc[0];
        double d2 = toc[1] * 1.0E-9;
        return d + d2;
    }

    public static double SuiteSparse_toc(Ptr tic) {
        double[] toc = new double[2];
        SuiteSparse_config__.SuiteSparse_tic((Ptr)new DoublePtr(toc, 0));
        double d = toc[0];
        double d2 = tic.getDouble();
        double d3 = d - d2;
        double d4 = toc[1];
        double d5 = tic.getDouble(8);
        double d6 = (d4 - d5) * 1.0E-9;
        return d3 + d6;
    }

    public static void SuiteSparse_tic(Ptr tic) {
        tic.setDouble(0.0);
        tic.setDouble(8, 0.0);
    }

    public static Ptr SuiteSparse_free(Ptr p, Ptr config) {
        if (!p.isNull() && !config.isNull() && config.getAlignedPointer(2).toMethodHandle() != null) {
            config.getAlignedPointer(2).toMethodHandle().invoke(p);
        }
        return BytePtr.of((int)0);
    }

    public static Ptr SuiteSparse_malloc(int nitems, int size_of_item, Ptr ok, Ptr config) {
        int n;
        Ptr ptr;
        if (nitems == 0) {
            nitems = 1;
        }
        double d = Integer.toUnsignedLong(nitems * size_of_item);
        double d2 = Integer.toUnsignedLong(nitems);
        double d3 = Integer.toUnsignedLong(size_of_item);
        double d4 = d2 * d3;
        if (d != d4) {
            ok.setInt(0);
            ptr = BytePtr.of((int)0);
            n = 0;
        } else {
            int p$offset;
            MixedPtr p;
            if (config.isNull() || config.getPointer().toMethodHandle() == null) {
                p = MixedPtr.malloc((int)(nitems * size_of_item));
                p$offset = 0;
            } else {
                MethodHandle methodHandle = config.getPointer().toMethodHandle();
                int n2 = nitems * size_of_item;
                p = methodHandle.invoke(n2);
                p$offset = 0;
            }
            int n3 = p.pointerPlus(p$offset).isNull() ? 0 : 1;
            ok.setInt(n3);
            ptr = p;
            n = p$offset;
        }
        return ptr.pointerPlus(n);
    }
}

