/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.cran.Matrix;

import java.lang.invoke.MethodHandle;
import org.renjin.cran.Matrix.cholmod_common__;
import org.renjin.cran.Matrix.cholmod_error__;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;

public class cholmod_norm__ {
    private cholmod_norm__() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double cholmod_norm_sparse(Ptr A, int norm, Ptr Common) {
        double s;
        int i;
        int p;
        int xtype = 0;
        int packed = 0;
        int ncol = 0;
        int nrow = 0;
        int pend = 0;
        int j = 0;
        Ptr Anz = BytePtr.of((int)0);
        int Anz$offset = 0;
        Ptr Ai = BytePtr.of((int)0);
        int Ai$offset = 0;
        Ptr Ap = BytePtr.of((int)0);
        int Ap$offset = 0;
        Ptr W = BytePtr.of((int)0);
        int W$offset = 0;
        Ptr Az = BytePtr.of((int)0);
        int Az$offset = 0;
        Ptr Ax = BytePtr.of((int)0);
        int Ax$offset = 0;
        double anorm = 0.0;
        if (Common.isNull()) return -1.0;
        if (Common.getAlignedInt(388) != 0 || Common.getAlignedInt(389) != 0) {
            Common.setAlignedInt(391, -4);
            return -1.0;
        }
        if (A.isNull()) {
            if (Common.getAlignedInt(391) == -2) return -1.0;
            cholmod_error__.cholmod_error(-4, (Ptr)new BytePtr("../MatrixOps/cholmod_norm.c\u0000".getBytes(), 0), 270, (Ptr)new BytePtr("argument missing\u0000".getBytes(), 0), Common);
            return -1.0;
        }
        if (A.getAlignedInt(10) < 0 || A.getAlignedInt(10) > 3 || A.getAlignedInt(10) != 0 && A.getAlignedPointer(6).isNull() || A.getAlignedInt(10) == 3 && A.getAlignedPointer(7).isNull()) {
            if (Common.getAlignedInt(391) == -2) return -1.0;
            cholmod_error__.cholmod_error(-4, (Ptr)new BytePtr("../MatrixOps/cholmod_norm.c\u0000".getBytes(), 0), 271, (Ptr)new BytePtr("invalid xtype\u0000".getBytes(), 0), Common);
            return -1.0;
        }
        Common.setAlignedInt(391, 0);
        ncol = A.getAlignedInt(1);
        nrow = A.getInt();
        if (norm < 0 || norm > 1) {
            cholmod_error__.cholmod_error(-4, (Ptr)new BytePtr("../MatrixOps/cholmod_norm.c\u0000".getBytes(), 0), 277, (Ptr)new BytePtr("invalid norm\u0000".getBytes(), 0), Common);
            return -1.0;
        }
        if (A.getAlignedInt(8) != 0 && nrow != ncol) {
            cholmod_error__.cholmod_error(-4, (Ptr)new BytePtr("../MatrixOps/cholmod_norm.c\u0000".getBytes(), 0), 282, (Ptr)new BytePtr("matrix invalid\u0000".getBytes(), 0), Common);
            return -1.0;
        }
        Ap = A.getAlignedPointer(3);
        Ap$offset = 0;
        Ai = A.getAlignedPointer(4);
        Ai$offset = 0;
        Ax = A.getAlignedPointer(6);
        Ax$offset = 0;
        Az = A.getAlignedPointer(7);
        Az$offset = 0;
        Anz = A.getAlignedPointer(5);
        Anz$offset = 0;
        packed = A.getAlignedInt(13);
        xtype = A.getAlignedInt(10);
        W = BytePtr.of((int)0);
        W$offset = 0;
        if (A.getAlignedInt(8) != 0 || norm == 0) {
            int nrow$0 = nrow;
            cholmod_common__.cholmod_allocate_work(0, 0, nrow$0, Common);
            W = Common.getAlignedPointer(386);
            W$offset = 0;
            if (Common.getAlignedInt(391) < 0) return -1.0;
        }
        anorm = 0.0;
        if (A.getAlignedInt(8) > 0) {
            j = 0;
            while (j < ncol) {
                int iftmp$2;
                int n = j * 4;
                Ptr ptr = Ap;
                int n2 = Ap$offset + n;
                p = ptr.getInt(n2);
                if (packed != 0) {
                    int n3 = (j + 1) * 4;
                    Ptr ptr2 = Ap;
                    int n4 = Ap$offset + n3;
                    iftmp$2 = ptr2.getInt(n4);
                } else {
                    int n5 = j * 4;
                    Ptr ptr3 = Anz;
                    int n6 = Anz$offset + n5;
                    iftmp$2 = ptr3.getInt(n6) + p;
                }
                pend = iftmp$2;
                while (p < pend) {
                    int n7 = p * 4;
                    Ptr ptr4 = Ai;
                    int n8 = Ai$offset + n7;
                    i = ptr4.getInt(n8);
                    s = cholmod_norm__.abs_value(xtype, Ax.pointerPlus(Ax$offset), Az.pointerPlus(Az$offset), p, Common);
                    if (i == j) {
                        int n9 = i * 8;
                        Ptr ptr5 = W;
                        int n10 = W$offset + n9;
                        int n11 = i * 8;
                        Ptr ptr6 = W;
                        int n12 = W$offset + n11;
                        double d = ptr6.getDouble(n12) + s;
                        ptr5.setDouble(n10, d);
                    } else if (i < j) {
                        int n13 = i * 8;
                        Ptr ptr7 = W;
                        int n14 = W$offset + n13;
                        int n15 = i * 8;
                        Ptr ptr8 = W;
                        int n16 = W$offset + n15;
                        double d = ptr8.getDouble(n16) + s;
                        ptr7.setDouble(n14, d);
                        int n17 = j * 8;
                        Ptr ptr9 = W;
                        int n18 = W$offset + n17;
                        int n19 = j * 8;
                        Ptr ptr10 = W;
                        int n20 = W$offset + n19;
                        double d2 = ptr10.getDouble(n20) + s;
                        ptr9.setDouble(n18, d2);
                    }
                    ++p;
                }
                ++j;
            }
        } else if (A.getAlignedInt(8) < 0) {
            j = 0;
            while (j < ncol) {
                int iftmp$13;
                int n = j * 4;
                Ptr ptr = Ap;
                int n21 = Ap$offset + n;
                p = ptr.getInt(n21);
                if (packed != 0) {
                    int n22 = (j + 1) * 4;
                    Ptr ptr11 = Ap;
                    int n23 = Ap$offset + n22;
                    iftmp$13 = ptr11.getInt(n23);
                } else {
                    int n24 = j * 4;
                    Ptr ptr12 = Anz;
                    int n25 = Anz$offset + n24;
                    iftmp$13 = ptr12.getInt(n25) + p;
                }
                pend = iftmp$13;
                while (p < pend) {
                    int n26 = p * 4;
                    Ptr ptr13 = Ai;
                    int n27 = Ai$offset + n26;
                    i = ptr13.getInt(n27);
                    s = cholmod_norm__.abs_value(xtype, Ax.pointerPlus(Ax$offset), Az.pointerPlus(Az$offset), p, Common);
                    if (i == j) {
                        int n28 = i * 8;
                        Ptr ptr14 = W;
                        int n29 = W$offset + n28;
                        int n30 = i * 8;
                        Ptr ptr15 = W;
                        int n31 = W$offset + n30;
                        double d = ptr15.getDouble(n31) + s;
                        ptr14.setDouble(n29, d);
                    } else if (i > j) {
                        int n32 = i * 8;
                        Ptr ptr16 = W;
                        int n33 = W$offset + n32;
                        int n34 = i * 8;
                        Ptr ptr17 = W;
                        int n35 = W$offset + n34;
                        double d = ptr17.getDouble(n35) + s;
                        ptr16.setDouble(n33, d);
                        int n36 = j * 8;
                        Ptr ptr18 = W;
                        int n37 = W$offset + n36;
                        int n38 = j * 8;
                        Ptr ptr19 = W;
                        int n39 = W$offset + n38;
                        double d3 = ptr19.getDouble(n39) + s;
                        ptr18.setDouble(n37, d3);
                    }
                    ++p;
                }
                ++j;
            }
        } else if (norm == 0) {
            j = 0;
            while (j < ncol) {
                int iftmp$24;
                int n = j * 4;
                Ptr ptr = Ap;
                int n40 = Ap$offset + n;
                p = ptr.getInt(n40);
                if (packed != 0) {
                    int n41 = (j + 1) * 4;
                    Ptr ptr20 = Ap;
                    int n42 = Ap$offset + n41;
                    iftmp$24 = ptr20.getInt(n42);
                } else {
                    int n43 = j * 4;
                    Ptr ptr21 = Anz;
                    int n44 = Anz$offset + n43;
                    iftmp$24 = ptr21.getInt(n44) + p;
                }
                pend = iftmp$24;
                while (p < pend) {
                    int n45 = p * 4;
                    Ptr ptr22 = Ai;
                    int n46 = Ai$offset + n45;
                    int n47 = ptr22.getInt(n46) * 8;
                    Ptr ptr23 = W;
                    int n48 = W$offset + n47;
                    int n49 = p * 4;
                    Ptr ptr24 = Ai;
                    int n50 = Ai$offset + n49;
                    int n51 = ptr24.getInt(n50) * 8;
                    Ptr ptr25 = W;
                    int n52 = W$offset + n51;
                    double d = ptr25.getDouble(n52);
                    double d4 = cholmod_norm__.abs_value(xtype, Ax.pointerPlus(Ax$offset), Az.pointerPlus(Az$offset), p, Common);
                    double d5 = d + d4;
                    ptr23.setDouble(n48, d5);
                    ++p;
                }
                ++j;
            }
        } else {
            j = 0;
            while (j < ncol) {
                int iftmp$30;
                int n = j * 4;
                Ptr ptr = Ap;
                int n53 = Ap$offset + n;
                p = ptr.getInt(n53);
                if (packed != 0) {
                    int n54 = (j + 1) * 4;
                    Ptr ptr26 = Ap;
                    int n55 = Ap$offset + n54;
                    iftmp$30 = ptr26.getInt(n55);
                } else {
                    int n56 = j * 4;
                    Ptr ptr27 = Anz;
                    int n57 = Anz$offset + n56;
                    iftmp$30 = ptr27.getInt(n57) + p;
                }
                pend = iftmp$30;
                if (xtype == 0) {
                    s = pend - p;
                } else {
                    s = 0.0;
                    while (p < pend) {
                        s = cholmod_norm__.abs_value(xtype, Ax.pointerPlus(Ax$offset), Az.pointerPlus(Az$offset), p, Common) + s;
                        ++p;
                    }
                }
                double d = s;
                if (d != d || s > anorm) {
                    double d6 = anorm;
                    if (d6 == d6) {
                        anorm = s;
                    }
                }
                ++j;
            }
        }
        if (A.getAlignedInt(8) == 0 && norm != 0) return anorm;
        i = 0;
        while (i < nrow) {
            int n = i * 8;
            Ptr ptr = W;
            int n58 = W$offset + n;
            double d = s = ptr.getDouble(n58);
            if (d != d || s > anorm) {
                double d7 = anorm;
                if (d7 == d7) {
                    anorm = s;
                }
            }
            int n59 = i * 8;
            Ptr ptr28 = W;
            int n60 = W$offset + n59;
            ptr28.setDouble(n60, 0.0);
            ++i;
        }
        return anorm;
    }

    public static double cholmod_norm_dense(Ptr X, int norm, Ptr Common) {
        double d;
        int xtype = 0;
        int j = 0;
        int i = 0;
        int d2 = 0;
        int ncol = 0;
        int nrow = 0;
        Ptr W = BytePtr.of((int)0);
        int W$offset = 0;
        Ptr Xz = BytePtr.of((int)0);
        int Xz$offset = 0;
        Ptr Xx = BytePtr.of((int)0);
        int Xx$offset = 0;
        double xnorm = 0.0;
        if (Common.isNull()) {
            d = -1.0;
        } else if (Common.getAlignedInt(388) != 0 || Common.getAlignedInt(389) != 0) {
            Common.setAlignedInt(391, -4);
            d = -1.0;
        } else if (X.isNull()) {
            if (Common.getAlignedInt(391) != -2) {
                cholmod_error__.cholmod_error(-4, (Ptr)new BytePtr("../MatrixOps/cholmod_norm.c\u0000".getBytes(), 0), 86, (Ptr)new BytePtr("argument missing\u0000".getBytes(), 0), Common);
            }
            d = -1.0;
        } else if (X.getAlignedInt(6) <= 0 || X.getAlignedInt(6) > 3 || X.getAlignedInt(6) != 0 && X.getAlignedPointer(4).isNull() || X.getAlignedInt(6) == 3 && X.getAlignedPointer(5).isNull()) {
            if (Common.getAlignedInt(391) != -2) {
                cholmod_error__.cholmod_error(-4, (Ptr)new BytePtr("../MatrixOps/cholmod_norm.c\u0000".getBytes(), 0), 87, (Ptr)new BytePtr("invalid xtype\u0000".getBytes(), 0), Common);
            }
            d = -1.0;
        } else {
            Common.setAlignedInt(391, 0);
            ncol = X.getAlignedInt(1);
            if (norm < 0 || norm > 2 || norm == 2 && ncol > 1) {
                cholmod_error__.cholmod_error(-4, (Ptr)new BytePtr("../MatrixOps/cholmod_norm.c\u0000".getBytes(), 0), 92, (Ptr)new BytePtr("invalid norm\u0000".getBytes(), 0), Common);
                d = -1.0;
            } else {
                nrow = X.getInt();
                d2 = X.getAlignedInt(3);
                Xx = X.getAlignedPointer(4);
                Xx$offset = 0;
                Xz = X.getAlignedPointer(5);
                Xz$offset = 0;
                xtype = X.getAlignedInt(6);
                W = BytePtr.of((int)0);
                W$offset = 0;
                boolean iftmp$35 = norm == 0 && ncol > 4;
                boolean use_workspace = iftmp$35;
                if (use_workspace) {
                    int nrow$36 = nrow;
                    cholmod_common__.cholmod_allocate_work(0, 0, nrow$36, Common);
                    W = Common.getAlignedPointer(386);
                    W$offset = 0;
                    if (Common.getAlignedInt(391) < 0) {
                        use_workspace = false;
                    }
                }
                xnorm = 0.0;
                if (use_workspace) {
                    j = 0;
                    while (j < ncol) {
                        i = 0;
                        while (i < nrow) {
                            int n = i * 8;
                            Ptr ptr = W;
                            int n2 = W$offset + n;
                            int n3 = i * 8;
                            Ptr ptr2 = W;
                            int n4 = W$offset + n3;
                            double d3 = ptr2.getDouble(n4);
                            int n5 = j * d2 + i;
                            double d4 = cholmod_norm__.abs_value(xtype, Xx.pointerPlus(Xx$offset), Xz.pointerPlus(Xz$offset), n5, Common);
                            double d5 = d3 + d4;
                            ptr.setDouble(n2, d5);
                            ++i;
                        }
                        ++j;
                    }
                    i = 0;
                    while (i < nrow) {
                        double s;
                        int n = i * 8;
                        Ptr ptr = W;
                        int n6 = W$offset + n;
                        double d6 = s = ptr.getDouble(n6);
                        if (d6 != d6 || s > xnorm) {
                            double d7 = xnorm;
                            if (d7 == d7) {
                                xnorm = s;
                            }
                        }
                        int n7 = i * 8;
                        Ptr ptr3 = W;
                        int n8 = W$offset + n7;
                        ptr3.setDouble(n8, 0.0);
                        ++i;
                    }
                } else if (norm == 0) {
                    i = 0;
                    while (i < nrow) {
                        double s = 0.0;
                        j = 0;
                        while (j < ncol) {
                            int n = j * d2 + i;
                            s = cholmod_norm__.abs_value(xtype, Xx.pointerPlus(Xx$offset), Xz.pointerPlus(Xz$offset), n, Common) + s;
                            ++j;
                        }
                        double d8 = s;
                        if (d8 != d8 || s > xnorm) {
                            double d9 = xnorm;
                            if (d9 == d9) {
                                xnorm = s;
                            }
                        }
                        ++i;
                    }
                } else if (norm == 1) {
                    j = 0;
                    while (j < ncol) {
                        double s = 0.0;
                        i = 0;
                        while (i < nrow) {
                            int n = j * d2 + i;
                            s = cholmod_norm__.abs_value(xtype, Xx.pointerPlus(Xx$offset), Xz.pointerPlus(Xz$offset), n, Common) + s;
                            ++i;
                        }
                        double d10 = s;
                        if (d10 != d10 || s > xnorm) {
                            double d11 = xnorm;
                            if (d11 == d11) {
                                xnorm = s;
                            }
                        }
                        ++j;
                    }
                } else {
                    switch (xtype) {
                        case 1: {
                            i = 0;
                            while (i < nrow) {
                                double x;
                                int n = i * 8;
                                Ptr ptr = Xx;
                                int n9 = Xx$offset + n;
                                double d12 = x = ptr.getDouble(n9);
                                xnorm = d12 * d12 + xnorm;
                                ++i;
                            }
                            break;
                        }
                        case 2: {
                            i = 0;
                            while (i < nrow) {
                                int n = i * 16;
                                Ptr ptr = Xx;
                                int n10 = Xx$offset + n;
                                double x = ptr.getDouble(n10);
                                int n11 = i * 16 + 8;
                                Ptr ptr4 = Xx;
                                int n12 = Xx$offset + n11;
                                double z = ptr4.getDouble(n12);
                                double d13 = x;
                                double d14 = d13 * d13;
                                double d15 = z;
                                double d16 = d15 * d15;
                                xnorm = d14 + d16 + xnorm;
                                ++i;
                            }
                            break;
                        }
                        case 3: {
                            i = 0;
                            while (i < nrow) {
                                int n = i * 8;
                                Ptr ptr = Xx;
                                int n13 = Xx$offset + n;
                                double x = ptr.getDouble(n13);
                                int n14 = i * 8;
                                Ptr ptr5 = Xz;
                                int n15 = Xz$offset + n14;
                                double z = ptr5.getDouble(n15);
                                double d17 = x;
                                double d18 = d17 * d17;
                                double d19 = z;
                                double d20 = d19 * d19;
                                xnorm = d18 + d20 + xnorm;
                                ++i;
                            }
                            break;
                        }
                    }
                    xnorm = Mathlib.sqrt((double)xnorm);
                }
                d = xnorm;
            }
        }
        return d;
    }

    public static double abs_value(int xtype, Ptr Ax, Ptr Az, int p, Ptr Common) {
        double s = 0.0;
        switch (xtype) {
            case 0: {
                s = 1.0;
                break;
            }
            case 1: {
                int n = p * 8;
                Ptr ptr = Ax;
                int n2 = n;
                s = Math.abs(ptr.getDouble(n2));
                break;
            }
            case 2: {
                MethodHandle methodHandle = Common.getAlignedPointer(373).toMethodHandle();
                int n = p * 16 + 8;
                Ptr ptr = Ax;
                int n3 = n;
                double d = ptr.getDouble(n3);
                int n4 = p * 16;
                Ptr ptr2 = Ax;
                int n5 = n4;
                double d2 = ptr2.getDouble(n5);
                s = methodHandle.invoke(d2, d);
                break;
            }
            case 3: {
                MethodHandle methodHandle = Common.getAlignedPointer(373).toMethodHandle();
                int n = p * 8;
                Ptr ptr = Az;
                int n6 = n;
                double d = ptr.getDouble(n6);
                int n7 = p * 8;
                Ptr ptr3 = Ax;
                int n8 = n7;
                double d3 = ptr3.getDouble(n8);
                s = methodHandle.invoke(d3, d);
            }
        }
        return s;
    }
}

