/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.cran.digest;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.LongPtr;
import org.renjin.gcc.runtime.MixedPtr;
import org.renjin.gcc.runtime.Ptr;

public class sha2__ {
    public static Ptr sha2_hex_digits;
    public static long[] sha512_initial_hash_value;
    public static long[] K512;

    private sha2__() {
    }

    public static Ptr SHA512_Data(Ptr data, int len, Ptr digest2) {
        MixedPtr context = MixedPtr.malloc((int)208);
        sha2__.SHA512_Init((Ptr)context);
        sha2__.SHA512_Update((Ptr)context, data, len);
        return sha2__.SHA512_End((Ptr)context, digest2);
    }

    public static Ptr SHA512_End(Ptr context, Ptr buffer) {
        byte[] digest2 = new byte[64];
        BytePtr d = new BytePtr(digest2, 0);
        int d$offset = 0;
        if (!buffer.isNull()) {
            sha2__.SHA512_Final((Ptr)new BytePtr(digest2, 0), context);
            int i = 0;
            while (i <= 63) {
                Ptr sha2_hex_digits$0 = sha2_hex_digits;
                int n = (d.getByte(d$offset) & 0xFF) >> 4 & 0xFF;
                Ptr ptr = sha2_hex_digits$0;
                int n2 = 0 + n;
                byte by = ptr.getByte(n2);
                buffer.setByte(by);
                buffer = buffer.pointerPlus(1);
                Ptr sha2_hex_digits$1 = sha2_hex_digits;
                int n3 = d.getByte(d$offset) & 0xFF & 0xF;
                Ptr ptr2 = sha2_hex_digits$1;
                int n4 = 0 + n3;
                byte by2 = ptr2.getByte(n4);
                buffer.setByte(by2);
                buffer = buffer.pointerPlus(1);
                ++d$offset;
                ++i;
            }
            buffer.setByte((byte)0);
        } else {
            context.memset(0, 208);
        }
        BytePtr.memset((byte[])digest2, (int)0, (int)0, (int)64);
        return buffer;
    }

    public static void SHA512_Final(Ptr digest2, Ptr context) {
        Ptr d = digest2;
        int d$offset = 0;
        if (!digest2.isNull()) {
            sha2__.SHA512_Last(context);
            int j = 0;
            while (j <= 7) {
                long tmp = context.getAlignedLong(j);
                tmp = Long.rotateLeft(tmp, 32);
                long l = (tmp & 0xFF00FF00FF00FF00L) >>> 8;
                long l2 = (tmp & 0xFF00FF00FF00FFL) << 8;
                tmp = l | l2;
                long l3 = (tmp & 0xFFFF0000FFFF0000L) >>> 16;
                long l4 = (tmp & 0xFFFF0000FFFFL) << 16;
                long l5 = l3 | l4;
                context.setAlignedLong(j, l5);
                long l6 = context.getAlignedLong(j);
                d.setLong(d$offset, l6);
                d$offset += 8;
                ++j;
            }
        }
        context.memset(0, 208);
    }

    public static void SHA512_Last(Ptr context) {
        int usedspace = (int)(context.getAlignedLong(8) >>> 3) & 0x7F;
        long tmp = context.getAlignedLong(8);
        tmp = Long.rotateLeft(tmp, 32);
        long l = (tmp & 0xFF00FF00FF00FF00L) >>> 8;
        long l2 = (tmp & 0xFF00FF00FF00FFL) << 8;
        tmp = l | l2;
        long l3 = (tmp & 0xFFFF0000FFFF0000L) >>> 16;
        long l4 = (tmp & 0xFFFF0000FFFFL) << 16;
        long l5 = l3 | l4;
        context.setAlignedLong(8, l5);
        long tmp2 = context.getAlignedLong(9);
        tmp2 = Long.rotateLeft(tmp2, 32);
        long l6 = (tmp2 & 0xFF00FF00FF00FF00L) >>> 8;
        long l7 = (tmp2 & 0xFF00FF00FF00FFL) << 8;
        tmp2 = l6 | l7;
        long l8 = (tmp2 & 0xFFFF0000FFFF0000L) >>> 16;
        long l9 = (tmp2 & 0xFFFF0000FFFFL) << 16;
        long l10 = l8 | l9;
        context.setAlignedLong(9, l10);
        if (usedspace != 0) {
            context.setByte(80 + usedspace, (byte)128);
            if (Integer.compareUnsigned(++usedspace, 112) <= 0) {
                int n = 112 - usedspace;
                Ptr ptr = context;
                int n2 = 80 + usedspace;
                ptr.pointerPlus(n2).memset(0, n);
            } else {
                if (Integer.compareUnsigned(usedspace, 127) <= 0) {
                    int n = 128 - usedspace;
                    Ptr ptr = context;
                    int n3 = 80 + usedspace;
                    ptr.pointerPlus(n3).memset(0, n);
                }
                sha2__.SHA512_Transform(context);
                context.pointerPlus(80).memset(0, 126);
            }
        } else {
            context.pointerPlus(80).memset(0, 112);
            context.setByte(80, (byte)128);
        }
        Ptr ptr = context;
        context.pointerPlus(192).memcpy(ptr.pointerPlus(72), 8);
        Ptr ptr2 = context;
        context.pointerPlus(200).memcpy(ptr2.pointerPlus(64), 8);
        sha2__.SHA512_Transform(context);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public static void SHA512_Update(Ptr context, Ptr data, int len) {
        int freespace;
        if (len == 0) return;
        int usedspace = (int)(context.getAlignedLong(8) >>> 3) & 0x7F;
        boolean bl = true;
        do {
            block5: {
                block8: {
                    block7: {
                        block6: {
                            if (!bl || (bl = false)) break block5;
                            if (usedspace == 0) continue;
                            freespace = 128 - usedspace;
                            if (Integer.compareUnsigned(len, freespace) >= 0) break block6;
                            Ptr ptr = context;
                            int n = 80 + usedspace;
                            ptr.pointerPlus(n).memcpy(data, len);
                            long l = context.getAlignedLong(8);
                            long l2 = Integer.toUnsignedLong(len << 3);
                            long l3 = l + l2;
                            context.setAlignedLong(8, l3);
                            long l4 = context.getAlignedLong(8);
                            long l5 = Integer.toUnsignedLong(len << 3);
                            if (Long.compareUnsigned(l4, l5) < 0) break block7;
                            break block8;
                        }
                        Ptr ptr = context;
                        int n = 80 + usedspace;
                        ptr.pointerPlus(n).memcpy(data, freespace);
                        long l = context.getAlignedLong(8);
                        long l6 = Integer.toUnsignedLong(freespace << 3);
                        long l7 = l + l6;
                        context.setAlignedLong(8, l7);
                        long l8 = context.getAlignedLong(8);
                        long l9 = Integer.toUnsignedLong(freespace << 3);
                        if (Long.compareUnsigned(l8, l9) < 0) {
                            long l10 = context.getAlignedLong(9) + 1L;
                            context.setAlignedLong(9, l10);
                        }
                        len -= freespace;
                        data = data.pointerPlus(freespace);
                        sha2__.SHA512_Transform(context);
                        if (true) continue;
                    }
                    long l = context.getAlignedLong(9) + 1L;
                    context.setAlignedLong(9, l);
                }
                usedspace = freespace = 0;
                return;
            }
            context.pointerPlus(80).memcpy(data, 128);
            sha2__.SHA512_Transform(context);
            long l = context.getAlignedLong(8) + 1024L;
            context.setAlignedLong(8, l);
            if (Long.compareUnsigned(context.getAlignedLong(8), 1023L) <= 0) {
                long l11 = context.getAlignedLong(9) + 1L;
                context.setAlignedLong(9, l11);
            }
            len -= 128;
            data = data.pointerPlus(128);
        } while (Integer.compareUnsigned(len, 127) > 0);
        if (len != 0) {
            context.pointerPlus(80).memcpy(data, len);
            long l = context.getAlignedLong(8);
            long l12 = Integer.toUnsignedLong(len << 3);
            long l13 = l + l12;
            context.setAlignedLong(8, l13);
            long l14 = context.getAlignedLong(8);
            long l15 = Integer.toUnsignedLong(len << 3);
            if (Long.compareUnsigned(l14, l15) < 0) {
                long l16 = context.getAlignedLong(9) + 1L;
                context.setAlignedLong(9, l16);
            }
        }
        usedspace = freespace = 0;
    }

    public static void SHA512_Transform(Ptr context) {
        long T2;
        long T1;
        Ptr W512 = BytePtr.of((int)0);
        int W512$offset = 0;
        W512 = context;
        W512$offset = 80;
        long a = context.getLong();
        long b = context.getAlignedLong(1);
        long c = context.getAlignedLong(2);
        long d = context.getAlignedLong(3);
        long e = context.getAlignedLong(4);
        long f = context.getAlignedLong(5);
        long g = context.getAlignedLong(6);
        long h = context.getAlignedLong(7);
        int j = 0;
        do {
            int n = j * 8;
            Ptr ptr = W512;
            int n2 = W512$offset + n;
            long tmp = ptr.getLong(n2);
            tmp = Long.rotateLeft(tmp, 32);
            long l = (tmp & 0xFF00FF00FF00FF00L) >>> 8;
            long l2 = (tmp & 0xFF00FF00FF00FFL) << 8;
            tmp = l | l2;
            int n3 = j * 8;
            Ptr ptr2 = W512;
            int n4 = W512$offset + n3;
            long l3 = (tmp & 0xFFFF0000FFFF0000L) >>> 16;
            long l4 = (tmp & 0xFFFF0000FFFFL) << 16;
            long l5 = l3 | l4;
            ptr2.setLong(n4, l5);
            long l6 = Long.rotateLeft(e, 50);
            long l7 = Long.rotateLeft(e, 46);
            long l8 = l6 ^ l7;
            long l9 = Long.rotateLeft(e, 23);
            long l10 = (l8 ^ l9) + h;
            long l11 = e & f;
            long l12 = (e ^ 0xFFFFFFFFFFFFFFFFL) & g;
            long l13 = l11 ^ l12;
            long l14 = l10 + l13;
            long l15 = K512[j];
            long l16 = l14 + l15;
            int n5 = j * 8;
            Ptr ptr3 = W512;
            int n6 = W512$offset + n5;
            long l17 = ptr3.getLong(n6);
            T1 = l16 + l17;
            long l18 = Long.rotateLeft(a, 36);
            long l19 = Long.rotateLeft(a, 30);
            long l20 = l18 ^ l19;
            long l21 = Long.rotateLeft(a, 25);
            long l22 = l20 ^ l21;
            long l23 = a & b;
            long l24 = a & c;
            long l25 = l23 ^ l24;
            long l26 = b & c;
            long l27 = l25 ^ l26;
            T2 = l22 + l27;
            h = g;
            g = f;
            f = e;
            e = d + T1;
            d = c;
            c = b;
            b = a;
            a = T1 + T2;
        } while (++j <= 15);
        do {
            int n = (j + 1 & 0xF) * 8;
            Ptr ptr = W512;
            int n7 = W512$offset + n;
            long s0 = ptr.getLong(n7);
            long l = Long.rotateLeft(s0, 63);
            long l28 = Long.rotateLeft(s0, 56);
            long l29 = l ^ l28;
            long l30 = s0 >>> 7;
            s0 = l29 ^ l30;
            int n8 = (j + 14 & 0xF) * 8;
            Ptr ptr4 = W512;
            int n9 = W512$offset + n8;
            long s1 = ptr4.getLong(n9);
            long l31 = Long.rotateLeft(s1, 45);
            long l32 = Long.rotateLeft(s1, 3);
            long l33 = l31 ^ l32;
            long l34 = s1 >>> 6;
            s1 = l33 ^ l34;
            long l35 = Long.rotateLeft(e, 50);
            long l36 = Long.rotateLeft(e, 46);
            long l37 = l35 ^ l36;
            long l38 = Long.rotateLeft(e, 23);
            long l39 = (l37 ^ l38) + h;
            long l40 = e & f;
            long l41 = (e ^ 0xFFFFFFFFFFFFFFFFL) & g;
            long l42 = l40 ^ l41;
            long l43 = l39 + l42;
            long l44 = K512[j];
            long l45 = l43 + l44;
            int n10 = (j & 0xF) * 8;
            Ptr ptr5 = W512;
            int n11 = W512$offset + n10;
            int n12 = (j & 0xF) * 8;
            Ptr ptr6 = W512;
            int n13 = W512$offset + n12;
            long l46 = ptr6.getLong(n13);
            int n14 = (j + 9 & 0xF) * 8;
            Ptr ptr7 = W512;
            int n15 = W512$offset + n14;
            long l47 = ptr7.getLong(n15) + s1 + s0;
            long l48 = l46 + l47;
            ptr5.setLong(n11, l48);
            long l49 = ptr5.getLong(n11);
            T1 = l45 + l49;
            long l50 = Long.rotateLeft(a, 36);
            long l51 = Long.rotateLeft(a, 30);
            long l52 = l50 ^ l51;
            long l53 = Long.rotateLeft(a, 25);
            long l54 = l52 ^ l53;
            long l55 = a & b;
            long l56 = a & c;
            long l57 = l55 ^ l56;
            long l58 = b & c;
            long l59 = l57 ^ l58;
            T2 = l54 + l59;
            h = g;
            g = f;
            f = e;
            e = d + T1;
            d = c;
            c = b;
            b = a;
            a = T1 + T2;
        } while (++j <= 79);
        long l = context.getLong() + a;
        context.setLong(l);
        long l60 = context.getAlignedLong(1) + b;
        context.setAlignedLong(1, l60);
        long l61 = context.getAlignedLong(2) + c;
        context.setAlignedLong(2, l61);
        long l62 = context.getAlignedLong(3) + d;
        context.setAlignedLong(3, l62);
        long l63 = context.getAlignedLong(4) + e;
        context.setAlignedLong(4, l63);
        long l64 = context.getAlignedLong(5) + f;
        context.setAlignedLong(5, l64);
        long l65 = context.getAlignedLong(6) + g;
        context.setAlignedLong(6, l65);
        long l66 = context.getAlignedLong(7) + h;
        context.setAlignedLong(7, l66);
        a = b = (c = (d = (e = (f = (g = (h = (T1 = (T2 = 0L))))))));
    }

    public static void SHA512_Init(Ptr context) {
        if (!context.isNull()) {
            context.memcpy((Ptr)new LongPtr(sha512_initial_hash_value, 0), 64);
            context.pointerPlus(80).memset(0, 128);
            context.setAlignedLong(9, 0L);
            long l = context.getAlignedLong(9);
            context.setAlignedLong(8, l);
        }
    }

    static {
        sha512_initial_hash_value = new long[8];
        K512 = new long[80];
        sha2_hex_digits = new BytePtr("0123456789abcdef\u0000".getBytes(), 0);
        sha2__.sha512_initial_hash_value$$clinit();
        sha2__.K512$$clinit();
    }

    static void sha512_initial_hash_value$$clinit() {
        System.arraycopy(new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L}, 0, sha512_initial_hash_value, 0, 8);
    }

    static void K512$$clinit() {
        System.arraycopy(new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L}, 0, K512, 0, 80);
    }
}

