/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.format;

import java.io.IOException;
import org.renjin.gcc.format.CharIterator;
import org.renjin.gcc.runtime.FileHandle;

public class FileHandleCharIterator
implements CharIterator,
AutoCloseable {
    private FileHandle fileHandle;
    private boolean eof;
    private char nextChar;

    public FileHandleCharIterator(FileHandle fileHandle) {
        this.fileHandle = fileHandle;
        this.readNext();
    }

    private void readNext() {
        int b = 0;
        try {
            b = this.fileHandle.read();
        }
        catch (IOException e) {
            this.eof = true;
            this.fileHandle.setError(e);
        }
        if (b == -1) {
            this.eof = true;
        } else {
            this.nextChar = (char)b;
        }
    }

    @Override
    public boolean hasMore() {
        return !this.eof;
    }

    @Override
    public char peek() {
        return this.nextChar;
    }

    @Override
    public char next() {
        char c = this.nextChar;
        this.readNext();
        return c;
    }

    @Override
    public void close() {
        if (!this.eof) {
            try {
                this.fileHandle.seekCurrent(-1L);
            }
            catch (IOException e) {
                this.fileHandle.setError(e);
            }
        }
    }
}

