/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.format;

import org.renjin.gcc.format.FormatInput;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;

public class FormatArrayInput
implements FormatInput {
    private final Object[] arguments;

    public FormatArrayInput(Object ... arguments) {
        this.arguments = arguments;
    }

    @Override
    public boolean isNA(int argumentIndex) {
        return false;
    }

    @Override
    public int getInt(int argumentIndex) {
        Object value = this.arguments[argumentIndex];
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Ptr) {
            return ((Ptr)value).toInt();
        }
        throw new IllegalArgumentException("Expected integer argument at index " + argumentIndex + ", found " + value.getClass().getName());
    }

    @Override
    public long getLong(int argumentIndex) {
        return ((Number)this.arguments[argumentIndex]).longValue();
    }

    @Override
    public long getUnsignedLong(int argumentIndex) {
        Object value = this.arguments[argumentIndex];
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return Integer.toUnsignedLong((Integer)value);
        }
        throw new IllegalArgumentException("Expected Integer or Long argument at index " + argumentIndex + ", found " + value.getClass().getName());
    }

    @Override
    public double getDouble(int argumentIndex) {
        return ((Number)this.arguments[argumentIndex]).doubleValue();
    }

    @Override
    public String getString(int argumentIndex) {
        Object value = this.arguments[argumentIndex];
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Ptr) {
            return Stdlib.nullTerminatedString((Ptr)value);
        }
        throw new IllegalArgumentException("Expected string argument at index " + argumentIndex);
    }
}

