/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.format;

import java.text.DecimalFormatSymbols;
import org.renjin.gcc.format.FormatInput;
import org.renjin.gcc.format.Formatter;

class FormatSpec {
    private static final int DOUBLE_SIGNIFICAND_WIDTH = 53;
    public static final long DOUBLE_SIGNIF_BIT_MASK = 0xFFFFFFFFFFFFFL;
    public static final long DOUBLE_SIGN_BIT_MASK = Long.MIN_VALUE;
    public static final long DOUBLE_EXP_BIT_MASK = 0x7FF0000000000000L;
    private final DecimalFormatSymbols dfs;
    boolean thousands = false;
    boolean leftJustify = false;
    boolean leadingSign = false;
    boolean leadingSpace = false;
    boolean alternateForm = false;
    boolean leadingZeros = false;
    boolean variableFieldWidth = false;
    int fieldWidth = 0;
    boolean fieldWidthSet = false;
    int precision = 0;
    private static final int defaultDigits = 6;
    boolean variablePrecision = false;
    boolean precisionSet;
    boolean positionalSpecification;
    int argumentPosition;
    int argumentPositionForFieldWidth;
    int argumentPositionForPrecision;
    boolean optionalh = false;
    boolean optionall = false;
    boolean optionalL = false;
    String characterClass;
    boolean inverseCharacterClass;
    char conversionCharacter = '\u0000';
    String literal;

    FormatSpec(DecimalFormatSymbols dfs) {
        this.dfs = dfs;
    }

    Formatter.ArgumentType parseArgumentType() {
        switch (this.conversionCharacter) {
            case 'X': 
            case 'b': 
            case 'd': 
            case 'i': 
            case 'o': 
            case 'u': 
            case 'x': {
                if (this.optionall) {
                    return Formatter.ArgumentType.LONG;
                }
                return Formatter.ArgumentType.INTEGER;
            }
            case 'c': {
                return Formatter.ArgumentType.INTEGER;
            }
            case 'A': 
            case 'E': 
            case 'G': 
            case 'a': 
            case 'e': 
            case 'f': 
            case 'g': {
                return Formatter.ArgumentType.DOUBLE;
            }
            case 'p': {
                return Formatter.ArgumentType.POINTER;
            }
            case 's': {
                return Formatter.ArgumentType.STRING;
            }
        }
        throw new IllegalArgumentException("Invalid conversion character '" + this.conversionCharacter + "'");
    }

    public String format(FormatInput input) {
        if (this.literal != null) {
            return this.literal;
        }
        if (input.isNA(this.argumentPosition)) {
            return "NA";
        }
        if (this.variableFieldWidth) {
            int providedWidth = input.getInt(this.argumentPositionForFieldWidth);
            this.leftJustify = providedWidth < 0;
            this.fieldWidth = Math.abs(providedWidth);
        }
        if (this.variablePrecision) {
            this.precision = input.getInt(this.argumentPositionForPrecision);
            if (this.precision < 0) {
                this.precision = 0;
            }
        }
        switch (this.conversionCharacter) {
            case 'd': 
            case 'i': {
                if (this.optionall) {
                    return this.printDFormat(input.getLong(this.argumentPosition));
                }
                return this.printDFormat(input.getInt(this.argumentPosition));
            }
            case 'u': {
                if (this.optionall) {
                    return this.printDFormat(Long.toUnsignedString(input.getUnsignedLong(this.argumentPosition)));
                }
                return this.printDFormat(Integer.toUnsignedString(input.getInt(this.argumentPosition)));
            }
            case 'o': {
                if (this.optionall) {
                    return this.printOFormat(input.getLong(this.argumentPosition));
                }
                return this.printOFormat(input.getInt(this.argumentPosition));
            }
            case 'p': {
                return this.printXFormat(input.getInt(this.argumentPosition));
            }
            case 'b': {
                if (this.optionall) {
                    return this.printBFormat(input.getLong(this.argumentPosition));
                }
                return this.printBFormat(input.getInt(this.argumentPosition));
            }
            case 'X': 
            case 'x': {
                if (this.optionall) {
                    return this.printXFormat(input.getUnsignedLong(this.argumentPosition));
                }
                return this.printXFormat(input.getInt(this.argumentPosition));
            }
            case 'f': {
                return this.printFFormat(input.getDouble(this.argumentPosition));
            }
            case 'E': 
            case 'e': {
                return this.printEFormat(input.getDouble(this.argumentPosition));
            }
            case 'G': 
            case 'g': {
                return this.printGFormat(input.getDouble(this.argumentPosition));
            }
            case 'A': 
            case 'a': {
                return this.printAFormat(input.getDouble(this.argumentPosition));
            }
            case 'c': {
                return this.printCFormat((char)input.getInt(this.argumentPosition));
            }
            case 's': {
                return this.formatArgument(input.getString(this.argumentPosition));
            }
        }
        throw new IllegalArgumentException("Invalid conversion character '" + this.conversionCharacter + "'");
    }

    String formatArgument(String s) {
        String s2 = "";
        if (this.conversionCharacter != 's' && this.conversionCharacter != 'S') {
            throw new IllegalArgumentException("Cannot format a String with a format using a " + this.conversionCharacter + " conversion character.");
        }
        s2 = this.printSFormat(s);
        return s2;
    }

    private char[] fFormatDigits(double x) {
        int dp;
        char[] ca5;
        char[] ca4;
        char[] ca3;
        int k;
        int j;
        String sx;
        int expon = 0;
        boolean minusSign = false;
        if (x > 0.0) {
            sx = Double.toString(x);
        } else if (x < 0.0) {
            sx = Double.toString(-x);
            minusSign = true;
        } else {
            sx = Double.toString(x);
            if (sx.charAt(0) == '-') {
                minusSign = true;
                sx = sx.substring(1);
            }
        }
        int ePos = sx.indexOf(69);
        int rPos = sx.indexOf(46);
        int n1In = rPos != -1 ? rPos : (ePos != -1 ? ePos : sx.length());
        int n2In = rPos != -1 ? (ePos != -1 ? ePos - rPos - 1 : sx.length() - rPos - 1) : 0;
        if (ePos != -1) {
            int ie = ePos + 1;
            expon = 0;
            if (sx.charAt(ie) == '-') {
                ++ie;
                while (ie < sx.length() && sx.charAt(ie) == '0') {
                    ++ie;
                }
                if (ie < sx.length()) {
                    expon = -Integer.parseInt(sx.substring(ie));
                }
            } else {
                if (sx.charAt(ie) == '+') {
                    ++ie;
                }
                while (ie < sx.length() && sx.charAt(ie) == '0') {
                    ++ie;
                }
                if (ie < sx.length()) {
                    expon = Integer.parseInt(sx.substring(ie));
                }
            }
        }
        int p = this.precisionSet ? this.precision : 6;
        char[] ca1 = sx.toCharArray();
        char[] ca2 = new char[n1In + n2In];
        for (j = 0; j < n1In; ++j) {
            ca2[j] = ca1[j];
        }
        int i = j + 1;
        for (k = 0; k < n2In; ++k) {
            ca2[j] = ca1[i];
            ++j;
            ++i;
        }
        if (n1In + expon <= 0) {
            ca3 = new char[-expon + n2In];
            j = 0;
            k = 0;
            while (k < -n1In - expon) {
                ca3[j] = 48;
                ++k;
                ++j;
            }
            i = 0;
            while (i < n1In + n2In) {
                ca3[j] = ca2[i];
                ++i;
                ++j;
            }
        } else {
            ca3 = ca2;
        }
        boolean carry = false;
        if (p < -expon + n2In && (carry = this.checkForCarry(ca3, i = expon < 0 ? p : p + n1In))) {
            carry = this.startSymbolicCarry(ca3, i - 1, 0);
        }
        if (n1In + expon <= 0) {
            ca4 = new char[2 + p];
            ca4[0] = !carry ? 48 : 49;
            if (this.alternateForm || !this.precisionSet || this.precision != 0) {
                ca4[1] = 46;
                i = 0;
                j = 2;
                while (i < Math.min(p, ca3.length)) {
                    ca4[j] = ca3[i];
                    ++i;
                    ++j;
                }
                while (j < ca4.length) {
                    ca4[j] = 48;
                    ++j;
                }
            }
        } else {
            if (!carry) {
                ca4 = this.alternateForm || !this.precisionSet || this.precision != 0 ? new char[n1In + expon + p + 1] : new char[n1In + expon];
                j = 0;
            } else {
                ca4 = this.alternateForm || !this.precisionSet || this.precision != 0 ? new char[n1In + expon + p + 2] : new char[n1In + expon + 1];
                ca4[0] = 49;
                j = 1;
            }
            i = 0;
            while (i < Math.min(n1In + expon, ca3.length)) {
                ca4[j] = ca3[i];
                ++i;
                ++j;
            }
            while (i < n1In + expon) {
                ca4[j] = 48;
                ++i;
                ++j;
            }
            if (this.alternateForm || !this.precisionSet || this.precision != 0) {
                ca4[j] = 46;
                ++j;
                for (k = 0; i < ca3.length && k < p; ++k) {
                    ca4[j] = ca3[i];
                    ++i;
                    ++j;
                }
                while (j < ca4.length) {
                    ca4[j] = 48;
                    ++j;
                }
            }
        }
        int nZeros = 0;
        if (!this.leftJustify && this.leadingZeros) {
            int xThousands = 0;
            if (this.thousands) {
                int xdp;
                int xlead = 0;
                if (ca4[0] == '+' || ca4[0] == '-' || ca4[0] == ' ') {
                    xlead = 1;
                }
                for (xdp = xlead; xdp < ca4.length && ca4[xdp] != '.'; ++xdp) {
                }
                xThousands = (xdp - xlead) / 3;
            }
            if (this.fieldWidthSet) {
                nZeros = this.fieldWidth - ca4.length;
            }
            if (!minusSign && (this.leadingSign || this.leadingSpace) || minusSign) {
                --nZeros;
            }
            if ((nZeros -= xThousands) < 0) {
                nZeros = 0;
            }
        }
        j = 0;
        if (!minusSign && (this.leadingSign || this.leadingSpace) || minusSign) {
            ca5 = new char[ca4.length + nZeros + 1];
            ++j;
        } else {
            ca5 = new char[ca4.length + nZeros];
        }
        if (!minusSign) {
            if (this.leadingSign) {
                ca5[0] = 43;
            }
            if (this.leadingSpace) {
                ca5[0] = 32;
            }
        } else {
            ca5[0] = 45;
        }
        i = 0;
        while (i < nZeros) {
            ca5[j] = 48;
            ++i;
            ++j;
        }
        i = 0;
        while (i < ca4.length) {
            ca5[j] = ca4[i];
            ++i;
            ++j;
        }
        int lead = 0;
        if (ca5[0] == '+' || ca5[0] == '-' || ca5[0] == ' ') {
            lead = 1;
        }
        for (dp = lead; dp < ca5.length && ca5[dp] != '.'; ++dp) {
        }
        int nThousands = (dp - lead) / 3;
        if (dp < ca5.length) {
            ca5[dp] = this.dfs.getDecimalSeparator();
        }
        char[] ca6 = ca5;
        if (this.thousands && nThousands > 0) {
            ca6 = new char[ca5.length + nThousands + lead];
            ca6[0] = ca5[0];
            k = lead;
            for (i = lead; i < dp; ++i) {
                if (i > 0 && (dp - i) % 3 == 0) {
                    ca6[k] = this.dfs.getGroupingSeparator();
                    ca6[k + 1] = ca5[i];
                    k += 2;
                    continue;
                }
                ca6[k] = ca5[i];
                ++k;
            }
            while (i < ca5.length) {
                ca6[k] = ca5[i];
                ++i;
                ++k;
            }
        }
        return ca6;
    }

    private String fFormatString(double x) {
        char[] ca6;
        boolean noDigits = false;
        if (Double.isInfinite(x)) {
            ca6 = x == Double.POSITIVE_INFINITY ? (this.leadingSign ? "+Inf".toCharArray() : (this.leadingSpace ? " Inf".toCharArray() : "Inf".toCharArray())) : "-Inf".toCharArray();
            noDigits = true;
        } else if (Double.isNaN(x)) {
            ca6 = this.leadingSign ? "+NaN".toCharArray() : (this.leadingSpace ? " NaN".toCharArray() : "NaN".toCharArray());
            noDigits = true;
        } else {
            ca6 = this.fFormatDigits(x);
        }
        char[] ca7 = this.applyFloatPadding(ca6, false);
        return new String(ca7);
    }

    private char[] eFormatDigits(double x, char eChar) {
        int dp;
        char[] ca3;
        int k;
        int i;
        int j;
        char[] ca2;
        int rPos;
        String sx;
        int expon = 0;
        boolean minusSign = false;
        if (x > 0.0) {
            sx = Double.toString(x);
        } else if (x < 0.0) {
            sx = Double.toString(-x);
            minusSign = true;
        } else {
            sx = Double.toString(x);
            if (sx.charAt(0) == '-') {
                minusSign = true;
                sx = sx.substring(1);
            }
        }
        int ePos = sx.indexOf(69);
        if (ePos == -1) {
            ePos = sx.indexOf(101);
        }
        int n1In = (rPos = sx.indexOf(46)) != -1 ? rPos : (ePos != -1 ? ePos : sx.length());
        int n2In = rPos != -1 ? (ePos != -1 ? ePos - rPos - 1 : sx.length() - rPos - 1) : 0;
        if (ePos != -1) {
            int ie = ePos + 1;
            expon = 0;
            if (sx.charAt(ie) == '-') {
                ++ie;
                while (ie < sx.length() && sx.charAt(ie) == '0') {
                    ++ie;
                }
                if (ie < sx.length()) {
                    expon = -Integer.parseInt(sx.substring(ie));
                }
            } else {
                if (sx.charAt(ie) == '+') {
                    ++ie;
                }
                while (ie < sx.length() && sx.charAt(ie) == '0') {
                    ++ie;
                }
                if (ie < sx.length()) {
                    expon = Integer.parseInt(sx.substring(ie));
                }
            }
        }
        if (rPos != -1) {
            expon += rPos - 1;
        }
        int p = this.precisionSet ? this.precision : 6;
        char[] ca1 = rPos != -1 && ePos != -1 ? (sx.substring(0, rPos) + sx.substring(rPos + 1, ePos)).toCharArray() : (rPos != -1 ? (sx.substring(0, rPos) + sx.substring(rPos + 1)).toCharArray() : (ePos != -1 ? sx.substring(0, ePos).toCharArray() : sx.toCharArray()));
        boolean carry = false;
        int i0 = 0;
        if (ca1[0] != '0') {
            i0 = 0;
        } else {
            for (i0 = 0; i0 < ca1.length && ca1[i0] == '0'; ++i0) {
            }
        }
        if (i0 + p < ca1.length - 1) {
            carry = this.checkForCarry(ca1, i0 + p + 1);
            if (carry) {
                carry = this.startSymbolicCarry(ca1, i0 + p, i0);
            }
            if (carry) {
                ca2 = new char[i0 + p + 1];
                ca2[i0] = 49;
                for (j = 0; j < i0; ++j) {
                    ca2[j] = 48;
                }
                i = i0;
                for (j = i0 + 1; j < p + 1; ++j) {
                    ca2[j] = ca1[i];
                    ++i;
                }
                ++expon;
                ca1 = ca2;
            }
        }
        int eSize = Math.abs(expon) < 100 && !this.optionalL ? 4 : 5;
        ca2 = this.alternateForm || !this.precisionSet || this.precision != 0 ? new char[2 + p + eSize] : new char[1 + eSize];
        if (ca1[0] != '0') {
            ca2[0] = ca1[0];
            j = 1;
        } else {
            for (j = 1; j < (ePos == -1 ? ca1.length : ePos) && ca1[j] == '0'; ++j) {
            }
            if (ePos != -1 && j < ePos || ePos == -1 && j < ca1.length) {
                ca2[0] = ca1[j];
                expon -= j;
                ++j;
            } else {
                ca2[0] = 48;
                j = 2;
            }
        }
        if (this.alternateForm || !this.precisionSet || this.precision != 0) {
            ca2[1] = 46;
            i = 2;
        } else {
            i = 1;
        }
        for (k = 0; k < p && j < ca1.length; ++k) {
            ca2[i] = ca1[j];
            ++j;
            ++i;
        }
        while (i < ca2.length - eSize) {
            ca2[i] = 48;
            ++i;
        }
        ca2[i++] = eChar;
        ca2[i++] = expon < 0 ? 45 : 43;
        if ((expon = Math.abs(expon)) >= 100) {
            switch (expon / 100) {
                case 1: {
                    ca2[i] = 49;
                    break;
                }
                case 2: {
                    ca2[i] = 50;
                    break;
                }
                case 3: {
                    ca2[i] = 51;
                    break;
                }
                case 4: {
                    ca2[i] = 52;
                    break;
                }
                case 5: {
                    ca2[i] = 53;
                    break;
                }
                case 6: {
                    ca2[i] = 54;
                    break;
                }
                case 7: {
                    ca2[i] = 55;
                    break;
                }
                case 8: {
                    ca2[i] = 56;
                    break;
                }
                case 9: {
                    ca2[i] = 57;
                }
            }
            ++i;
        }
        switch (expon % 100 / 10) {
            case 0: {
                ca2[i] = 48;
                break;
            }
            case 1: {
                ca2[i] = 49;
                break;
            }
            case 2: {
                ca2[i] = 50;
                break;
            }
            case 3: {
                ca2[i] = 51;
                break;
            }
            case 4: {
                ca2[i] = 52;
                break;
            }
            case 5: {
                ca2[i] = 53;
                break;
            }
            case 6: {
                ca2[i] = 54;
                break;
            }
            case 7: {
                ca2[i] = 55;
                break;
            }
            case 8: {
                ca2[i] = 56;
                break;
            }
            case 9: {
                ca2[i] = 57;
            }
        }
        ++i;
        switch (expon % 10) {
            case 0: {
                ca2[i] = 48;
                break;
            }
            case 1: {
                ca2[i] = 49;
                break;
            }
            case 2: {
                ca2[i] = 50;
                break;
            }
            case 3: {
                ca2[i] = 51;
                break;
            }
            case 4: {
                ca2[i] = 52;
                break;
            }
            case 5: {
                ca2[i] = 53;
                break;
            }
            case 6: {
                ca2[i] = 54;
                break;
            }
            case 7: {
                ca2[i] = 55;
                break;
            }
            case 8: {
                ca2[i] = 56;
                break;
            }
            case 9: {
                ca2[i] = 57;
            }
        }
        int nZeros = 0;
        if (!this.leftJustify && this.leadingZeros) {
            int xThousands = 0;
            if (this.thousands) {
                int xdp;
                int xlead = 0;
                if (ca2[0] == '+' || ca2[0] == '-' || ca2[0] == ' ') {
                    xlead = 1;
                }
                for (xdp = xlead; xdp < ca2.length && ca2[xdp] != '.'; ++xdp) {
                }
                xThousands = (xdp - xlead) / 3;
            }
            if (this.fieldWidthSet) {
                nZeros = this.fieldWidth - ca2.length;
            }
            if (!minusSign && (this.leadingSign || this.leadingSpace) || minusSign) {
                --nZeros;
            }
            if ((nZeros -= xThousands) < 0) {
                nZeros = 0;
            }
        }
        j = 0;
        if (!minusSign && (this.leadingSign || this.leadingSpace) || minusSign) {
            ca3 = new char[ca2.length + nZeros + 1];
            ++j;
        } else {
            ca3 = new char[ca2.length + nZeros];
        }
        if (!minusSign) {
            if (this.leadingSign) {
                ca3[0] = 43;
            }
            if (this.leadingSpace) {
                ca3[0] = 32;
            }
        } else {
            ca3[0] = 45;
        }
        for (k = 0; k < nZeros; ++k) {
            ca3[j] = 48;
            ++j;
        }
        for (i = 0; i < ca2.length && j < ca3.length; ++i, ++j) {
            ca3[j] = ca2[i];
        }
        int lead = 0;
        if (ca3[0] == '+' || ca3[0] == '-' || ca3[0] == ' ') {
            lead = 1;
        }
        for (dp = lead; dp < ca3.length && ca3[dp] != '.'; ++dp) {
        }
        int nThousands = dp / 3;
        if (dp < ca3.length) {
            ca3[dp] = this.dfs.getDecimalSeparator();
        }
        char[] ca4 = ca3;
        if (this.thousands && nThousands > 0) {
            ca4 = new char[ca3.length + nThousands + lead];
            ca4[0] = ca3[0];
            k = lead;
            for (i = lead; i < dp; ++i) {
                if (i > 0 && (dp - i) % 3 == 0) {
                    ca4[k] = this.dfs.getGroupingSeparator();
                    ca4[k + 1] = ca3[i];
                    k += 2;
                    continue;
                }
                ca4[k] = ca3[i];
                ++k;
            }
            while (i < ca3.length) {
                ca4[k] = ca3[i];
                ++i;
                ++k;
            }
        }
        return ca4;
    }

    private boolean checkForCarry(char[] ca1, int icarry) {
        boolean carry = false;
        if (icarry < ca1.length) {
            if (ca1[icarry] == '6' || ca1[icarry] == '7' || ca1[icarry] == '8' || ca1[icarry] == '9') {
                carry = true;
            } else if (ca1[icarry] == '5') {
                int ii;
                for (ii = icarry + 1; ii < ca1.length && ca1[ii] == '0'; ++ii) {
                }
                boolean bl = carry = ii < ca1.length;
                if (!carry && icarry > 0) {
                    carry = ca1[icarry - 1] == '1' || ca1[icarry - 1] == '3' || ca1[icarry - 1] == '5' || ca1[icarry - 1] == '7' || ca1[icarry - 1] == '9';
                }
            }
        }
        return carry;
    }

    private boolean startSymbolicCarry(char[] ca, int cLast, int cFirst) {
        boolean carry = true;
        block12: for (int i = cLast; carry && i >= cFirst; --i) {
            carry = false;
            switch (ca[i]) {
                case '0': {
                    ca[i] = 49;
                    continue block12;
                }
                case '1': {
                    ca[i] = 50;
                    continue block12;
                }
                case '2': {
                    ca[i] = 51;
                    continue block12;
                }
                case '3': {
                    ca[i] = 52;
                    continue block12;
                }
                case '4': {
                    ca[i] = 53;
                    continue block12;
                }
                case '5': {
                    ca[i] = 54;
                    continue block12;
                }
                case '6': {
                    ca[i] = 55;
                    continue block12;
                }
                case '7': {
                    ca[i] = 56;
                    continue block12;
                }
                case '8': {
                    ca[i] = 57;
                    continue block12;
                }
                case '9': {
                    ca[i] = 48;
                    carry = true;
                }
            }
        }
        return carry;
    }

    private String eFormatString(double x, char eChar) {
        char[] ca4;
        boolean noDigits = false;
        if (Double.isInfinite(x)) {
            ca4 = x == Double.POSITIVE_INFINITY ? (this.leadingSign ? "+Inf".toCharArray() : (this.leadingSpace ? " Inf".toCharArray() : "Inf".toCharArray())) : "-Inf".toCharArray();
            noDigits = true;
        } else if (Double.isNaN(x)) {
            ca4 = this.leadingSign ? "+NaN".toCharArray() : (this.leadingSpace ? " NaN".toCharArray() : "NaN".toCharArray());
            noDigits = true;
        } else {
            ca4 = this.eFormatDigits(x, eChar);
        }
        char[] ca5 = this.applyFloatPadding(ca4, false);
        return new String(ca5);
    }

    private char[] applyFloatPadding(char[] ca4, boolean noDigits) {
        char[] ca5;
        block8: {
            int nBlanks;
            block10: {
                int i;
                block9: {
                    int i2;
                    ca5 = ca4;
                    if (!this.fieldWidthSet) break block8;
                    if (!this.leftJustify) break block9;
                    int nBlanks2 = this.fieldWidth - ca4.length;
                    if (nBlanks2 <= 0) break block8;
                    ca5 = new char[ca4.length + nBlanks2];
                    for (i2 = 0; i2 < ca4.length; ++i2) {
                        ca5[i2] = ca4[i2];
                    }
                    int j = 0;
                    while (j < nBlanks2) {
                        ca5[i2] = 32;
                        ++j;
                        ++i2;
                    }
                    break block8;
                }
                if (this.leadingZeros && !noDigits) break block10;
                int nBlanks3 = this.fieldWidth - ca4.length;
                if (nBlanks3 <= 0) break block8;
                ca5 = new char[ca4.length + nBlanks3];
                for (i = 0; i < nBlanks3; ++i) {
                    ca5[i] = 32;
                }
                for (int j = 0; j < ca4.length; ++j) {
                    ca5[i] = ca4[j];
                    ++i;
                }
                break block8;
            }
            if (this.leadingZeros && (nBlanks = this.fieldWidth - ca4.length) > 0) {
                ca5 = new char[ca4.length + nBlanks];
                int i = 0;
                int j = 0;
                if (ca4[0] == '-') {
                    ca5[0] = 45;
                    ++i;
                    ++j;
                }
                for (int k = 0; k < nBlanks; ++k) {
                    ca5[i] = 48;
                    ++i;
                }
                while (j < ca4.length) {
                    ca5[i] = ca4[j];
                    ++i;
                    ++j;
                }
            }
        }
        return ca5;
    }

    private String printFFormat(double x) {
        return this.fFormatString(x);
    }

    private String printEFormat(double x) {
        if (this.conversionCharacter == 'e') {
            return this.eFormatString(x, 'e');
        }
        return this.eFormatString(x, 'E');
    }

    private String printGFormat(double x) {
        char[] ca4;
        int savePrecision = this.precision;
        boolean noDigits = false;
        if (Double.isInfinite(x)) {
            ca4 = x == Double.POSITIVE_INFINITY ? (this.leadingSign ? "+Inf".toCharArray() : (this.leadingSpace ? " Inf".toCharArray() : "Inf".toCharArray())) : "-Inf".toCharArray();
            noDigits = true;
        } else if (Double.isNaN(x)) {
            ca4 = this.leadingSign ? "+NaN".toCharArray() : (this.leadingSpace ? " NaN".toCharArray() : "NaN".toCharArray());
            noDigits = true;
        } else {
            String ret;
            String sx;
            if (!this.precisionSet) {
                this.precision = 6;
            }
            if (this.precision == 0) {
                this.precision = 1;
            }
            int ePos = -1;
            if (this.conversionCharacter == 'g') {
                sx = this.eFormatString(x, 'e').trim();
                ePos = sx.indexOf(101);
            } else {
                sx = this.eFormatString(x, 'E').trim();
                ePos = sx.indexOf(69);
            }
            int i = ePos + 1;
            int expon = 0;
            if (sx.charAt(i) == '-') {
                ++i;
                while (i < sx.length() && sx.charAt(i) == '0') {
                    ++i;
                }
                if (i < sx.length()) {
                    expon = -Integer.parseInt(sx.substring(i));
                }
            } else {
                if (sx.charAt(i) == '+') {
                    ++i;
                }
                while (i < sx.length() && sx.charAt(i) == '0') {
                    ++i;
                }
                if (i < sx.length()) {
                    expon = Integer.parseInt(sx.substring(i));
                }
            }
            if (!this.alternateForm) {
                String sy = expon >= -4 && expon < this.precision ? this.fFormatString(x).trim() : sx.substring(0, ePos);
                for (i = sy.length() - 1; i >= 0 && sy.charAt(i) == '0'; --i) {
                }
                if (i >= 0 && sy.charAt(i) == '.') {
                    --i;
                }
                String sz = i == -1 ? "0" : (!Character.isDigit(sy.charAt(i)) ? sy.substring(0, i + 1) + "0" : sy.substring(0, i + 1));
                ret = expon >= -4 && expon < this.precision ? sz : sz + sx.substring(ePos);
            } else {
                ret = expon >= -4 && expon < this.precision ? this.fFormatString(x).trim() : sx;
            }
            if (this.leadingSpace && x >= 0.0) {
                ret = " " + ret;
            }
            ca4 = ret.toCharArray();
        }
        char[] ca5 = this.applyFloatPadding(ca4, false);
        this.precision = savePrecision;
        return new String(ca5);
    }

    private String printAFormat(double x) {
        char[] ca4;
        int savePrecision = this.precision;
        boolean noDigits = false;
        if (Double.isInfinite(x)) {
            ca4 = x == Double.POSITIVE_INFINITY ? (this.leadingSign ? "+Inf".toCharArray() : (this.leadingSpace ? " Inf".toCharArray() : "Inf".toCharArray())) : "-Inf".toCharArray();
            noDigits = true;
        } else if (Double.isNaN(x)) {
            ca4 = this.leadingSign ? "+NaN".toCharArray() : (this.leadingSpace ? " NaN".toCharArray() : "NaN".toCharArray());
            noDigits = true;
        } else {
            if (!this.precisionSet) {
                this.precision = 15;
            }
            if (this.precision == 0) {
                this.precision = 1;
            }
            String hexString = "0x" + this.hexDouble(x, this.precision);
            if (this.conversionCharacter == 'A') {
                hexString = hexString.toUpperCase();
            }
            ca4 = hexString.toCharArray();
        }
        char[] ca5 = this.applyFloatPadding(ca4, false);
        this.precision = savePrecision;
        return new String(ca5);
    }

    private String hexDouble(double d, int prec) {
        long signBit;
        double result;
        boolean sticky;
        boolean subnormal;
        if (!Double.isFinite(d) || d == 0.0 || prec == 0 || prec >= 13) {
            return this.toHexString(d).substring(2);
        }
        int exponent = Math.getExponent(d);
        boolean bl = subnormal = exponent == -1023;
        if (subnormal) {
            double scaleUp = Math.scalb(1.0, 54);
            exponent = Math.getExponent(d *= scaleUp);
            assert (exponent >= -1022 && exponent <= 1023) : exponent;
        }
        int precision = 1 + prec * 4;
        int shiftDistance = 53 - precision;
        assert (shiftDistance >= 1 && shiftDistance < 53);
        long doppel = Double.doubleToLongBits(d);
        long newSignif = (doppel & Long.MAX_VALUE) >> shiftDistance;
        long roundingBits = doppel & (-1L << shiftDistance ^ 0xFFFFFFFFFFFFFFFFL);
        boolean leastZero = (newSignif & 1L) == 0L;
        boolean round = (1L << shiftDistance - 1 & roundingBits) != 0L;
        boolean bl2 = sticky = shiftDistance > 1 && ((1L << shiftDistance - 1 ^ 0xFFFFFFFFFFFFFFFFL) & roundingBits) != 0L;
        if (leastZero && round && sticky || !leastZero && round) {
            ++newSignif;
        }
        if (Double.isInfinite(result = Double.longBitsToDouble(newSignif = (signBit = doppel & Long.MIN_VALUE) | newSignif << shiftDistance))) {
            return "1.0p+1024";
        }
        String res = this.toHexString(result).substring(2);
        if (!subnormal) {
            return res;
        }
        int idx = res.indexOf(112);
        if (idx == -1) {
            assert (false);
            return null;
        }
        String exp = res.substring(idx + 1);
        int iexp = Integer.parseInt(exp) - 54;
        return res.substring(0, idx) + "p" + (iexp < 0 ? "" : "+") + Integer.toString(iexp);
    }

    public String toHexString(double d) {
        assert (Double.isFinite(d));
        StringBuilder answer = new StringBuilder(24);
        if (Math.copySign(1.0, d) == -1.0) {
            answer.append("-");
        }
        answer.append("0x");
        d = Math.abs(d);
        if (d == 0.0) {
            answer.append("0.0p+0");
        } else {
            int exponent;
            boolean subnormal = d < Double.MIN_NORMAL;
            long signifBits = Double.doubleToLongBits(d) & 0xFFFFFFFFFFFFFL | 0x1000000000000000L;
            answer.append(subnormal ? "0." : "1.");
            String signif = Long.toHexString(signifBits).substring(3, 16);
            answer.append(signif.equals("0000000000000") ? "0" : signif.replaceFirst("0{1,12}$", ""));
            answer.append('p');
            int n = exponent = subnormal ? -1022 : Math.getExponent(d);
            if (exponent >= 0) {
                answer.append("+");
            }
            answer.append(exponent);
        }
        return answer.toString();
    }

    private String printDFormat(short x) {
        return this.printDFormat(Short.toString(x));
    }

    private String printDFormat(long x) {
        return this.printDFormat(Long.toString(x));
    }

    private String printBFormat(long x) {
        return Long.toBinaryString(x);
    }

    private String printDFormat(int x) {
        return this.printDFormat(Integer.toString(x));
    }

    private String printDFormat(String sx) {
        char[] ca;
        block30: {
            int j;
            boolean neg;
            int jFirst;
            int i;
            int nLeadingZeros;
            block33: {
                int nBlanks;
                block31: {
                    block34: {
                        block32: {
                            block29: {
                                int j2;
                                nLeadingZeros = 0;
                                nBlanks = 0;
                                int n = 0;
                                i = 0;
                                jFirst = 0;
                                boolean bl = neg = sx.charAt(0) == '-';
                                if (sx.equals("0") && this.precisionSet && this.precision == 0) {
                                    sx = "";
                                }
                                if (!neg) {
                                    if (this.precisionSet && sx.length() < this.precision) {
                                        nLeadingZeros = this.precision - sx.length();
                                    }
                                } else if (this.precisionSet && sx.length() - 1 < this.precision) {
                                    nLeadingZeros = this.precision - sx.length() + 1;
                                }
                                if (nLeadingZeros < 0) {
                                    nLeadingZeros = 0;
                                }
                                if (this.fieldWidthSet) {
                                    nBlanks = this.fieldWidth - nLeadingZeros - sx.length();
                                    if (!neg && (this.leadingSign || this.leadingSpace)) {
                                        --nBlanks;
                                    }
                                }
                                if (nBlanks < 0) {
                                    nBlanks = 0;
                                }
                                if (this.leadingSign) {
                                    ++n;
                                } else if (this.leadingSpace) {
                                    ++n;
                                }
                                n += nBlanks;
                                n += nLeadingZeros;
                                ca = new char[n += sx.length()];
                                if (!this.leftJustify) break block29;
                                if (neg) {
                                    ca[i++] = 45;
                                } else if (this.leadingSign) {
                                    ca[i++] = 43;
                                } else if (this.leadingSpace) {
                                    ca[i++] = 32;
                                }
                                char[] csx = sx.toCharArray();
                                jFirst = neg ? 1 : 0;
                                for (j2 = 0; j2 < nLeadingZeros; ++j2) {
                                    ca[i] = 48;
                                    ++i;
                                }
                                j2 = jFirst;
                                while (j2 < csx.length) {
                                    ca[i] = csx[j2];
                                    ++j2;
                                    ++i;
                                }
                                for (j2 = 0; j2 < nBlanks; ++j2) {
                                    ca[i] = 32;
                                    ++i;
                                }
                                break block30;
                            }
                            if (this.leadingZeros) break block31;
                            for (i = 0; i < nBlanks; ++i) {
                                ca[i] = 32;
                            }
                            if (!neg) break block32;
                            ca[i++] = 45;
                            break block33;
                        }
                        if (!this.leadingSign) break block34;
                        ca[i++] = 43;
                        break block33;
                    }
                    if (!this.leadingSpace) break block33;
                    ca[i++] = 32;
                    break block33;
                }
                if (neg) {
                    ca[i++] = 45;
                } else if (this.leadingSign) {
                    ca[i++] = 43;
                } else if (this.leadingSpace) {
                    ca[i++] = 32;
                }
                j = 0;
                while (j < nBlanks) {
                    ca[i] = 48;
                    ++j;
                    ++i;
                }
            }
            j = 0;
            while (j < nLeadingZeros) {
                ca[i] = 48;
                ++j;
                ++i;
            }
            char[] csx = sx.toCharArray();
            int j3 = jFirst = neg ? 1 : 0;
            while (j3 < csx.length) {
                ca[i] = csx[j3];
                ++j3;
                ++i;
            }
        }
        return new String(ca);
    }

    private String printXFormat(short x) {
        String sx = null;
        if (x == Short.MIN_VALUE) {
            sx = "8000";
        } else if (x < 0) {
            String t;
            if (x == Short.MIN_VALUE) {
                t = "0";
            } else {
                t = Integer.toString(~(-x - 1) ^ Short.MIN_VALUE, 16);
                if (t.charAt(0) == 'F' || t.charAt(0) == 'f') {
                    t = t.substring(16, 32);
                }
            }
            block0 : switch (t.length()) {
                case 1: {
                    sx = "800" + t;
                    break;
                }
                case 2: {
                    sx = "80" + t;
                    break;
                }
                case 3: {
                    sx = "8" + t;
                    break;
                }
                case 4: {
                    switch (t.charAt(0)) {
                        case '1': {
                            sx = "9" + t.substring(1, 4);
                            break block0;
                        }
                        case '2': {
                            sx = "a" + t.substring(1, 4);
                            break block0;
                        }
                        case '3': {
                            sx = "b" + t.substring(1, 4);
                            break block0;
                        }
                        case '4': {
                            sx = "c" + t.substring(1, 4);
                            break block0;
                        }
                        case '5': {
                            sx = "d" + t.substring(1, 4);
                            break block0;
                        }
                        case '6': {
                            sx = "e" + t.substring(1, 4);
                            break block0;
                        }
                        case '7': {
                            sx = "f" + t.substring(1, 4);
                        }
                    }
                }
            }
        } else {
            sx = Integer.toString(x, 16);
        }
        return this.printXFormat(sx);
    }

    private String printXFormat(long x) {
        String sx = null;
        if (x == Long.MIN_VALUE) {
            sx = "8000000000000000";
        } else if (x < 0L) {
            String t = Long.toString(-x - 1L ^ 0xFFFFFFFFFFFFFFFFL ^ Long.MIN_VALUE, 16);
            block0 : switch (t.length()) {
                case 1: {
                    sx = "800000000000000" + t;
                    break;
                }
                case 2: {
                    sx = "80000000000000" + t;
                    break;
                }
                case 3: {
                    sx = "8000000000000" + t;
                    break;
                }
                case 4: {
                    sx = "800000000000" + t;
                    break;
                }
                case 5: {
                    sx = "80000000000" + t;
                    break;
                }
                case 6: {
                    sx = "8000000000" + t;
                    break;
                }
                case 7: {
                    sx = "800000000" + t;
                    break;
                }
                case 8: {
                    sx = "80000000" + t;
                    break;
                }
                case 9: {
                    sx = "8000000" + t;
                    break;
                }
                case 10: {
                    sx = "800000" + t;
                    break;
                }
                case 11: {
                    sx = "80000" + t;
                    break;
                }
                case 12: {
                    sx = "8000" + t;
                    break;
                }
                case 13: {
                    sx = "800" + t;
                    break;
                }
                case 14: {
                    sx = "80" + t;
                    break;
                }
                case 15: {
                    sx = "8" + t;
                    break;
                }
                case 16: {
                    switch (t.charAt(0)) {
                        case '1': {
                            sx = "9" + t.substring(1, 16);
                            break block0;
                        }
                        case '2': {
                            sx = "a" + t.substring(1, 16);
                            break block0;
                        }
                        case '3': {
                            sx = "b" + t.substring(1, 16);
                            break block0;
                        }
                        case '4': {
                            sx = "c" + t.substring(1, 16);
                            break block0;
                        }
                        case '5': {
                            sx = "d" + t.substring(1, 16);
                            break block0;
                        }
                        case '6': {
                            sx = "e" + t.substring(1, 16);
                            break block0;
                        }
                        case '7': {
                            sx = "f" + t.substring(1, 16);
                        }
                    }
                }
            }
        } else {
            sx = Long.toString(x, 16);
        }
        return this.printXFormat(sx);
    }

    private String printXFormat(int x) {
        String sx = null;
        if (x == Integer.MIN_VALUE) {
            sx = "80000000";
        } else if (x < 0) {
            String t = Integer.toString(~(-x - 1) ^ Integer.MIN_VALUE, 16);
            block0 : switch (t.length()) {
                case 1: {
                    sx = "8000000" + t;
                    break;
                }
                case 2: {
                    sx = "800000" + t;
                    break;
                }
                case 3: {
                    sx = "80000" + t;
                    break;
                }
                case 4: {
                    sx = "8000" + t;
                    break;
                }
                case 5: {
                    sx = "800" + t;
                    break;
                }
                case 6: {
                    sx = "80" + t;
                    break;
                }
                case 7: {
                    sx = "8" + t;
                    break;
                }
                case 8: {
                    switch (t.charAt(0)) {
                        case '1': {
                            sx = "9" + t.substring(1, 8);
                            break block0;
                        }
                        case '2': {
                            sx = "a" + t.substring(1, 8);
                            break block0;
                        }
                        case '3': {
                            sx = "b" + t.substring(1, 8);
                            break block0;
                        }
                        case '4': {
                            sx = "c" + t.substring(1, 8);
                            break block0;
                        }
                        case '5': {
                            sx = "d" + t.substring(1, 8);
                            break block0;
                        }
                        case '6': {
                            sx = "e" + t.substring(1, 8);
                            break block0;
                        }
                        case '7': {
                            sx = "f" + t.substring(1, 8);
                        }
                    }
                }
            }
        } else {
            sx = Integer.toString(x, 16);
        }
        return this.printXFormat(sx);
    }

    private String printXFormat(String sx) {
        char[] csx;
        int nLeadingZeros = 0;
        int nBlanks = 0;
        if (sx.equals("0") && this.precisionSet && this.precision == 0) {
            sx = "";
        }
        if (this.precisionSet) {
            nLeadingZeros = this.precision - sx.length();
        }
        if (nLeadingZeros < 0) {
            nLeadingZeros = 0;
        }
        if (this.fieldWidthSet) {
            nBlanks = this.fieldWidth - nLeadingZeros - sx.length();
            if (this.alternateForm) {
                nBlanks -= 2;
            }
        }
        if (nBlanks < 0) {
            nBlanks = 0;
        }
        int n = 0;
        if (this.alternateForm) {
            n += 2;
        }
        n += nLeadingZeros;
        n += sx.length();
        char[] ca = new char[n += nBlanks];
        int i = 0;
        if (this.leftJustify) {
            if (this.alternateForm) {
                ca[i++] = 48;
                ca[i++] = 120;
            }
            int j = 0;
            while (j < nLeadingZeros) {
                ca[i] = 48;
                ++j;
                ++i;
            }
            csx = sx.toCharArray();
            int j2 = 0;
            while (j2 < csx.length) {
                ca[i] = csx[j2];
                ++j2;
                ++i;
            }
            j2 = 0;
            while (j2 < nBlanks) {
                ca[i] = 32;
                ++j2;
                ++i;
            }
        } else {
            int j;
            if (!this.leadingZeros) {
                j = 0;
                while (j < nBlanks) {
                    ca[i] = 32;
                    ++j;
                    ++i;
                }
            }
            if (this.alternateForm) {
                ca[i++] = 48;
                ca[i++] = 120;
            }
            if (this.leadingZeros) {
                j = 0;
                while (j < nBlanks) {
                    ca[i] = 48;
                    ++j;
                    ++i;
                }
            }
            j = 0;
            while (j < nLeadingZeros) {
                ca[i] = 48;
                ++j;
                ++i;
            }
            csx = sx.toCharArray();
            int j3 = 0;
            while (j3 < csx.length) {
                ca[i] = csx[j3];
                ++j3;
                ++i;
            }
        }
        String caReturn = new String(ca);
        if (this.conversionCharacter == 'X' || this.conversionCharacter == 'p') {
            caReturn = caReturn.toUpperCase();
        }
        return caReturn;
    }

    private String printOFormat(short x) {
        String sx = null;
        if (x == Short.MIN_VALUE) {
            sx = "100000";
        } else if (x < 0) {
            String t = Integer.toString(~(-x - 1) ^ Short.MIN_VALUE, 8);
            switch (t.length()) {
                case 1: {
                    sx = "10000" + t;
                    break;
                }
                case 2: {
                    sx = "1000" + t;
                    break;
                }
                case 3: {
                    sx = "100" + t;
                    break;
                }
                case 4: {
                    sx = "10" + t;
                    break;
                }
                case 5: {
                    sx = "1" + t;
                }
            }
        } else {
            sx = Integer.toString(x, 8);
        }
        return this.printOFormat(sx);
    }

    private String printOFormat(long x) {
        String sx = null;
        if (x == Long.MIN_VALUE) {
            sx = "1000000000000000000000";
        } else if (x < 0L) {
            String t = Long.toString(-x - 1L ^ 0xFFFFFFFFFFFFFFFFL ^ Long.MIN_VALUE, 8);
            switch (t.length()) {
                case 1: {
                    sx = "100000000000000000000" + t;
                    break;
                }
                case 2: {
                    sx = "10000000000000000000" + t;
                    break;
                }
                case 3: {
                    sx = "1000000000000000000" + t;
                    break;
                }
                case 4: {
                    sx = "100000000000000000" + t;
                    break;
                }
                case 5: {
                    sx = "10000000000000000" + t;
                    break;
                }
                case 6: {
                    sx = "1000000000000000" + t;
                    break;
                }
                case 7: {
                    sx = "100000000000000" + t;
                    break;
                }
                case 8: {
                    sx = "10000000000000" + t;
                    break;
                }
                case 9: {
                    sx = "1000000000000" + t;
                    break;
                }
                case 10: {
                    sx = "100000000000" + t;
                    break;
                }
                case 11: {
                    sx = "10000000000" + t;
                    break;
                }
                case 12: {
                    sx = "1000000000" + t;
                    break;
                }
                case 13: {
                    sx = "100000000" + t;
                    break;
                }
                case 14: {
                    sx = "10000000" + t;
                    break;
                }
                case 15: {
                    sx = "1000000" + t;
                    break;
                }
                case 16: {
                    sx = "100000" + t;
                    break;
                }
                case 17: {
                    sx = "10000" + t;
                    break;
                }
                case 18: {
                    sx = "1000" + t;
                    break;
                }
                case 19: {
                    sx = "100" + t;
                    break;
                }
                case 20: {
                    sx = "10" + t;
                    break;
                }
                case 21: {
                    sx = "1" + t;
                }
            }
        } else {
            sx = Long.toString(x, 8);
        }
        return this.printOFormat(sx);
    }

    private String printOFormat(int x) {
        String sx = null;
        if (x == Integer.MIN_VALUE) {
            sx = "20000000000";
        } else if (x < 0) {
            String t = Integer.toString(~(-x - 1) ^ Integer.MIN_VALUE, 8);
            switch (t.length()) {
                case 1: {
                    sx = "2000000000" + t;
                    break;
                }
                case 2: {
                    sx = "200000000" + t;
                    break;
                }
                case 3: {
                    sx = "20000000" + t;
                    break;
                }
                case 4: {
                    sx = "2000000" + t;
                    break;
                }
                case 5: {
                    sx = "200000" + t;
                    break;
                }
                case 6: {
                    sx = "20000" + t;
                    break;
                }
                case 7: {
                    sx = "2000" + t;
                    break;
                }
                case 8: {
                    sx = "200" + t;
                    break;
                }
                case 9: {
                    sx = "20" + t;
                    break;
                }
                case 10: {
                    sx = "2" + t;
                    break;
                }
                case 11: {
                    sx = "3" + t.substring(1);
                }
            }
        } else {
            sx = Integer.toString(x, 8);
        }
        return this.printOFormat(sx);
    }

    private String printOFormat(String sx) {
        int nLeadingZeros = 0;
        int nBlanks = 0;
        if (sx.equals("0") && this.precisionSet && this.precision == 0) {
            sx = "";
        }
        if (this.precisionSet) {
            nLeadingZeros = this.precision - sx.length();
        }
        if (this.alternateForm) {
            ++nLeadingZeros;
        }
        if (nLeadingZeros < 0) {
            nLeadingZeros = 0;
        }
        if (this.fieldWidthSet) {
            nBlanks = this.fieldWidth - nLeadingZeros - sx.length();
        }
        if (nBlanks < 0) {
            nBlanks = 0;
        }
        int n = nLeadingZeros + sx.length() + nBlanks;
        char[] ca = new char[n];
        if (this.leftJustify) {
            int i;
            for (i = 0; i < nLeadingZeros; ++i) {
                ca[i] = 48;
            }
            char[] csx = sx.toCharArray();
            int j = 0;
            while (j < csx.length) {
                ca[i] = csx[j];
                ++j;
                ++i;
            }
            j = 0;
            while (j < nBlanks) {
                ca[i] = 32;
                ++j;
                ++i;
            }
        } else {
            int i;
            if (this.leadingZeros) {
                for (i = 0; i < nBlanks; ++i) {
                    ca[i] = 48;
                }
            } else {
                for (i = 0; i < nBlanks; ++i) {
                    ca[i] = 32;
                }
            }
            int j = 0;
            while (j < nLeadingZeros) {
                ca[i] = 48;
                ++j;
                ++i;
            }
            char[] csx = sx.toCharArray();
            int j2 = 0;
            while (j2 < csx.length) {
                ca[i] = csx[j2];
                ++j2;
                ++i;
            }
        }
        return new String(ca);
    }

    private String printCFormat(char x) {
        int nPrint = 1;
        int width = this.fieldWidth;
        if (!this.fieldWidthSet) {
            width = nPrint;
        }
        char[] ca = new char[width];
        int i = 0;
        if (this.leftJustify) {
            ca[0] = x;
            for (i = 1; i <= width - nPrint; ++i) {
                ca[i] = 32;
            }
        } else {
            for (i = 0; i < width - nPrint; ++i) {
                ca[i] = 32;
            }
            ca[i] = x;
        }
        return new String(ca);
    }

    private String printSFormat(String x) {
        int nPrint = x.length();
        int width = this.fieldWidth;
        if (this.precisionSet && nPrint > this.precision) {
            nPrint = this.precision;
        }
        if (!this.fieldWidthSet) {
            width = nPrint;
        }
        int n = 0;
        if (width > nPrint) {
            n += width - nPrint;
        }
        n = nPrint >= x.length() ? (n += x.length()) : (n += nPrint);
        char[] ca = new char[n];
        int i = 0;
        if (this.leftJustify) {
            char[] csx;
            if (nPrint >= x.length()) {
                csx = x.toCharArray();
                for (i = 0; i < x.length(); ++i) {
                    ca[i] = csx[i];
                }
            } else {
                csx = x.substring(0, nPrint).toCharArray();
                for (i = 0; i < nPrint; ++i) {
                    ca[i] = csx[i];
                }
            }
            int j = 0;
            while (j < width - nPrint) {
                ca[i] = 32;
                ++j;
                ++i;
            }
        } else {
            for (i = 0; i < width - nPrint; ++i) {
                ca[i] = 32;
            }
            if (nPrint >= x.length()) {
                char[] csx = x.toCharArray();
                for (int j = 0; j < x.length(); ++j) {
                    ca[i] = csx[j];
                    ++i;
                }
            } else {
                char[] csx = x.substring(0, nPrint).toCharArray();
                for (int j = 0; j < nPrint; ++j) {
                    ca[i] = csx[j];
                    ++i;
                }
            }
        }
        return new String(ca);
    }
}

