/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.format;

import java.nio.charset.StandardCharsets;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.renjin.gcc.format.CharIterator;
import org.renjin.gcc.format.CharPredicator;
import org.renjin.gcc.format.FormatArrayInput;
import org.renjin.gcc.format.FormatInput;
import org.renjin.gcc.format.FormatSpec;
import org.renjin.gcc.runtime.Ptr;

public class Formatter {
    private final Mode mode;
    private final String formatString;
    private final List<FormatSpec> conversions = new ArrayList<FormatSpec>();
    private List<ArgumentType> argumentTypes = new ArrayList<ArgumentType>();
    private int currentPos = 0;
    private int currentArgumentIndex = 0;
    private FormatSpec currentSpec;
    private DecimalFormatSymbols dfs;

    public Formatter(String formatString) throws IllegalArgumentException {
        this(Locale.getDefault(), formatString, Mode.PRINT);
    }

    public Formatter(String formatString, Mode mode) {
        this(Locale.getDefault(), formatString, mode);
    }

    public Formatter(Locale locale, String formatString, Mode mode) throws IllegalArgumentException {
        this.formatString = formatString;
        this.mode = mode;
        this.dfs = new DecimalFormatSymbols(locale);
        this.consumeLiteral();
        while (this.currentPos < formatString.length()) {
            this.consumeNextSpec();
            this.consumeLiteral();
        }
    }

    private void consumeLiteral() {
        StringBuilder sb = new StringBuilder();
        block10: while (this.hasMoreChars()) {
            char c = this.next();
            if (c == '%') {
                this.pushBack();
                break;
            }
            if (c == '\\') {
                if (!this.hasMoreChars()) continue;
                c = this.next();
                switch (c) {
                    case 'a': {
                        sb.append('\u0007');
                        continue block10;
                    }
                    case 'b': {
                        sb.append('\b');
                        continue block10;
                    }
                    case 'f': {
                        sb.append('\f');
                        continue block10;
                    }
                    case 'n': {
                        sb.append(System.getProperty("line.separator"));
                        continue block10;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block10;
                    }
                    case 't': {
                        sb.append('\t');
                        continue block10;
                    }
                    case 'v': {
                        sb.append('\u000b');
                        continue block10;
                    }
                    case '\\': {
                        sb.append('\\');
                        continue block10;
                    }
                }
                sb.append('\\');
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() != 0) {
            FormatSpec spec = new FormatSpec(this.dfs);
            spec.conversionCharacter = '\u0000';
            spec.literal = sb.toString();
            this.conversions.add(spec);
        }
    }

    private void consumeNextSpec() {
        if (this.consumeIf('%')) {
            this.currentSpec = new FormatSpec(this.dfs);
            this.consumePosition();
            this.consumeFlags();
            this.consumeFieldWidth();
            this.consumePrecision();
            this.consumeSizeFlags();
            this.consumeConversionCharacter();
            if (this.currentSpec.conversionCharacter == '%') {
                FormatSpec spec = new FormatSpec(this.dfs);
                spec.conversionCharacter = '\u0000';
                spec.literal = "%";
                this.conversions.add(spec);
                return;
            }
            if (this.currentSpec.leadingZeros && this.currentSpec.leftJustify) {
                this.currentSpec.leadingZeros = false;
            }
            if (this.currentSpec.precisionSet && this.currentSpec.leadingZeros) {
                switch (this.currentSpec.conversionCharacter) {
                    case 'd': 
                    case 'i': 
                    case 'o': 
                    case 'x': {
                        this.currentSpec.leadingZeros = false;
                    }
                }
            }
            if (this.currentSpec.conversionCharacter == 'u') {
                this.currentSpec.leadingSign = false;
                this.currentSpec.leadingSpace = false;
            }
            if (this.currentSpec.conversionCharacter == 'p') {
                this.currentSpec.fieldWidth = 8;
                this.currentSpec.fieldWidthSet = true;
                this.currentSpec.leadingZeros = true;
            }
            if (!this.currentSpec.positionalSpecification) {
                this.currentSpec.argumentPosition = this.currentArgumentIndex++;
            }
            this.setArgumentType(this.currentSpec.argumentPosition, this.currentSpec.parseArgumentType());
            this.conversions.add(this.currentSpec);
        }
    }

    private void setArgumentType(int argumentIndex, ArgumentType argumentType) {
        while (this.argumentTypes.size() < argumentIndex) {
            this.argumentTypes.add(ArgumentType.UNUSED);
        }
        if (argumentIndex == this.argumentTypes.size()) {
            this.argumentTypes.add(argumentType);
        } else {
            this.argumentTypes.set(argumentIndex, argumentType);
        }
    }

    private void consumePosition() {
        int argumentIndex = this.maybeConsumeArgumentIndex();
        if (argumentIndex != -1) {
            this.currentSpec.positionalSpecification = true;
            this.currentSpec.argumentPosition = argumentIndex;
        }
    }

    private void consumeFlags() {
        while (this.hasMoreChars()) {
            char c = this.peek();
            if (c == '\'') {
                this.currentSpec.thousands = true;
            } else if (c == '-') {
                this.currentSpec.leftJustify = true;
                this.currentSpec.leadingZeros = false;
            } else if (c == '+') {
                this.currentSpec.leadingSign = true;
                this.currentSpec.leadingSpace = false;
            } else if (c == ' ') {
                if (!this.currentSpec.leadingSign) {
                    this.currentSpec.leadingSpace = true;
                }
            } else if (c == '#') {
                this.currentSpec.alternateForm = true;
            } else {
                if (c != '0') break;
                if (!this.currentSpec.leftJustify) {
                    this.currentSpec.leadingZeros = true;
                }
            }
            ++this.currentPos;
        }
    }

    private void consumeFieldWidth() {
        this.currentSpec.fieldWidth = 0;
        this.currentSpec.fieldWidthSet = false;
        if (this.consumeIf('*')) {
            this.currentSpec.fieldWidthSet = true;
            this.currentSpec.variableFieldWidth = true;
            int fieldWidthArgumentIndex = this.maybeConsumeArgumentIndex();
            this.currentSpec.argumentPositionForFieldWidth = fieldWidthArgumentIndex != -1 ? fieldWidthArgumentIndex : this.currentArgumentIndex++;
            this.setArgumentType(this.currentSpec.argumentPositionForFieldWidth, ArgumentType.INTEGER);
        } else {
            int digitCount = this.peekDigitCount();
            if (digitCount > 0) {
                this.currentSpec.fieldWidth = this.consumeDigits(digitCount);
                this.currentSpec.fieldWidthSet = true;
            }
        }
    }

    private void consumePrecision() {
        if (this.consumeIf('.')) {
            this.currentSpec.precisionSet = true;
            if (this.consumeIf('*')) {
                this.currentSpec.variablePrecision = true;
                int precisionArgumentIndex = this.maybeConsumeArgumentIndex();
                this.currentSpec.argumentPositionForPrecision = precisionArgumentIndex != -1 ? precisionArgumentIndex : this.currentArgumentIndex++;
                this.setArgumentType(this.currentSpec.argumentPositionForPrecision, ArgumentType.INTEGER);
            } else {
                int digitCount = this.peekDigitCount();
                this.currentSpec.precision = digitCount == 0 ? 0 : this.consumeDigits(digitCount);
            }
        }
    }

    private void consumeSizeFlags() {
        if (!this.consumeIf('z')) {
            if (this.consumeIf('h')) {
                this.currentSpec.optionalh = true;
                this.consumeIf('h');
            } else if (this.consumeIf('l')) {
                this.currentSpec.optionall = true;
                this.consumeIf('l');
            } else if (this.consumeIf('L')) {
                this.currentSpec.optionalL = true;
                this.consumeIf('L');
            }
        }
    }

    private boolean consumeCharacterClass() {
        if (this.consumeIf('[')) {
            this.currentSpec.inverseCharacterClass = this.consumeIf('^');
            this.currentSpec.characterClass = this.consumeCharacterRange();
            return true;
        }
        return false;
    }

    private String consumeCharacterRange() {
        char c;
        StringBuilder s = new StringBuilder();
        while ((c = this.next()) != ']') {
            s.append(c);
        }
        return s.toString();
    }

    private void consumeConversionCharacter() {
        this.currentSpec.conversionCharacter = this.mode == Mode.SCAN && this.consumeCharacterClass() ? (char)115 : this.next();
    }

    private int maybeConsumeArgumentIndex() {
        int digitCount = this.peekDigitCount();
        if (digitCount > 0 && this.formatString.charAt(this.currentPos + digitCount) == '$') {
            int argumentIndex = this.consumeDigits(digitCount) - 1;
            ++this.currentPos;
            return argumentIndex;
        }
        return -1;
    }

    private int peekDigitCount() {
        int digitCount = 0;
        while (this.currentPos + digitCount < this.formatString.length() && Character.isDigit(this.formatString.charAt(this.currentPos + digitCount))) {
            ++digitCount;
        }
        return digitCount;
    }

    private int consumeDigits(int digitCount) {
        int number = Integer.parseInt(this.formatString.substring(this.currentPos, this.currentPos + digitCount));
        this.currentPos += digitCount;
        return number;
    }

    private boolean hasMoreChars() {
        return this.currentPos < this.formatString.length();
    }

    private char peek() {
        return this.formatString.charAt(this.currentPos);
    }

    private void pushBack() {
        --this.currentPos;
    }

    private char next() {
        return this.formatString.charAt(this.currentPos++);
    }

    private boolean consumeIf(char c) {
        if (this.formatString.charAt(this.currentPos) == c) {
            ++this.currentPos;
            return true;
        }
        return false;
    }

    public List<ArgumentType> getArgumentTypes() {
        return this.argumentTypes;
    }

    public ArgumentType getArgumentType(int i) {
        if (i < this.argumentTypes.size()) {
            return this.argumentTypes.get(i);
        }
        return ArgumentType.UNUSED;
    }

    public String format(FormatInput input) {
        StringBuilder result = new StringBuilder();
        for (FormatSpec conversion : this.conversions) {
            result.append(conversion.format(input));
        }
        return result.toString();
    }

    public static String format(String formatString, Object ... arguments) {
        return new Formatter(formatString).format(new FormatArrayInput(arguments));
    }

    public int scan(CharIterator it, Object[] output) {
        if (!it.hasMore()) {
            return -1;
        }
        int matchCount = 0;
        for (FormatSpec conversion : this.conversions) {
            Ptr outputPtr;
            if (!it.hasMore() || !this.scan(conversion, it, outputPtr = (Ptr)output[conversion.argumentPosition])) break;
            if (conversion.conversionCharacter == '\u0000') continue;
            ++matchCount;
        }
        return matchCount;
    }

    private boolean scan(FormatSpec conversion, CharIterator it, Ptr outputPtr) {
        switch (conversion.conversionCharacter) {
            case '\u0000': {
                return this.scanLiteral(conversion, it);
            }
            case 's': {
                return this.scanString(conversion, it, outputPtr);
            }
            case 'd': {
                return this.scanInteger(conversion, it, outputPtr);
            }
        }
        throw new UnsupportedOperationException("TODO: " + conversion.conversionCharacter);
    }

    private boolean scanLiteral(FormatSpec conversion, CharIterator it) {
        for (int i = 0; i < conversion.literal.length(); ++i) {
            if (!it.hasMore()) {
                return false;
            }
            char c = it.next();
            if (c == conversion.literal.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private boolean scanString(FormatSpec conversion, CharIterator it, Ptr outputPtr) {
        char c2;
        StringBuilder s = new StringBuilder();
        CharPredicator predicate = conversion.characterClass == null ? c -> !Character.isWhitespace(c) : (conversion.inverseCharacterClass ? c -> conversion.characterClass.indexOf(c) == -1 : c -> conversion.characterClass.indexOf(c) != -1);
        while (it.hasMore() && predicate.test(c2 = it.peek())) {
            s.append(c2);
            it.next();
        }
        if (s.length() == 0) {
            return false;
        }
        byte[] bytes = s.toString().getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < bytes.length; ++i) {
            outputPtr.setByte(i, bytes[i]);
        }
        outputPtr.setByte(bytes.length, (byte)0);
        return true;
    }

    private boolean scanInteger(FormatSpec conversion, CharIterator it, Ptr outputPtr) {
        char c;
        int sign = 1;
        char firstChar = it.peek();
        if (firstChar == '+') {
            it.next();
        } else if (firstChar == '-') {
            sign = -1;
            it.next();
        }
        StringBuilder s = new StringBuilder();
        while (it.hasMore() && (c = it.peek()) >= '0' && c <= '9') {
            s.append(c);
            it.next();
        }
        if (s.length() == 0) {
            return false;
        }
        long value = Long.parseLong(s.toString());
        if (sign < 0) {
            value = -value;
        }
        if (conversion.optionall) {
            outputPtr.setLong(value);
        } else if (conversion.optionalh) {
            outputPtr.setShort((short)value);
        } else {
            outputPtr.setInt((int)value);
        }
        return true;
    }

    public static enum ArgumentType {
        INTEGER,
        DOUBLE,
        POINTER,
        UNUSED,
        LONG,
        STRING;

    }

    public static enum Mode {
        PRINT,
        SCAN;

    }
}

