/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.format;

import org.renjin.gcc.format.FormatInput;
import org.renjin.gcc.format.Formatter;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;

public class VarArgsInput
implements FormatInput {
    private Formatter formatter;
    private Ptr argumentList;
    private int[] offsets;

    public VarArgsInput(Formatter formatter, Ptr argumentList) {
        this.formatter = formatter;
        this.argumentList = argumentList;
        this.offsets = new int[formatter.getArgumentTypes().size()];
        int offset = 0;
        block6: for (int i = 0; i < this.offsets.length; ++i) {
            this.offsets[i] = offset;
            switch (formatter.getArgumentType(i)) {
                case INTEGER: 
                case POINTER: 
                case STRING: {
                    offset += 4;
                    continue block6;
                }
                case DOUBLE: {
                    offset += 8;
                    continue block6;
                }
                case UNUSED: {
                    continue block6;
                }
                case LONG: {
                    offset += 8;
                }
            }
        }
    }

    @Override
    public boolean isNA(int argumentIndex) {
        return false;
    }

    @Override
    public int getInt(int argumentIndex) {
        return this.argumentList.getInt(this.offsets[argumentIndex]);
    }

    @Override
    public long getLong(int argumentIndex) {
        return this.argumentList.getLong(this.offsets[argumentIndex]);
    }

    @Override
    public long getUnsignedLong(int argumentIndex) {
        return this.argumentList.getLong(this.offsets[argumentIndex]);
    }

    @Override
    public double getDouble(int argumentIndex) {
        return this.argumentList.getDouble(this.offsets[argumentIndex]);
    }

    @Override
    public String getString(int argumentIndex) {
        return Stdlib.nullTerminatedString(this.argumentList.getPointer(this.offsets[argumentIndex]));
    }
}

