/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Realloc;

public class BooleanPtr
extends AbstractPtr
implements Ptr {
    public static final BooleanPtr NULL = new BooleanPtr();
    public final boolean[] array;
    public final int offset;

    public static BooleanPtr malloc(int bytes) {
        return new BooleanPtr(new boolean[bytes]);
    }

    private BooleanPtr() {
        this.array = null;
        this.offset = 0;
    }

    public BooleanPtr(boolean[] array, int offset) {
        this.array = array;
        this.offset = offset;
    }

    public BooleanPtr(boolean ... values) {
        this.array = values;
        this.offset = 0;
    }

    public boolean unwrap() {
        return this.array[this.offset];
    }

    public boolean[] getArray() {
        return this.array;
    }

    @Override
    public int getOffsetInBytes() {
        return this.offset;
    }

    @Override
    public BooleanPtr realloc(int newSizeInBytes) {
        return new BooleanPtr(Realloc.realloc(this.array, this.offset, newSizeInBytes));
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        return new BooleanPtr(this.array, this.offset + bytes);
    }

    @Override
    public byte getByte(int offset) {
        return this.array[offset] ? (byte)1 : 0;
    }

    @Override
    public void setByte(int offset, byte value) {
        this.array[offset] = value != 0;
    }

    @Override
    public int toInt() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean isNull() {
        return this.array == null && this.offset == 0;
    }

    public static BooleanPtr cast(Object voidPointer) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).booleanPtr();
        }
        return (BooleanPtr)voidPointer;
    }
}

