/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.PointerPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Realloc;

public class BytePtr
extends AbstractPtr {
    public static final BytePtr NULL = new BytePtr();
    public final byte[] array;
    public final int offset;

    private BytePtr() {
        this.array = null;
        this.offset = 0;
    }

    public BytePtr(byte ... array) {
        this(array, 0);
    }

    public BytePtr(byte[] array, int offset) {
        this.array = array;
        this.offset = offset;
    }

    public static Ptr of(int value) {
        return NULL.pointerPlus(value);
    }

    public byte get() {
        return this.array[this.offset];
    }

    public void set(byte value) {
        this.array[this.offset] = value;
    }

    public static byte[] toArray(String constant) {
        return constant.getBytes(StandardCharsets.UTF_8);
    }

    public static BytePtr asciiString(String string) {
        return new BytePtr(string.getBytes(StandardCharsets.US_ASCII), 0);
    }

    public static BytePtr nullTerminatedString(String string, Charset charset) {
        byte[] bytes = string.getBytes(charset);
        byte[] nullTerminatedBytes = Arrays.copyOf(bytes, bytes.length + 1);
        return new BytePtr(nullTerminatedBytes, 0);
    }

    public int nullTerminatedStringLength() {
        for (int i = this.offset; i < this.array.length; ++i) {
            if (this.array[i] != 0) continue;
            return i - this.offset;
        }
        throw new IllegalStateException("String is not null-terminated.");
    }

    public String nullTerminatedString() {
        return new String(this.array, this.offset, this.nullTerminatedStringLength(), StandardCharsets.UTF_8);
    }

    public String toString(int length) {
        return new String(this.array, this.offset, length, StandardCharsets.UTF_8);
    }

    public static BytePtr malloc(int bytes) {
        return new BytePtr(new byte[bytes]);
    }

    public static BytePtr fromString(String string) {
        return new BytePtr(string.getBytes(), 0);
    }

    public static void memset(byte[] str, int strOffset, int c, int n) {
        Arrays.fill(str, strOffset, strOffset + n, (byte)c);
    }

    public static byte memset(int c) {
        return (byte)c;
    }

    public byte[] getArray() {
        return this.array;
    }

    private int getOffset() {
        return this.offset;
    }

    @Override
    public int getOffsetInBytes() {
        return this.offset;
    }

    @Override
    public BytePtr realloc(int newSizeInBytes) {
        return new BytePtr(Realloc.realloc(this.array, this.offset, newSizeInBytes));
    }

    @Override
    public BytePtr copyOf(int numBytes) {
        return new BytePtr(Arrays.copyOf(this.array, numBytes));
    }

    @Override
    public void memcpy(Ptr source, int numBytes) {
        if (source instanceof BytePtr) {
            BytePtr sourceBytePtr = (BytePtr)source;
            System.arraycopy(sourceBytePtr.array, sourceBytePtr.offset, this.array, this.offset, numBytes);
        } else {
            super.memcpy(source, numBytes);
        }
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes == 0) {
            return this;
        }
        return new BytePtr(this.array, this.offset + bytes);
    }

    @Override
    public byte getByte(int offset) {
        return this.array[this.offset + offset];
    }

    @Override
    public void setByte(int offset, byte value) {
        this.array[this.offset + offset] = value;
    }

    @Override
    public int toInt() {
        return this.offset;
    }

    @Override
    public boolean isNull() {
        return this.array == null && this.offset == 0;
    }

    public static BytePtr cast(Object voidPointer) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).bytePtr();
        }
        if (voidPointer == null) {
            return NULL;
        }
        return (BytePtr)voidPointer;
    }

    public static int memcmp(BytePtr s1, BytePtr s2, int len) {
        for (int i = 0; i < len; ++i) {
            byte b1 = s1.array[s1.offset + i];
            byte b2 = s2.array[s2.offset + i];
            if (b1 == b2) continue;
            int i1 = b1 & 0xFF;
            int i2 = b2 & 0xFF;
            return i1 - i2;
        }
        return 0;
    }

    public static void memcpy(BytePtr x, BytePtr y, int numBytes) {
        int offsetS;
        byte[] arrayS = y.getArray();
        int restY = arrayS.length - (offsetS = y.getOffset());
        if (restY > 0) {
            byte[] carray = new byte[numBytes];
            int i = 0;
            for (int j = offsetS; j < arrayS.length && i < numBytes; ++j, ++i) {
                carray[i] = arrayS[j];
            }
            x = new BytePtr(carray);
        }
    }

    public static Ptr stringArray(String string) {
        return BytePtr.stringArray(string.getBytes(StandardCharsets.US_ASCII));
    }

    public static Ptr stringArrayFromResource(Class clazz, String resourceName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        try (InputStream in = clazz.getResourceAsStream(resourceName);){
            int r;
            while ((r = in.read(buffer)) != -1) {
                baos.write(buffer, 0, r);
            }
        }
        return BytePtr.stringArray(baos.toByteArray());
    }

    private static Ptr stringArray(byte[] bytes) {
        ArrayList<BytePtr> pointers = new ArrayList<BytePtr>();
        int start = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 0) continue;
            pointers.add(new BytePtr(bytes, start));
            start = i + 1;
        }
        return new PointerPtr(pointers.toArray(new Ptr[0]));
    }

    public String toString() {
        byte b;
        if (this.array == null) {
            if (this.offset == 0) {
                return "NULL";
            }
            return "NULL+" + this.offset;
        }
        StringBuilder s = new StringBuilder();
        for (int i = this.offset; i < this.array.length && (b = this.array[i]) != 0; ++i) {
            if (b < 32 || b >= 126) continue;
            s.appendCodePoint(b);
        }
        if (s.length() > 0) {
            return "BytePtr{\"" + s.toString() + "\"}";
        }
        return "BytePtr{" + Integer.hashCode(System.identityHashCode(this.array)) + "+" + this.offset + "}";
    }
}

