/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.lang.reflect.Field;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;

public class CharFieldPtr
extends AbstractPtr {
    private final Field field;

    public static Ptr addressOf(Class declaringClass, String fieldName) {
        try {
            return new CharFieldPtr(declaringClass.getField(fieldName));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public CharFieldPtr(Field field) {
        this.field = field;
    }

    @Override
    public Object getArray() {
        return this.field;
    }

    @Override
    public final int getOffsetInBytes() {
        return 0;
    }

    @Override
    public Ptr realloc(int newSizeInBytes) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes == 0) {
            return this;
        }
        return new OffsetPtr(this, bytes);
    }

    @Override
    public char getChar() {
        try {
            return this.field.getChar(null);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    @Override
    public void setChar(char value) {
        try {
            this.field.setChar(null, value);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    @Override
    public char getChar(int offset) {
        if (offset == 0) {
            return this.getChar();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setChar(int offset, char intValue) {
        if (offset != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setChar(intValue);
    }

    @Override
    public char getAlignedChar(int index) {
        if (index == 0) {
            return this.getChar();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setAlignedChar(int index, char value) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setChar(value);
    }

    @Override
    public byte getByte(int offset) {
        return this.getByteViaChar(offset);
    }

    @Override
    public void setByte(int offset, byte value) {
        this.setByteViaChar(offset, value);
    }

    @Override
    public int toInt() {
        return 0;
    }

    @Override
    public boolean isNull() {
        return false;
    }
}

