/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.renjin.gcc.runtime.AbstractFileHandle;

public class FileHandleImpl
extends AbstractFileHandle {
    private RandomAccessFile file;

    public FileHandleImpl(RandomAccessFile file) {
        this.file = file;
    }

    @Override
    public int read() throws IOException {
        return this.file.read();
    }

    @Override
    public void write(int b) throws IOException {
        this.file.write(b);
    }

    @Override
    public void rewind() throws IOException {
        this.file.seek(0L);
    }

    @Override
    public void flush() throws IOException {
        this.file.getFD().sync();
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public void seekSet(long offset) throws IOException {
        this.file.seek(offset);
    }

    @Override
    public void seekCurrent(long relativeOffset) throws IOException {
        this.file.seek(this.file.getFilePointer() + relativeOffset);
    }

    @Override
    public void seekEnd(long relativeOffset) throws IOException {
        long offset = this.file.length() - relativeOffset - 1L;
        this.file.seek(offset);
    }

    @Override
    public boolean isEof() {
        try {
            return this.file.getFilePointer() >= this.file.length();
        }
        catch (IOException e) {
            return true;
        }
    }

    @Override
    public long position() throws IOException {
        return this.file.getFilePointer();
    }
}

