/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.util.Arrays;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Realloc;

public class FloatPtr
extends AbstractPtr {
    public static final int BYTES = 4;
    public static final FloatPtr NULL = new FloatPtr();
    public final float[] array;
    public final int offset;

    private FloatPtr() {
        this.array = null;
        this.offset = 0;
    }

    public FloatPtr(float[] array, int offset) {
        this.array = array;
        this.offset = offset;
    }

    public FloatPtr(float ... values) {
        this.array = values;
        this.offset = 0;
    }

    public static FloatPtr malloc(int bytes) {
        return new FloatPtr(new float[AbstractPtr.mallocSize(bytes, 4)]);
    }

    public float[] getArray() {
        return this.array;
    }

    private int getOffset() {
        return this.offset;
    }

    @Override
    public int getOffsetInBytes() {
        return this.offset * 4;
    }

    @Override
    public Ptr realloc(int newSizeInBytes) {
        return new FloatPtr(Realloc.realloc(this.array, this.offset, FloatPtr.mallocSize(newSizeInBytes, 4)));
    }

    @Override
    public float getFloat() {
        return this.array[this.offset];
    }

    @Override
    public float getFloat(int offset) {
        return this.array[this.offset + offset / 4];
    }

    @Override
    public float getAlignedFloat(int index) {
        return this.array[this.offset + index];
    }

    @Override
    public void setFloat(float value) {
        this.array[this.offset] = value;
    }

    @Override
    public void setFloat(int offset, float value) {
        this.array[this.offset + offset / 4] = value;
    }

    @Override
    public void setAlignedFloat(int index, float value) {
        this.array[this.offset + index] = value;
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes % 4 == 0) {
            return new FloatPtr(this.array, this.offset + bytes / 4);
        }
        return new OffsetPtr(this, bytes);
    }

    @Override
    public byte getByte(int offset) {
        return this.getByteViaFloat(offset);
    }

    @Override
    public void setByte(int offset, byte value) {
        this.setByteViaFloat(offset, value);
    }

    @Override
    public int toInt() {
        return this.offset * 4;
    }

    @Override
    public boolean isNull() {
        return this.array == null && this.offset == 0;
    }

    public String toString() {
        return this.offset + "+" + Arrays.toString(this.array);
    }

    public float unwrap() {
        return this.array[this.offset];
    }

    public float get(int i) {
        return this.array[this.offset + i];
    }

    public void set(int index, float value) {
        this.array[this.offset + index] = value;
    }

    public static void memset(double[] str, int strOffset, int c, int n) {
        assert (n % 4 == 0);
        float floatValue = FloatPtr.memset(c);
        Arrays.fill(str, strOffset, strOffset + n / 4, (double)floatValue);
    }

    public static float memset(int c) {
        return Float.intBitsToFloat(IntPtr.memset(c));
    }

    public static FloatPtr cast(Object voidPointer) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).floatPtr();
        }
        if (voidPointer == null) {
            return NULL;
        }
        return (FloatPtr)voidPointer;
    }

    public static void memcpy(FloatPtr x, FloatPtr y, int numBytes) {
        int offsetS;
        float[] arrayS = y.getArray();
        int restY = arrayS.length - (offsetS = y.getOffset());
        if (restY > 0) {
            float[] carray = new float[numBytes];
            int i = 0;
            for (int j = offsetS; j < arrayS.length && i < numBytes; ++j, ++i) {
                carray[i] = arrayS[j];
            }
            x = new FloatPtr(carray);
        }
    }
}

