/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.FunctionPtr1;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;

public class FunctionPtr
extends AbstractPtr {
    private static MethodHandle BAD_HANDLE;
    public static final int BYTES = 4;
    private MethodHandle[] array;
    private int offset;

    public FunctionPtr(MethodHandle[] array, int offset) {
        this.array = array;
        this.offset = offset;
    }

    @Override
    public Object getArray() {
        return this.array;
    }

    @Override
    public int getOffsetInBytes() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Ptr realloc(int newSizeInBytes) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes % 4 == 0) {
            return new FunctionPtr(this.array, this.offset + bytes / 4);
        }
        return new OffsetPtr(this, bytes);
    }

    @Override
    public byte getByte(int offset) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void setByte(int offset, byte value) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public int toInt() {
        return this.offset * 4;
    }

    @Override
    public boolean isNull() {
        return this.array == null;
    }

    @Override
    public Ptr getPointer(int offset) {
        if (offset % 4 == 0) {
            return new FunctionPtr1(this.array[this.offset + offset / 4]);
        }
        throw new UnsupportedOperationException("Unaligned pointer access");
    }

    @Override
    public MethodHandle toMethodHandle() {
        return this.array[0];
    }

    public static void invalidFunction() {
        throw new RuntimeException("Not a function pointer. SEGFAULT.");
    }

    public static MethodHandle getBadHandle() {
        if (BAD_HANDLE == null) {
            try {
                BAD_HANDLE = MethodHandles.publicLookup().findStatic(FunctionPtr.class, "invalidFunction", MethodType.methodType(Void.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
        return BAD_HANDLE;
    }
}

