/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.lang.reflect.Field;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;

public class IntFieldPtr
extends AbstractPtr {
    private final Field field;

    public static Ptr addressOf(Class declaringClass, String fieldName) {
        try {
            return new IntFieldPtr(declaringClass.getField(fieldName));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public IntFieldPtr(Field field) {
        this.field = field;
    }

    @Override
    public Object getArray() {
        return this.field;
    }

    @Override
    public final int getOffsetInBytes() {
        return 0;
    }

    @Override
    public Ptr realloc(int newSizeInBytes) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes == 0) {
            return this;
        }
        return new OffsetPtr(this, bytes);
    }

    @Override
    public int getInt() {
        try {
            return this.field.getInt(null);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    @Override
    public void setInt(int value) {
        try {
            this.field.setInt(null, value);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    @Override
    public int getInt(int offset) {
        if (offset == 0) {
            return this.getInt();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setInt(int offset, int intValue) {
        if (offset != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setInt(intValue);
    }

    @Override
    public int getAlignedInt(int index) {
        if (index == 0) {
            return this.getInt();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setAlignedInt(int index, int value) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setInt(value);
    }

    @Override
    public byte getByte(int offset) {
        return this.getByteViaInt(offset);
    }

    @Override
    public void setByte(int offset, byte value) {
        this.setByteViaInt(offset, value);
    }

    @Override
    public int toInt() {
        return 0;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntFieldPtr)) {
            return false;
        }
        IntFieldPtr that = (IntFieldPtr)o;
        return this.field.equals(that.field);
    }

    public int hashCode() {
        return this.field.hashCode();
    }
}

