/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.lang.reflect.Constructor;
import org.renjin.gcc.annotations.GccSize;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.BooleanPtr;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.CharPtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.FloatPtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.LongPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.ShortPtr;

public class MallocThunk
extends AbstractPtr {
    public int bytes;
    public Object pointer = null;

    public MallocThunk(int bytes) {
        this.bytes = bytes;
    }

    public BooleanPtr booleanPtr() {
        if (this.pointer == null) {
            this.pointer = new BooleanPtr(new boolean[this.bytes]);
        }
        return (BooleanPtr)this.pointer;
    }

    public BytePtr bytePtr() {
        if (this.pointer == null) {
            this.pointer = new BytePtr(new byte[this.bytes]);
        }
        return (BytePtr)this.pointer;
    }

    public ShortPtr shortPtr() {
        if (this.pointer == null) {
            this.pointer = new ShortPtr(new short[this.bytes / 2]);
        }
        return (ShortPtr)this.pointer;
    }

    public CharPtr charPtr() {
        if (this.pointer == null) {
            this.pointer = new CharPtr(new char[this.bytes / 2]);
        }
        return (CharPtr)this.pointer;
    }

    public IntPtr intPtr() {
        if (this.pointer == null) {
            this.pointer = new IntPtr(new int[this.bytes / 4]);
        }
        return (IntPtr)this.pointer;
    }

    public LongPtr longPtr() {
        if (this.pointer == null) {
            this.pointer = new LongPtr(new long[this.bytes / 8]);
        }
        return (LongPtr)this.pointer;
    }

    public FloatPtr floatPtr() {
        if (this.pointer == null) {
            this.pointer = new FloatPtr(new float[this.bytes / 4]);
        }
        return (FloatPtr)this.pointer;
    }

    public DoublePtr doublePtr() {
        if (this.pointer == null) {
            this.pointer = new DoublePtr(new double[this.bytes / 8], 0);
        }
        return (DoublePtr)this.pointer;
    }

    public <T> T recordUnitPtr(Class<T> recordType) {
        if (this.pointer == null) {
            if (this.bytes != this.sizeOf(recordType)) {
                throw new IllegalStateException(String.format("Misclassified record pointer: %s (bug in gcc-bridge compilation)", recordType.getName()));
            }
            Constructor<?> constructor = this.constructorFor(recordType);
            try {
                this.pointer = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to malloc element of type " + recordType.getClass().getName(), e);
            }
        }
        return (T)this.pointer;
    }

    private Constructor<?> constructorFor(Class<?> componentType) {
        Constructor<?> constructor;
        try {
            constructor = componentType.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(String.format("Cannot malloc array for class %s: no default constructor.", componentType.getName()), e);
        }
        return constructor;
    }

    private int sizeOf(Class<?> componentType) {
        GccSize size = componentType.getAnnotation(GccSize.class);
        if (size == null) {
            throw new IllegalStateException(String.format("Cannot malloc array for class %s: @GccSize annotation is absent.", componentType.getName()));
        }
        int sizeInBytes = size.value();
        if (sizeInBytes <= 0) {
            throw new IllegalStateException(String.format("Cannot malloc array for class %s: @GccSize = %d", componentType.getName(), sizeInBytes));
        }
        return sizeInBytes;
    }

    public void assign(Object[] array, int offset) {
        if (this.pointer == null) {
            this.pointer = this.allocElement(array);
        }
        array[offset] = this.pointer;
    }

    private Object allocElement(Object[] array) {
        if (array instanceof BooleanPtr[]) {
            return this.booleanPtr();
        }
        if (array instanceof BytePtr[]) {
            return this.bytePtr();
        }
        if (array instanceof CharPtr[]) {
            return this.charPtr();
        }
        if (array instanceof DoublePtr[]) {
            return this.doublePtr();
        }
        if (array instanceof FloatPtr[]) {
            return this.floatPtr();
        }
        if (array instanceof IntPtr[]) {
            return this.intPtr();
        }
        if (array instanceof LongPtr[]) {
            return this.longPtr();
        }
        if (array instanceof ShortPtr[]) {
            return this.shortPtr();
        }
        Class<?> componentType = array.getClass().getComponentType();
        try {
            return componentType.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while triggering malloc thunk for " + componentType.getName(), e);
        }
    }

    public static Object malloc(int size) {
        return new MallocThunk(size);
    }

    public static Object calloc(int numElements, int elementSize) {
        return new MallocThunk(numElements * elementSize);
    }

    public static void free(Object ptr) {
    }

    @Override
    public Object getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getOffsetInBytes() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Ptr realloc(int newSizeInBytes) {
        if (this.pointer != null) {
            return ((Ptr)this.pointer).realloc(newSizeInBytes);
        }
        return new MallocThunk(newSizeInBytes);
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public byte getByte(int offset) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void setByte(int offset, byte value) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public int toInt() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean isNull() {
        return false;
    }
}

