/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;

public class Mathlib {
    public static final double FLT_RADIX = 2.0;
    private static final double LN_FLT_RADIX = Mathlib.log(2.0);
    private static final double LN_2 = Mathlib.log(2.0);

    public static double acos(double x) {
        return Math.acos(x);
    }

    public static double asin(double x) {
        return Math.asin(x);
    }

    public static double atan(double x) {
        return Math.atan(x);
    }

    public static double atan2(double y, double x) {
        return Math.atan2(y, x);
    }

    public static double cos(double x) {
        return Math.cos(x);
    }

    public static double cosh(double x) {
        return Math.cosh(x);
    }

    public static double sin(double x) {
        return Math.sin(x);
    }

    public static double tan(double x) {
        return Math.tan(x);
    }

    public static double sinh(double x) {
        return Math.sinh(x);
    }

    public static double tanh(double x) {
        return Math.tanh(x);
    }

    public static double exp(double x) {
        return Math.exp(x);
    }

    public static double expm1(double x) {
        return Math.expm1(x);
    }

    public static double frexp(double value, IntPtr pExponent) {
        long bits = Double.doubleToRawLongBits(value);
        double realMant = 1.0;
        if (Double.isNaN(value) || value + value == value || Double.isInfinite(value)) {
            pExponent.set(0);
            return value;
        }
        boolean neg = bits < 0L;
        int exponent = (int)(bits >> 52 & 0x7FFL);
        long mantissa = bits & 0xFFFFFFFFFFFFFL;
        if (exponent == 0) {
            ++exponent;
        } else {
            mantissa |= 0x10000000000000L;
        }
        exponent -= 1075;
        realMant = mantissa;
        while (realMant >= 1.0) {
            mantissa >>= 1;
            realMant /= 2.0;
            ++exponent;
        }
        if (neg) {
            realMant *= -1.0;
        }
        pExponent.set(exponent);
        return realMant;
    }

    public static double ldexp(double x, int d) {
        while (d > 0) {
            x *= 2.0;
            --d;
        }
        while (d < 0) {
            x *= 0.5;
            ++d;
        }
        return x;
    }

    public static double log(double x) {
        return Math.log(x);
    }

    public static double log2(double x) {
        return Math.log(x) / LN_2;
    }

    public static double logb(double x) {
        return Math.floor(Math.log(Math.abs(x)) / LN_FLT_RADIX);
    }

    public static double log10(double x) {
        return Math.log10(x);
    }

    public static double log1p(double x) {
        return Math.log1p(x);
    }

    public static double modf(double x, DoublePtr pInteger) {
        double intValue = x < 0.0 ? Math.ceil(x) : Math.floor(x);
        double fracValue = x - intValue;
        pInteger.set(intValue);
        return fracValue;
    }

    public static double pow(double x, double y) {
        return Math.pow(x, y);
    }

    public static double sqrt(double x) {
        return Math.sqrt(x);
    }

    public static float sqrtf(float x) {
        return (float)Math.sqrt(x);
    }

    public static double cbrt(double x) {
        return Math.cbrt(x);
    }

    public static double hypot(double x, double y) {
        return Math.hypot(x, y);
    }

    public static double ceil(double x) {
        return Math.ceil(x);
    }

    public static double fabs(double x) {
        return Math.abs(x);
    }

    public static double floor(double x) {
        return Math.floor(x);
    }

    public static double trunc(double x) {
        if (x > 0.0) {
            return Math.floor(x);
        }
        return Math.ceil(x);
    }

    public static double round(double x) {
        return Math.rint(x);
    }

    public static double rint(double x) {
        return Math.rint(x);
    }

    public static long lround(double x) {
        return Math.round(x);
    }

    public static long lrint(double x) {
        return (long)Mathlib.rint(x);
    }

    public static double fmod(double x, double y) {
        return x % y;
    }

    public static double fmax(double x, double y) {
        return Math.max(x, y);
    }

    public static double fmin(double x, double y) {
        return Math.min(x, y);
    }

    public static double erf(double x) {
        throw new UnsupportedOperationException();
    }

    public static double erfc(double x) {
        throw new UnsupportedOperationException();
    }

    public static double tgamma(double x) {
        throw new UnsupportedOperationException();
    }

    public static double lgamma(double x) {
        throw new UnsupportedOperationException();
    }

    public static double copysign(double x, double y) {
        return Math.copySign(x, y);
    }

    public static float copysignf(float x, float y) {
        return Math.copySign(x, y);
    }
}

