/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Ptr;

public class MixedPtr
extends AbstractPtr {
    private static final int POINTER_BYTES = 4;
    private ByteBuffer primitives;
    private Object[] references;
    private int offset = 0;

    private MixedPtr() {
    }

    private MixedPtr(ByteBuffer primitives, Object[] references, int offset) {
        this.primitives = primitives;
        this.references = references;
        this.offset = offset;
    }

    public static MixedPtr malloc(int bytes) {
        MixedPtr ptr = new MixedPtr();
        try {
            ptr.primitives = ByteBuffer.allocateDirect(bytes).order(ByteOrder.nativeOrder());
            ptr.references = new Object[MixedPtr.mallocSize(bytes, 4)];
        }
        catch (OutOfMemoryError e) {
            System.err.println("MixedPtr out of memory");
            throw e;
        }
        return ptr;
    }

    @Override
    public Object getArray() {
        return this.primitives;
    }

    @Override
    public int getOffsetInBytes() {
        return this.offset;
    }

    @Override
    public Ptr realloc(int newSizeInBytes) {
        if (newSizeInBytes == this.primitives.capacity()) {
            return this;
        }
        ByteBuffer source = this.primitives.asReadOnlyBuffer();
        source.position(0);
        source.limit(Math.min(source.capacity(), newSizeInBytes));
        ByteBuffer target = ByteBuffer.allocateDirect(newSizeInBytes).order(ByteOrder.nativeOrder());
        target.put(source);
        target.position(0);
        target.limit(newSizeInBytes);
        MixedPtr ptr = new MixedPtr();
        ptr.primitives = target;
        ptr.references = Arrays.copyOf(this.references, MixedPtr.mallocSize(newSizeInBytes, 4));
        return ptr;
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes == 0) {
            return this;
        }
        return new MixedPtr(this.primitives, this.references, this.offset + bytes);
    }

    @Override
    public byte getByte(int offset) {
        return this.primitives.get(this.offset + offset);
    }

    @Override
    public void setByte(int offset, byte value) {
        this.primitives.put(this.offset + offset, value);
    }

    @Override
    public Ptr getPointer(int offset) {
        int index;
        Ptr ref;
        int byteStart = this.offset + offset;
        if (byteStart % 4 == 0 && (ref = (Ptr)this.references[index = byteStart / 4]) != null) {
            return ref;
        }
        return BytePtr.NULL.pointerPlus(this.getInt(offset));
    }

    @Override
    public final void setPointer(int offset, Ptr value) {
        int byteStart = this.offset + offset;
        if (byteStart % 4 != 0) {
            throw new UnsupportedOperationException("Unaligned pointer storage");
        }
        int index = byteStart / 4;
        this.references[index] = value;
        this.setInt(offset, value.toInt());
    }

    @Override
    public double getDouble() {
        return this.primitives.getDouble(this.offset);
    }

    @Override
    public double getDouble(int offset) {
        return this.primitives.getDouble(this.offset + offset);
    }

    @Override
    public double getAlignedDouble(int index) {
        return this.primitives.getDouble(this.offset + index * 8);
    }

    @Override
    public void setAlignedDouble(int index, double value) {
        this.primitives.putDouble(this.offset + index * 8, value);
    }

    @Override
    public void setDouble(double value) {
        this.primitives.putDouble(this.offset, value);
    }

    @Override
    public void setDouble(int offset, double doubleValue) {
        this.primitives.putDouble(this.offset + offset, doubleValue);
    }

    @Override
    public int getInt() {
        return this.primitives.getInt(this.offset);
    }

    @Override
    public int getAlignedInt(int index) {
        return this.primitives.getInt(this.offset + index * 4);
    }

    @Override
    public int getInt(int offset) {
        return this.primitives.getInt(this.offset + offset);
    }

    @Override
    public void setInt(int value) {
        this.primitives.putInt(this.offset, value);
    }

    @Override
    public void setInt(int offset, int intValue) {
        this.primitives.putInt(this.offset + offset, intValue);
    }

    @Override
    public void setAlignedInt(int index, int value) {
        this.primitives.putInt(this.offset + index * 4, value);
    }

    @Override
    public int toInt() {
        return this.getOffsetInBytes();
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public void memcpy(Ptr source, int numBytes) {
        if (source instanceof MixedPtr && numBytes % 4 == 0) {
            MixedPtr ptr = (MixedPtr)source;
            for (int i = 0; i < numBytes; ++i) {
                this.setByte(i, source.getByte(i));
            }
            System.arraycopy(ptr.references, ptr.offset / 4, this.references, this.offset / 4, numBytes / 4);
        } else {
            for (int i = 0; i < numBytes; ++i) {
                this.setByte(i, source.getByte(i));
            }
        }
    }

    @Override
    public Ptr copyOf(int offset, int numBytes) {
        ByteBuffer source = this.primitives.asReadOnlyBuffer();
        source.position(this.offset + offset);
        source.limit(this.offset + offset + numBytes);
        MixedPtr copy = new MixedPtr();
        copy.primitives = ByteBuffer.allocateDirect(numBytes).order(ByteOrder.nativeOrder());
        copy.primitives.put(source);
        copy.primitives.position(0);
        copy.references = Arrays.copyOfRange(this.references, (this.offset + offset) / 4, (this.offset + offset + numBytes) / 4);
        assert (copy.primitives.remaining() == numBytes);
        return copy;
    }
}

