/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.lang.reflect.Field;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;

public class PointerFieldPtr
extends AbstractPtr {
    private final Field field;

    public PointerFieldPtr(Field field) {
        this.field = field;
    }

    public static Ptr addressOf(Class declaringClass, String fieldName) {
        try {
            return new PointerFieldPtr(declaringClass.getField(fieldName));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public Object getArray() {
        return this.field;
    }

    @Override
    public final int getOffsetInBytes() {
        return 0;
    }

    @Override
    public Ptr realloc(int newSizeInBytes) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes == 0) {
            return this;
        }
        return new OffsetPtr(this, bytes);
    }

    @Override
    public Ptr getPointer() {
        try {
            return (Ptr)this.field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    @Override
    public void setPointer(Ptr value) {
        try {
            this.field.set(null, value);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    @Override
    public Ptr getAlignedPointer(int index) {
        if (index == 0) {
            return this.getPointer();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getInt() {
        return this.getPointer().toInt();
    }

    @Override
    public void setInt(int value) {
        this.setPointer(BytePtr.NULL.pointerPlus(value));
    }

    @Override
    public int getInt(int offset) {
        if (offset == 0) {
            return this.getInt();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setInt(int offset, int intValue) {
        if (offset != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setInt(intValue);
    }

    @Override
    public int getAlignedInt(int index) {
        if (index == 0) {
            return this.getInt();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setAlignedInt(int index, int value) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setInt(value);
    }

    @Override
    public byte getByte(int offset) {
        return this.getByteViaInt(offset);
    }

    @Override
    public void setByte(int offset, byte value) {
        this.setByteViaInt(offset, value);
    }

    @Override
    public int toInt() {
        return 0;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PointerFieldPtr)) {
            return false;
        }
        PointerFieldPtr that = (PointerFieldPtr)o;
        return this.field.equals(that.field);
    }

    public int hashCode() {
        return this.field.hashCode();
    }
}

