/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.lang.invoke.MethodHandle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.renjin.gcc.runtime.Ptr;

public class PosixThreads {
    public static final int SUCCESS = 0;
    private static final AtomicInteger NEXT_THREAD_ID = new AtomicInteger(0);
    private static final ConcurrentMap<Integer, PosixThread> THREAD_MAP = new ConcurrentHashMap<Integer, PosixThread>();

    public static int pthread_attr_init(Ptr attr) {
        return 0;
    }

    public static int pthread_attr_destroy(Ptr attr) {
        return 0;
    }

    public static int pthread_create(Ptr thread, Ptr attr, MethodHandle startRoutine, Ptr arg) {
        PosixThread posixThread = new PosixThread(startRoutine, arg);
        posixThread.start();
        int threadId = NEXT_THREAD_ID.incrementAndGet();
        THREAD_MAP.put(threadId, posixThread);
        thread.setInt(threadId);
        return 0;
    }

    public static int pthread_join(int threadId, Ptr valuePtr) {
        PosixThread posixThread = (PosixThread)THREAD_MAP.get(threadId);
        try {
            posixThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        valuePtr.setPointer(posixThread.result);
        return 0;
    }

    public static int pthread_mutex_init(Ptr mutex, Ptr attr) {
        return 0;
    }

    public static int pthread_mutexattr_init(Ptr attr) {
        return 0;
    }

    public static int pthread_mutexattr_gettype(Ptr attr, Ptr type) {
        throw new UnsupportedOperationException("TODO");
    }

    public static int pthread_mutexattr_settype(Ptr attr, int type) {
        return 0;
    }

    public static int pthread_mutex_lock(Ptr mutex) {
        return 0;
    }

    public static int pthread_mutex_trylock(Ptr mutex) {
        return 0;
    }

    public static int pthread_mutex_unlock(Ptr mutex) {
        return 0;
    }

    public static int pthread_mutex_destroy(Ptr mutex) {
        return 0;
    }

    public static int pthread_mutexattr_destroy(Ptr attr) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int pthread_once(Ptr onceControl, MethodHandle initRoutine) throws Throwable {
        Object object = onceControl.getArray();
        synchronized (object) {
            if (onceControl.getInt(0) == 0) {
                onceControl.setInt(0, 1);
                initRoutine.invoke();
            }
        }
        return 0;
    }

    private static class PosixThread
    extends Thread {
        private MethodHandle startRoutine;
        private Ptr arg;
        private Ptr result;

        public PosixThread(MethodHandle startRoutine, Ptr arg) {
            this.startRoutine = startRoutine;
            this.arg = arg;
        }

        @Override
        public synchronized void start() {
            try {
                this.result = this.startRoutine.invoke(this.arg);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

