/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.lang.reflect.Field;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;

public class ShortFieldPtr
extends AbstractPtr {
    private final Field field;

    public static Ptr addressOf(Class declaringClass, String fieldName) {
        try {
            return new ShortFieldPtr(declaringClass.getField(fieldName));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public ShortFieldPtr(Field field) {
        this.field = field;
    }

    @Override
    public Object getArray() {
        return this.field;
    }

    @Override
    public final int getOffsetInBytes() {
        return 0;
    }

    @Override
    public Ptr realloc(int newSizeInBytes) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes == 0) {
            return this;
        }
        return new OffsetPtr(this, bytes);
    }

    @Override
    public short getShort() {
        try {
            return this.field.getShort(null);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    @Override
    public void setShort(short value) {
        try {
            this.field.setShort(null, value);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    @Override
    public short getShort(int offset) {
        if (offset == 0) {
            return this.getShort();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setShort(int offset, short intValue) {
        if (offset != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setShort(intValue);
    }

    @Override
    public short getAlignedShort(int index) {
        if (index == 0) {
            return this.getShort();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setAlignedShort(int index, short value) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setShort(value);
    }

    @Override
    public byte getByte(int offset) {
        return this.getByteViaShort(offset);
    }

    @Override
    public void setByte(int offset, byte value) {
        this.setByteViaShort(offset, value);
    }

    @Override
    public int toInt() {
        return 0;
    }

    @Override
    public boolean isNull() {
        return false;
    }
}

